/*
 * Decompiled with CFR 0.152.
 */
package vardwrapper;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import model.Capitalisation;
import model.ConfidenceWeights;
import model.Setup;
import model.SuggestedReplacement;
import model.doc.CannotExecuteException;
import model.doc.DocumentModel;
import model.doc.InvalidInstanceChangeException;
import model.doc.ProcessAllVariantsEdit;
import model.lookup.LookUpDictionary;
import vardwrapper.Normalisation;
import vardwrapper.NormalisationStats;
import vardwrapper.Suggestion;
import vardwrapper.VARDException;

public class VARD {
    private Setup setup = new Setup();
    private LookUpDictionary lud;
    private ConfidenceWeights confidenceWeights;
    private double threshold;

    public VARD(File setupFolder, double threshold, double fWeight, boolean useCache) throws IOException {
        this.setup.readFromFolder(setupFolder);
        this.lud = new LookUpDictionary(this.setup);
        this.lud.setUseCache(useCache);
        this.threshold = threshold;
        this.confidenceWeights = new ConfidenceWeights(this.setup);
        this.confidenceWeights.setFWeight(fWeight);
    }

    public boolean isVariant(String word) {
        return this.lud.checkWords(word) == null;
    }

    public List<Suggestion> getNormalisationSuggestions(String variant, int limit) {
        List<SuggestedReplacement> srs = this.lud.findReplacements(variant, limit, this.confidenceWeights);
        ArrayList<Suggestion> toReturn = new ArrayList<Suggestion>();
        Capitalisation.CapType capitalisation = Capitalisation.getCapitalisation(variant);
        for (SuggestedReplacement sr : srs) {
            toReturn.add(new Suggestion(sr.getReplacementString(capitalisation), sr.getScoreWithoutUpdating()));
        }
        return toReturn;
    }

    public Normalisation normalise(String word) {
        if (!this.isVariant(word)) {
            Normalisation n = new Normalisation(false, false, word, null, 0.0);
            return n;
        }
        List<Suggestion> topList = this.getNormalisationSuggestions(word, 1);
        if (topList.isEmpty()) {
            Normalisation n = new Normalisation(true, false, word, null, 0.0);
            return n;
        }
        Suggestion top = topList.get(0);
        Normalisation n = new Normalisation(true, top.getConfidence() > this.threshold, word, top.getNormalisation(), top.getConfidence());
        return n;
    }

    public String normaliseToString(String word) {
        Normalisation n = this.normalise(word);
        if (n.isNormalised()) {
            return n.getNormalised();
        }
        return word;
    }

    public NormalisationStats normaliseFile(File original, File xmlOut, File plainOut) throws VARDException {
        DocumentModel docModel = new DocumentModel(this.setup, this.confidenceWeights, this.lud);
        try {
            docModel.processNewFile(original);
            new ProcessAllVariantsEdit(this.threshold, false, docModel, this.confidenceWeights, this.lud).execute();
            if (xmlOut != null) {
                docModel.saveWithTags(xmlOut);
            }
            if (plainOut != null) {
                docModel.saveWithoutTags(plainOut);
            }
        }
        catch (BadLocationException e) {
            throw new VARDException(e.getMessage());
        }
        catch (InvalidInstanceChangeException e) {
            throw new VARDException(e.getMessage());
        }
        catch (CannotExecuteException e) {
            throw new VARDException(e.getMessage());
        }
        catch (IOException e) {
            throw new VARDException(e.getMessage());
        }
        return docModel.getNormalisationResults(original.getAbsolutePath());
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
        this.resetCache();
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setUseCache(boolean useCache) {
        this.lud.setUseCache(useCache);
    }

    public boolean isUseCache() {
        return this.lud.isUseCache();
    }

    public void resetCache() {
        this.lud.resetCache();
    }
}

