/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import testbed.input.Inputter;
import testbed.input.StringPair;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;

public class VARDWordDetectTester
extends Tester<TesterOptions> {
    @Override
    public String getName() {
        return "VARD - Word Detector";
    }

    @Override
    public String getOutputName() {
        return "Word Detected";
    }

    @Override
    public void testPair(StringPair pair, Collection<TesterOptions> options) {
        double start = (double)System.nanoTime() / 1000000.0;
        boolean match = this.isWordValid(pair.getSource());
        double processingTime = (double)System.nanoTime() / 1000000.0 - start;
        for (TesterOptions option : options) {
            if (match) {
                this.addScoredPair(option, pair, 1.0, processingTime, pair.getSource());
                continue;
            }
            this.addScoredPair(option, pair, 0.0, processingTime);
        }
    }

    private boolean isWordValid(String word) {
        if (word.contains("--") || word.equals("-")) {
            return false;
        }
        Pattern wordPattern = Pattern.compile("^([\\p{L}\\'\\-\\^~=]|(&[#]?[a-zA-Z0-9]+;))+$");
        Matcher wordMatcher = wordPattern.matcher(word);
        return wordMatcher.matches();
    }

    @Override
    public void createOptions(Inputter inputter) {
        this.options = TesterOptions.createOptions(inputter, this);
    }

    @Override
    public TesterOptions getTesterOptionsInstance() {
        return new TesterOptions(this);
    }
}

