/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.Collection;
import java.util.TreeMap;
import testbed.input.Inputter;
import testbed.options.DoubleOption;
import testbed.options.IntOption;
import testbed.options.Option;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;
import testbed.testing.ThresholdTesterOptions;

public class VARD2TesterOptions
extends ThresholdTesterOptions {
    private int limit;
    protected static TreeMap<Tester<VARD2TesterOptions>, IntOption> limitOptions = new TreeMap();
    private double kv;
    private double se;
    private double lr;
    protected static TreeMap<Tester<VARD2TesterOptions>, DoubleOption> kvOptions = new TreeMap();
    protected static TreeMap<Tester<VARD2TesterOptions>, DoubleOption> seOptions = new TreeMap();
    protected static TreeMap<Tester<VARD2TesterOptions>, DoubleOption> lrOptions = new TreeMap();

    protected int getLimit() {
        return this.limit;
    }

    protected double getKVWeight() {
        return this.kv;
    }

    protected double getSEWeight() {
        return this.se;
    }

    protected double getLRWeight() {
        return this.lr;
    }

    @Override
    protected void setupOutputLabel(Tester<? extends TesterOptions> tester) {
        if (!(kvOptions.get(tester).isConstant() && seOptions.get(tester).isConstant() && lrOptions.get(tester).isConstant())) {
            this.label = String.valueOf(this.label) + " / " + this.kv + "%";
            this.label = String.valueOf(this.label) + " / " + this.se + "%";
            this.label = String.valueOf(this.label) + " / " + this.lr + "%";
        }
        if (limitOptions.get(tester).isConstant()) {
            this.label = String.valueOf(this.label) + " / " + this.limit;
        }
        super.setupOutputLabel(tester);
    }

    protected VARD2TesterOptions(Tester<VARD2TesterOptions> tester) {
        super((Tester<? extends ThresholdTesterOptions>)tester);
        this.kv = (Double)kvOptions.get(tester).next();
        this.se = (Double)seOptions.get(tester).next();
        this.lr = (Double)lrOptions.get(tester).next();
        this.limit = (Integer)limitOptions.get(tester).next();
    }

    protected static Collection<Option<?>> createOptions(Inputter inputter, Tester<VARD2TesterOptions> tester) {
        Collection<Option<?>> options = ThresholdTesterOptions.createOptions(inputter, tester);
        IntOption limitOption = new IntOption("Limit", -1, 100, 1, "");
        options.add(limitOption);
        limitOptions.put(tester, limitOption);
        DoubleOption kvOption = new DoubleOption("Known Variants", 0.0, 100.0, 1.0, "%");
        DoubleOption seOption = new DoubleOption("SoundEx", 0.0, 100.0, 1.0, "%");
        DoubleOption lrOption = new DoubleOption("Letter Replacements", 0.0, 100.0, 1.0, "%");
        kvOptions.put(tester, kvOption);
        seOptions.put(tester, seOption);
        lrOptions.put(tester, lrOption);
        options.add(kvOption);
        options.add(seOption);
        options.add(lrOption);
        return options;
    }

    @Override
    public int compareTo(VARD2TesterOptions o) {
        int c = o.limit - this.limit;
        if (c == 0) {
            c = (int)(o.kv - this.kv);
        }
        if (c == 0) {
            c = (int)(o.se - this.se);
        }
        if (c == 0) {
            c = (int)(o.lr - this.lr);
        }
        if (c == 0) {
            return super.compareTo(o);
        }
        return c;
    }

    @Override
    public int compareTo(TesterOptions o) {
        if (o instanceof VARD2TesterOptions) {
            return this.compareTo((VARD2TesterOptions)o);
        }
        return super.compareTo(o);
    }
}

