/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import model.MethodScores;
import testbed.input.Inputter;
import testbed.options.BooleanOption;
import testbed.options.Option;
import testbed.options.RatioOption;
import testbed.options.SampleOption;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;
import testbed.testing.ThresholdTesterOptions;

public class TrainingTesterOptions
extends ThresholdTesterOptions {
    private double fMeasure;
    private boolean countRealWords;
    protected static BooleanOption realWordOption;
    private File trainingFile;
    private int tokensSeen;
    private HashMap<String, MethodScores> scores;
    protected static TreeMap<Tester<TrainingTesterOptions>, SampleOption> filesOptions;
    protected static TreeMap<Tester<TrainingTesterOptions>, RatioOption> fMeasureOptions;

    static {
        filesOptions = new TreeMap();
        fMeasureOptions = new TreeMap();
    }

    protected TrainingTesterOptions(Tester<TrainingTesterOptions> tester) {
        super((Tester<? extends ThresholdTesterOptions>)tester);
        this.trainingFile = filesOptions.get(tester).nextFile();
        this.tokensSeen = (Integer)filesOptions.get(tester).next();
        this.fMeasure = (Double)fMeasureOptions.get(tester).next();
        this.countRealWords = (Boolean)realWordOption.next();
    }

    protected File getTrainingFile() {
        return this.trainingFile;
    }

    protected double getFMeasure() {
        return this.fMeasure;
    }

    protected int getTokensSeen() {
        return this.tokensSeen;
    }

    protected boolean isCountRealWords() {
        return this.countRealWords;
    }

    public HashMap<String, MethodScores> getScores() {
        return this.scores;
    }

    public void setScores(HashMap<String, MethodScores> scores) {
        LinkedHashMap<String, MethodScores> copy = new LinkedHashMap<String, MethodScores>();
        for (Map.Entry<String, MethodScores> ms : scores.entrySet()) {
            copy.put(ms.getKey(), new MethodScores(ms.getValue()));
        }
        this.scores = scores;
    }

    @Override
    protected void setupOutputLabel(Tester<? extends TesterOptions> tester) {
        if (filesOptions.get(tester).isConstant()) {
            this.label = String.valueOf(this.label) + " / " + this.tokensSeen;
        }
        if (fMeasureOptions.get(tester).isConstant()) {
            this.label = String.valueOf(this.label) + " / " + this.fMeasure;
        }
        if (!this.countRealWords) {
            this.label = String.valueOf(this.label) + " / dismiss real word errors";
        }
        super.setupOutputLabel(tester);
    }

    @Override
    public String getLineValue(Tester<? extends TesterOptions> tester) {
        String field = super.getLineValue(tester);
        if (!filesOptions.get(tester).isConstant() && !filesOptions.get(tester).isPlotted()) {
            field = String.valueOf(field) + this.tokensSeen;
        }
        if (!fMeasureOptions.get(tester).isConstant() && !fMeasureOptions.get(tester).isPlotted()) {
            field = String.valueOf(field) + this.fMeasure;
        }
        return field;
    }

    @Override
    public String getPlotValue(Tester<? extends TesterOptions> tester) {
        if (filesOptions.get(tester).isPlotted()) {
            return String.valueOf(this.tokensSeen);
        }
        if (fMeasureOptions.get(tester).isPlotted()) {
            return String.valueOf(this.fMeasure);
        }
        return super.getPlotValue(tester);
    }

    protected static Collection<Option<?>> createOptions(Inputter inputter, Tester<TrainingTesterOptions> tester) {
        Vector options = new Vector();
        SampleOption filesOption = new SampleOption("Sample Tokens Seen");
        filesOption.setIsPlottable(true);
        filesOptions.put(tester, filesOption);
        options.add(filesOption);
        RatioOption fMeasureOption = new RatioOption("F-Measure", 10);
        fMeasureOption.setIsPlottable(true);
        fMeasureOptions.put(tester, fMeasureOption);
        options.add(fMeasureOption);
        realWordOption = new BooleanOption("Count Real Words");
        options.add(realWordOption);
        Collection<Option<?>> superOptions = ThresholdTesterOptions.createOptions(inputter, tester);
        options.addAll(superOptions);
        return options;
    }

    @Override
    public int compareTo(TrainingTesterOptions other) {
        int c = this.trainingFile.compareTo(other.trainingFile);
        if (c == 0) {
            c = new Double(this.fMeasure).compareTo(other.fMeasure);
        }
        if (c == 0) {
            return super.compareTo(other);
        }
        return c;
    }

    @Override
    public int compareTo(TesterOptions o) {
        if (o instanceof TrainingTesterOptions) {
            return this.compareTo((TrainingTesterOptions)o);
        }
        return super.compareTo(o);
    }
}

