/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.Collection;
import java.util.TreeMap;
import testbed.input.Inputter;
import testbed.options.IntOption;
import testbed.options.Option;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;

public class ThresholdTesterOptions
extends TesterOptions
implements Comparable<TesterOptions> {
    private int threshold;
    protected static TreeMap<Tester<ThresholdTesterOptions>, IntOption> thresholdOptions = new TreeMap();

    protected int getThreshold() {
        return this.threshold;
    }

    @Override
    protected void setupOutputLabel(Tester<? extends TesterOptions> tester) {
        if (!thresholdOptions.get(tester).isConstant()) {
            this.label = String.valueOf(this.label) + " / " + this.threshold + "%";
        }
        super.setupOutputLabel(tester);
    }

    protected ThresholdTesterOptions(Tester<? extends ThresholdTesterOptions> tester) {
        super(tester);
        this.threshold = (Integer)thresholdOptions.get(tester).next();
    }

    protected static Collection<Option<?>> createOptions(Inputter inputter, Tester<ThresholdTesterOptions> tester) {
        Collection<Option<?>> options = TesterOptions.createOptions(inputter, tester);
        IntOption thresholdOption = new IntOption("Threshold", 0, 100, 5, "%");
        thresholdOption.setIsPlottable(true);
        thresholdOptions.put(tester, thresholdOption);
        options.add(thresholdOption);
        return options;
    }

    @Override
    public String getPlotValue(Tester<? extends TesterOptions> tester) {
        if (thresholdOptions.get(tester).isPlotted()) {
            return "" + this.threshold;
        }
        return super.getPlotValue(tester);
    }

    @Override
    public String getLineValue(Tester<? extends TesterOptions> tester) {
        String field = super.getLineValue(tester);
        if (!thresholdOptions.get(tester).isConstant() && !thresholdOptions.get(tester).isPlotted()) {
            field = String.valueOf(field) + this.threshold;
        }
        return field;
    }

    @Override
    public int compareTo(ThresholdTesterOptions o) {
        int c = this.threshold - o.threshold;
        if (c == 0) {
            return super.compareTo(o);
        }
        return c;
    }

    @Override
    public int compareTo(TesterOptions o) {
        if (o instanceof ThresholdTesterOptions) {
            return this.compareTo((ThresholdTesterOptions)o);
        }
        return super.compareTo(o);
    }
}

