/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.TreeMap;
import testbed.input.StringPair;
import testbed.testing.StringPairScores;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;

public class TesterScores<E extends TesterOptions> {
    int totalTypes;
    int tpTypes;
    int fpTypes;
    int totalTokens;
    int tpTokens;
    int fpTokens;
    int totalReplacedTypes;
    int totalReplacedTokens;
    double totalTypesScore;
    double totalTokensScore;
    double totalTypesProcessingTime;
    double totalTokensProcessingTime;
    protected E options;
    protected Tester<E> tester;
    TreeMap<StringPair, StringPairScores> matches;
    TreeMap<StringPair, StringPairScores> nonMatches;

    TesterScores(Tester<E> tester, E options) {
        this.options = options;
        this.tester = tester;
        this.totalTokens = 0;
        this.totalTypes = 0;
        this.tpTokens = 0;
        this.fpTokens = 0;
        this.tpTypes = 0;
        this.fpTypes = 0;
        this.totalTypesScore = 0.0;
        this.totalTokensScore = 0.0;
        this.totalTypesProcessingTime = 0.0;
        this.totalTokensProcessingTime = 0.0;
        this.matches = new TreeMap();
        this.nonMatches = new TreeMap();
        this.totalReplacedTypes = 0;
        this.totalReplacedTokens = 0;
    }

    public double getWouldBeTypesPercentage() {
        return (double)this.totalReplacedTypes / (double)this.totalTypes * 100.0;
    }

    public double getWouldBeTokensPercentage() {
        return (double)this.totalReplacedTokens / (double)this.totalTokens * 100.0;
    }

    public int getNumTypes() {
        return this.tpTypes;
    }

    public int getNumTokens() {
        return this.tpTokens;
    }

    public double getTypesRecall() {
        return (double)this.tpTypes / (double)this.totalTypes * 100.0;
    }

    public double getTokensRecall() {
        return (double)this.tpTokens / (double)this.totalTokens * 100.0;
    }

    public double getTypesPrecision() {
        return (double)this.tpTypes / ((double)this.tpTypes + (double)this.fpTypes) * 100.0;
    }

    public double getTokensPrecision() {
        return (double)this.tpTokens / ((double)this.tpTokens + (double)this.fpTokens) * 100.0;
    }

    public double getTypesAverageScore() {
        return this.totalTypesScore / (double)this.totalTypes;
    }

    public double getTokensAverageScore() {
        return this.totalTokensScore / (double)this.totalTokens;
    }

    public double getTypesAverageFalsePositives() {
        return (double)this.fpTypes / (double)this.totalTypes;
    }

    public double getTokensAverageFalsePositives() {
        return (double)this.fpTokens / (double)this.totalTokens;
    }

    public double getTypesAverageProcessingTime() {
        return this.totalTypesProcessingTime / (double)this.totalTypes;
    }

    public double getTokensAverageProcessingTime() {
        return this.totalTokensProcessingTime / (double)this.totalTokens;
    }

    public E getOptions() {
        return this.options;
    }

    public Tester<E> getTester() {
        return this.tester;
    }

    public TreeMap<StringPair, StringPairScores> getMatches() {
        return this.matches;
    }

    public TreeMap<StringPair, StringPairScores> getNonMatches() {
        return this.nonMatches;
    }

    public String getTypesStringRep() {
        String s = "Recall Percentage: " + this.getTypesRecall() + "%";
        s = String.valueOf(s) + "\nPrecision Percentage: " + this.getTypesPrecision() + "%";
        s = String.valueOf(s) + "\nWould Replace: " + this.getWouldBeTypesPercentage() + "%";
        s = String.valueOf(s) + "\nAverage False Positives: " + this.getTypesAverageFalsePositives();
        s = String.valueOf(s) + "\nAverage Score: " + this.getTypesAverageScore();
        s = String.valueOf(s) + "\nAverage Processing Time: " + this.getTypesAverageProcessingTime();
        return s;
    }

    public String getTokensStringRep() {
        String s = "\nRecall Percentage: " + this.getTokensRecall() + "%";
        s = String.valueOf(s) + "\nPrecision Percentage: " + this.getTokensPrecision() + "%";
        s = String.valueOf(s) + "\nWould Replace: " + this.getWouldBeTokensPercentage() + "%";
        s = String.valueOf(s) + "\nAverage False Positives: " + this.getTokensAverageFalsePositives();
        s = String.valueOf(s) + "\nAverage Score: " + this.getTokensAverageScore();
        s = String.valueOf(s) + "\nAverage Processing Time: " + this.getTokensAverageProcessingTime();
        return s;
    }
}

