/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.Collection;
import java.util.TreeMap;
import java.util.Vector;
import testbed.input.Inputter;
import testbed.options.ListOption;
import testbed.options.Option;
import testbed.testing.Tester;

public class TesterOptions
implements Comparable<TesterOptions> {
    protected String label = "";
    private String metaString;
    private TreeMap<String, String> metadata;
    protected static TreeMap<Tester<? extends TesterOptions>, TreeMap<String, ListOption<String>>> metaInputOptions = new TreeMap();

    protected TesterOptions(TesterOptions options) {
        this.metaString = options.metaString;
    }

    protected TesterOptions(Tester<? extends TesterOptions> tester) {
        this.metaString = "";
        this.metadata = new TreeMap();
        for (ListOption<String> lo : metaInputOptions.get(tester).values()) {
            String pick = (String)lo.next();
            this.metadata.put(lo.getLabel(), pick);
            if (pick.equals("All")) continue;
            this.metaString = String.valueOf(this.metaString) + " / " + pick;
        }
        this.metaString = this.metaString.equals("") ? "All" : this.metaString.substring(3);
    }

    public String getMetaString() {
        return this.metaString;
    }

    public TreeMap<String, String> getMetadata() {
        return this.metadata;
    }

    public String getPlotValue(Tester<? extends TesterOptions> tester) {
        for (String metaField : metaInputOptions.get(tester).keySet()) {
            if (!metaInputOptions.get(tester).get(metaField).isPlotted()) continue;
            return this.metadata.get(metaField);
        }
        return "unknown";
    }

    public String getLineValue(Tester<? extends TesterOptions> tester) {
        String field = "";
        for (String metaField : metaInputOptions.get(tester).keySet()) {
            if (metaInputOptions.get(tester).get(metaField).isConstant() || metaInputOptions.get(tester).get(metaField).isPlotted()) continue;
            field = String.valueOf(field) + this.metadata.get(metaField);
        }
        return field;
    }

    protected static Collection<Option<?>> createOptions(Inputter inputter, Tester<? extends TesterOptions> tester) {
        Vector options = new Vector();
        TreeMap<String, ListOption<String>> thisMetaOptions = new TreeMap<String, ListOption<String>>();
        for (String field : inputter.getMetaDataFields()) {
            ListOption<String> fieldLO = new ListOption<String>(field, inputter.getPossibleFieldValues(field), false);
            fieldLO.setIsPlottable(true);
            thisMetaOptions.put(field, fieldLO);
            options.add(fieldLO);
        }
        metaInputOptions.put(tester, thisMetaOptions);
        return options;
    }

    protected void setupOutputLabel(Tester<? extends TesterOptions> tester) {
        if (!this.metaString.equals("All")) {
            this.label = " / " + this.metaString + this.label;
        }
        if (this.label.equals("")) {
            this.label = tester.getOutputLabel();
        } else if (this.label.startsWith(" / ")) {
            this.label = this.label.substring(3);
        }
    }

    public String getOutputLabel() {
        return this.label;
    }

    @Override
    public int compareTo(TesterOptions o) {
        return this.label.compareTo(o.label);
    }
}

