/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.Collection;
import java.util.TreeMap;
import java.util.Vector;
import model.Globals;
import testbed.input.InputData;
import testbed.input.Inputter;
import testbed.input.StringPair;
import testbed.options.Option;
import testbed.testing.MatchesList;
import testbed.testing.StringPairScores;
import testbed.testing.TesterOptions;
import testbed.testing.TesterScores;

public abstract class Tester<E extends TesterOptions>
implements Comparable<Tester<? extends TesterOptions>> {
    protected Globals global = Globals.getInstance();
    protected double initializationTime;
    protected TreeMap<String, Collection<E>> testerOptions = new TreeMap();
    protected TreeMap<E, TesterScores<E>> testerScores = new TreeMap();
    protected StringPairScores lastSPS;
    protected Collection<Option<?>> options;

    public Option<?> getPlotOption() {
        for (Option<?> option : this.options) {
            if (!option.isPlotted()) continue;
            return option;
        }
        return null;
    }

    public Collection<Option<?>> getNotPlotMovingOptions() {
        Vector toReturn = new Vector();
        for (Option<?> option : this.options) {
            if (option.isConstant() || option.isPlotted()) continue;
            toReturn.add(option);
        }
        return toReturn;
    }

    public abstract E getTesterOptionsInstance();

    public abstract void createOptions(Inputter var1);

    public abstract String getName();

    protected void testPairOnSingleOption(StringPair pair) {
        Vector<TesterOptions> options = new Vector<TesterOptions>();
        options.add((TesterOptions)this.testerScores.firstKey());
        this.testPair(pair, options);
    }

    protected abstract void testPair(StringPair var1, Collection<E> var2);

    public void test(Inputter inputter) {
        for (Collection<E> options : this.testerOptions.values()) {
            TreeMap<String, String> metadata = ((TesterOptions)options.iterator().next()).getMetadata();
            InputData inputData = inputter.getData(metadata);
            if (inputData == null) {
                System.out.println(metadata);
            }
            this.test(inputData, options);
        }
    }

    protected void test(InputData inputData, Collection<E> options) {
        this.testPairs(inputData.getPairs(), options);
    }

    protected void testPairs(Collection<StringPair> pairs, Collection<E> options) {
        this.global.startProgress(pairs.size());
        this.global.writeProgressMessage("Processing pairs");
        int count = 0;
        for (StringPair pair : pairs) {
            this.testPair(pair, options);
            this.global.setProgressCurrent(++count);
        }
        this.global.finishProgress();
    }

    public Collection<Option<?>> getNonConstantOptions() {
        Vector toReturn = new Vector();
        for (Option<?> option : this.options) {
            if (option.isConstant()) continue;
            toReturn.add(option);
        }
        return toReturn;
    }

    public void initialize() {
        int quantity = 1;
        for (Option<?> option : this.options) {
            int newQuantity = option.getSelectedValues().size();
            if (newQuantity <= quantity) continue;
            quantity = newQuantity;
        }
        int i = 0;
        while (i < quantity) {
            E options = this.getTesterOptionsInstance();
            ((TesterOptions)options).setupOutputLabel(this);
            this.testerScores.put(options, new TesterScores<E>(this, options));
            String metaString = ((TesterOptions)options).getMetaString();
            Collection<E> optionList = this.testerOptions.get(metaString);
            if (optionList == null) {
                optionList = new Vector();
            }
            optionList.add(options);
            this.testerOptions.put(metaString, optionList);
            ++i;
        }
        this.initializationTime = 0.0;
    }

    public TreeMap<E, TesterScores<E>> getAllTesterScores() {
        return this.testerScores;
    }

    public TesterScores<E> getTesterScores(TesterOptions options) {
        return this.testerScores.get(options);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Tester<? extends TesterOptions> tester) {
        int c = this.getName().compareTo(tester.getName());
        return c;
    }

    protected void addScoredPair(E options, StringPair pair, double score, double processingTime) {
        MatchesList matches = new MatchesList();
        this.addScoredPair(options, pair, false, score, processingTime, matches);
    }

    protected void addScoredPair(E options, StringPair pair, double score, double processingTime, String onlyMatch) {
        MatchesList matches = new MatchesList();
        matches.addMatch(onlyMatch);
        this.addScoredPair(options, pair, true, score, processingTime, matches);
    }

    protected void addScoredPair(E options, StringPair pair, boolean match, double score, double processingTime, MatchesList allMatches) {
        StringPairScores sps;
        TesterScores<E> scores = this.getTesterScores((TesterOptions)options);
        if (pair.shouldReplace()) {
            ++scores.totalTokens;
            scores.totalTokensScore += score;
        }
        scores.totalTokensProcessingTime += processingTime;
        int allMatchesSize = allMatches.size();
        if (match) {
            sps = scores.matches.get(pair);
            if (sps == null) {
                sps = new StringPairScores(pair, match, score, processingTime, allMatches);
                scores.matches.put(pair, sps);
                ++scores.totalTypes;
                ++scores.tpTypes;
                scores.fpTypes += allMatchesSize - 1;
                scores.totalTypesScore += score;
                scores.totalTypesProcessingTime += processingTime;
                if (allMatches.size() > 0) {
                    ++scores.totalReplacedTypes;
                }
                ++scores.tpTokens;
                scores.fpTokens += allMatchesSize - 1;
                if (allMatches.size() > 0) {
                    ++scores.totalReplacedTokens;
                }
            } else {
                sps.incrementTokens();
                sps.setAllMatches(allMatches);
                ++scores.tpTokens;
                scores.fpTokens += allMatchesSize - 1;
                if (allMatches.size() > 0) {
                    ++scores.totalReplacedTokens;
                }
            }
        } else {
            sps = scores.nonMatches.get(pair);
            if (sps == null) {
                sps = new StringPairScores(pair, match, score, processingTime, allMatches);
                if (pair.shouldReplace()) {
                    scores.nonMatches.put(pair, sps);
                    ++scores.totalTypes;
                    scores.totalTypesScore += score;
                }
                scores.fpTypes += allMatchesSize;
                scores.totalTypesProcessingTime += processingTime;
                if (allMatches.size() > 0) {
                    ++scores.totalReplacedTokens;
                    ++scores.totalReplacedTypes;
                }
                scores.fpTokens += allMatchesSize;
            } else {
                if (pair.shouldReplace()) {
                    sps.incrementTokens();
                    sps.setAllMatches(allMatches);
                }
                scores.fpTokens += allMatchesSize;
                if (allMatches.size() > 0) {
                    ++scores.totalReplacedTokens;
                }
            }
        }
        this.lastSPS = sps;
    }

    public double getInitializationTime() {
        return this.initializationTime;
    }

    public String getOutputLabel() {
        String toReturn = this.getOutputName();
        String optionsString = "";
        for (Option<?> option : this.options) {
            if (option.isConstant()) {
                toReturn = String.valueOf(toReturn) + " " + option.getLabel() + option.next();
                continue;
            }
            optionsString = String.valueOf(optionsString) + option.getLabel() + "/";
        }
        if (!optionsString.equals("")) {
            optionsString = optionsString.substring(0, optionsString.length() - 1);
            toReturn = String.valueOf(toReturn) + " (" + optionsString + ")";
        }
        return toReturn;
    }

    String getOutputName() {
        return this.getName();
    }

    public Collection<Option<?>> getOptions() {
        return this.options;
    }
}

