/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import testbed.Globals;
import testbed.input.StringPair;
import testbed.testing.MatchesList;

public class StringPairScores {
    private StringPair pair;
    private double score;
    private double processingTime;
    private int tokens;
    private boolean match;
    private MatchesList allMatches;
    private int totalMatches;

    public void setScore(double score) {
        this.score = score;
    }

    public void setMatch(boolean match) {
        this.match = match;
    }

    public int getTotalMatches() {
        return this.totalMatches;
    }

    StringPairScores(StringPair pair, boolean match, double score, double processingTime, MatchesList allMatches) {
        this.pair = pair;
        this.score = score;
        this.processingTime = processingTime;
        this.match = match;
        this.tokens = 1;
        if (Globals.storeMatches) {
            this.allMatches = allMatches;
        }
        this.totalMatches = allMatches.size();
    }

    public boolean isMatch() {
        return this.match;
    }

    public double getProcessingTime() {
        return this.processingTime;
    }

    public double getScore() {
        return this.score;
    }

    public StringPair getPair() {
        return this.pair;
    }

    public void incrementTokens() {
        ++this.tokens;
    }

    public int getTokens() {
        return this.tokens;
    }

    public void clearAllMatches() {
        this.allMatches = null;
    }

    public void setAllMatches(MatchesList allMatches) {
        if (Globals.storeMatches) {
            this.allMatches = allMatches;
        }
    }

    public MatchesList getAllMatches() {
        return this.allMatches;
    }

    public void addMatch(String match) {
        this.allMatches.addMatch(match);
    }
}

