/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.Collection;
import java.util.TreeMap;
import testbed.input.Inputter;
import testbed.options.IntOption;
import testbed.options.Option;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;

public class SoundexTesterOptions
extends TesterOptions {
    private int soundex;
    protected static TreeMap<Tester<SoundexTesterOptions>, IntOption> soundexOptions = new TreeMap();

    protected int getSoundexLength() {
        return this.soundex;
    }

    @Override
    protected void setupOutputLabel(Tester<? extends TesterOptions> tester) {
        if (!soundexOptions.get(tester).isConstant()) {
            this.label = String.valueOf(this.label) + " / " + this.soundex;
        }
        super.setupOutputLabel(tester);
    }

    protected SoundexTesterOptions(Tester<SoundexTesterOptions> tester) {
        super(tester);
        this.soundex = (Integer)soundexOptions.get(tester).next();
    }

    protected static Collection<Option<?>> createOptions(Inputter inputter, Tester<SoundexTesterOptions> tester) {
        Collection<Option<?>> options = TesterOptions.createOptions(inputter, tester);
        IntOption soundexOption = new IntOption("Code Length", 1, 10, 1, "");
        soundexOptions.put(tester, soundexOption);
        options.add(soundexOption);
        return options;
    }

    @Override
    public int compareTo(SoundexTesterOptions o) {
        int c = this.soundex - o.soundex;
        if (c == 0) {
            return super.compareTo(o);
        }
        return c;
    }

    @Override
    public int compareTo(TesterOptions o) {
        if (o instanceof SoundexTesterOptions) {
            return this.compareTo((SoundexTesterOptions)o);
        }
        return super.compareTo(o);
    }
}

