/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import testbed.input.Inputter;
import testbed.input.StringPair;
import testbed.testing.MatchesList;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;

public class NorvigTester
extends Tester<TesterOptions> {
    private final HashMap<String, Integer> nWords = new HashMap();

    @Override
    public void createOptions(Inputter inputter) {
        this.options = TesterOptions.createOptions(inputter, this);
    }

    @Override
    public TesterOptions getTesterOptionsInstance() {
        return new TesterOptions(this);
    }

    @Override
    public String getName() {
        return "Norvig Spell Checker";
    }

    @Override
    protected void testPair(StringPair pair, Collection<TesterOptions> options) {
        double start = (double)System.nanoTime() / 1000000.0;
        String correction = this.correct(pair.getSource());
        double processingTime = (double)System.nanoTime() / 1000000.0 - start;
        double score = 0.0;
        boolean match = false;
        MatchesList allMatches = new MatchesList();
        if (!correction.equalsIgnoreCase(pair.getSource())) {
            allMatches.addMatch(correction);
        }
        if (correction.equalsIgnoreCase(pair.getTarget())) {
            match = true;
            score = 1.0;
        }
        for (TesterOptions option : options) {
            this.addScoredPair(option, pair, match, score, processingTime, allMatches);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        try {
            double start = (double)System.nanoTime() / 1000000.0;
            this.setup("big.txt");
            this.initializationTime = (double)System.nanoTime() / 1000000.0 - start;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void setup(String file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        Pattern p = Pattern.compile("\\w+");
        String temp = "";
        while (temp != null) {
            Matcher m = p.matcher(temp.toLowerCase());
            while (m.find()) {
                this.nWords.put(temp, this.nWords.containsKey(temp = m.group()) ? this.nWords.get(temp) + 1 : 1);
            }
            temp = in.readLine();
        }
        in.close();
    }

    private final ArrayList<String> edits(String word) {
        char c;
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < word.length()) {
            result.add(String.valueOf(word.substring(0, i)) + word.substring(i + 1));
            ++i;
        }
        i = 0;
        while (i < word.length() - 1) {
            result.add(String.valueOf(word.substring(0, i)) + word.substring(i + 1, i + 2) + word.substring(i, i + 1) + word.substring(i + 2));
            ++i;
        }
        i = 0;
        while (i < word.length()) {
            c = 'a';
            while (c <= 'z') {
                result.add(String.valueOf(word.substring(0, i)) + String.valueOf(c) + word.substring(i + 1));
                c = (char)(c + '\u0001');
            }
            ++i;
        }
        i = 0;
        while (i <= word.length()) {
            c = 'a';
            while (c <= 'z') {
                result.add(String.valueOf(word.substring(0, i)) + String.valueOf(c) + word.substring(i));
                c = (char)(c + '\u0001');
            }
            ++i;
        }
        return result;
    }

    private final String correct(String word) {
        if (this.nWords.containsKey(word)) {
            return word;
        }
        ArrayList<String> list = this.edits(word);
        HashMap<Integer, String> candidates = new HashMap<Integer, String>();
        for (String s : list) {
            if (!this.nWords.containsKey(s)) continue;
            candidates.put(this.nWords.get(s), s);
        }
        if (candidates.size() > 0) {
            return (String)candidates.get(Collections.max(candidates.keySet()));
        }
        for (String s : list) {
            for (String w : this.edits(s)) {
                if (!this.nWords.containsKey(w)) continue;
                candidates.put(this.nWords.get(w), w);
            }
        }
        return candidates.size() > 0 ? (String)candidates.get(Collections.max(candidates.keySet())) : word;
    }
}

