/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.Collection;
import model.lookup.WordUtilities;
import testbed.input.Inputter;
import testbed.input.StringPair;
import testbed.testing.Tester;
import testbed.testing.ThresholdTesterOptions;

public class NormalisedEditDistanceTester
extends Tester<ThresholdTesterOptions> {
    @Override
    public String getName() {
        return "Normalised Edit Distance";
    }

    @Override
    public void testPair(StringPair pair, Collection<ThresholdTesterOptions> options) {
        double start = (double)System.nanoTime() / 1000000.0;
        double score = this.normalisedEditDistance(pair.getSource(), pair.getTarget());
        double processingTime = (double)System.nanoTime() / 1000000.0 - start;
        for (ThresholdTesterOptions option : options) {
            boolean match;
            boolean bl = match = score >= (double)option.getThreshold();
            if (match) {
                this.addScoredPair(option, pair, score, processingTime, pair.getTarget());
                continue;
            }
            this.addScoredPair(option, pair, score, processingTime);
        }
    }

    private double normalisedEditDistance(String i, String n) {
        return 1.0 - (double)WordUtilities.getEditDistance(i, n) / (double)Math.max(i.length(), i.length());
    }

    @Override
    public void createOptions(Inputter inputter) {
        this.options = ThresholdTesterOptions.createOptions(inputter, this);
    }

    @Override
    public ThresholdTesterOptions getTesterOptionsInstance() {
        return new ThresholdTesterOptions(this);
    }
}

