/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.TreeMap;
import java.util.TreeSet;
import testbed.input.StringPair;
import testbed.testing.GroupedTester;
import testbed.testing.GroupedTesterOptions;
import testbed.testing.PowerSet;
import testbed.testing.StringPairScores;
import testbed.testing.TesterScores;

public class GroupedTesterScores
extends TesterScores<GroupedTesterOptions> {
    private GroupedTester tester;

    GroupedTesterScores(GroupedTester tester, GroupedTesterOptions options) {
        super(tester, options);
        this.tester = tester;
    }

    public double getTypesExclusiveRecall() {
        double typesExclusive = Double.NaN;
        if (GroupedTester.isProduceSubsets() && this.tester.getGroupType() != GroupedTester.GroupType.Root) {
            typesExclusive = GroupedTester.getContainingAllUnion().getTypesRecall() - GroupedTester.getUnionTester(PowerSet.getComplement(this.tester.getHash())).getTypesRecall();
        }
        return typesExclusive;
    }

    public double getTokensExclusiveRecall() {
        double tokensExclusive = Double.NaN;
        if (GroupedTester.isProduceSubsets() && this.tester.getGroupType() != GroupedTester.GroupType.Root) {
            tokensExclusive = GroupedTester.getContainingAllUnion().getTokensRecall() - GroupedTester.getUnionTester(PowerSet.getComplement(this.tester.getHash())).getTokensRecall();
        }
        return tokensExclusive;
    }

    @Override
    public String getTypesStringRep() {
        String s = super.getTypesStringRep();
        if (GroupedTester.isProduceSubsets()) {
            s = String.valueOf(s) + "\nExclusive Recall Percentage: " + this.getTypesExclusiveRecall();
        }
        return s;
    }

    @Override
    public String getTokensStringRep() {
        String s = super.getTokensStringRep();
        if (GroupedTester.isProduceSubsets()) {
            s = String.valueOf(s) + "\nExclusive Recall Percentage: " + this.getTokensExclusiveRecall();
        }
        return s;
    }

    public TreeMap<StringPair, StringPairScores> getExclusiveMatches() {
        TreeSet<StringPair> exclusivePairs = new TreeSet<StringPair>();
        exclusivePairs.addAll(GroupedTester.getContainingAllUnion().getMatches().keySet());
        exclusivePairs.removeAll(GroupedTester.getUnionTester(PowerSet.getComplement(this.tester.getHash())).getMatches().keySet());
        TreeMap<StringPair, StringPairScores> exclusiveMatches = new TreeMap<StringPair, StringPairScores>();
        for (StringPair pair : exclusivePairs) {
            exclusiveMatches.put(pair, (StringPairScores)this.matches.get(pair));
        }
        return exclusiveMatches;
    }

    public TreeMap<StringPair, StringPairScores> getExclusiveNonMatches() {
        TreeSet<StringPair> exclusivePairs = new TreeSet<StringPair>();
        exclusivePairs.addAll(GroupedTester.getContainingAllUnion().getNonMatches().keySet());
        exclusivePairs.removeAll(GroupedTester.getUnionTester(PowerSet.getComplement(this.tester.getHash())).getNonMatches().keySet());
        TreeMap<StringPair, StringPairScores> exclusiveNonMatches = new TreeMap<StringPair, StringPairScores>();
        for (StringPair pair : exclusivePairs) {
            exclusiveNonMatches.put(pair, (StringPairScores)this.nonMatches.get(pair));
        }
        return exclusiveNonMatches;
    }
}

