/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.Collection;
import java.util.TreeMap;
import testbed.Globals;
import testbed.input.Inputter;
import testbed.options.BooleanOption;
import testbed.options.ListOption;
import testbed.options.Option;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;

public class GroupedTesterOptions
extends TesterOptions {
    private Tester<? extends TesterOptions> tester;
    protected static TreeMap<Tester<GroupedTesterOptions>, ListOption<Tester<? extends TesterOptions>>> testerOptions = new TreeMap();
    private boolean produceSubsets;
    protected static TreeMap<Tester<GroupedTesterOptions>, BooleanOption> subsetsOptions = new TreeMap();

    protected Tester<? extends TesterOptions> getTester() {
        return this.tester;
    }

    protected boolean isProduceSubsets() {
        return this.produceSubsets;
    }

    @Override
    protected void setupOutputLabel(Tester<? extends TesterOptions> tester) {
        if (!testerOptions.get(tester).isConstant()) {
            this.label = String.valueOf(this.label) + " / " + tester.getOutputLabel();
        }
        super.setupOutputLabel(tester);
    }

    protected GroupedTesterOptions(Tester<? extends TesterOptions> holdingTester, Tester<? extends TesterOptions> optionTester, boolean produceSubsets) {
        super(holdingTester);
        this.tester = optionTester;
        this.produceSubsets = produceSubsets;
    }

    protected GroupedTesterOptions(Tester<? extends TesterOptions> tester) {
        super(tester);
        this.tester = (Tester)testerOptions.get(tester).next();
        this.produceSubsets = (Boolean)subsetsOptions.get(tester).next();
    }

    protected static Collection<Option<?>> createOptions(Inputter inputter, Tester<GroupedTesterOptions> tester) {
        Collection<Option<?>> options = TesterOptions.createOptions(inputter, tester);
        ListOption<Tester<? extends TesterOptions>> testerOption = new ListOption<Tester<? extends TesterOptions>>("Testers", Globals.testers, false);
        options.add(testerOption);
        testerOptions.put(tester, testerOption);
        BooleanOption subsetsOption = new BooleanOption("Produce Subsets?");
        options.add(subsetsOption);
        subsetsOptions.put(tester, subsetsOption);
        return options;
    }

    @Override
    public int compareTo(GroupedTesterOptions o) {
        int c = this.tester.compareTo(o.tester);
        if (c == 0) {
            return super.compareTo(o);
        }
        return c;
    }

    @Override
    public int compareTo(TesterOptions o) {
        if (o instanceof GroupedTesterOptions) {
            return this.compareTo((GroupedTesterOptions)o);
        }
        return super.compareTo(o);
    }
}

