/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import testbed.Globals;
import testbed.input.Inputter;
import testbed.input.StringPair;
import testbed.testing.GroupedTesterOptions;
import testbed.testing.GroupedTesterScores;
import testbed.testing.MatchesList;
import testbed.testing.PowerSet;
import testbed.testing.StringPairScores;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;

public class GroupedTester
extends Tester<GroupedTesterOptions> {
    private boolean allTesters;
    private String hash;
    private GroupType groupType;
    private static TreeMap<String, GroupedTesterScores> unions;
    private static TreeMap<String, GroupedTesterScores> intersections;
    private static GroupedTesterScores containingAllUnion;
    private static GroupedTesterScores containingAllIntersection;
    private static boolean produceSubsets;

    static {
        produceSubsets = false;
    }

    @Override
    public void initialize() {
        super.initialize();
        Vector<Tester<? extends TesterOptions>> testers = new Vector<Tester<? extends TesterOptions>>();
        for (GroupedTesterOptions options : this.testerScores.keySet()) {
            Tester<? extends TesterOptions> tester = options.getTester();
            tester.initialize();
            testers.add(tester);
        }
        if (this.groupType == GroupType.Root && ((GroupedTesterOptions)this.testerScores.firstKey()).isProduceSubsets()) {
            produceSubsets = true;
            unions = new TreeMap();
            intersections = new TreeMap();
            PowerSet<Tester> powerset = new PowerSet<Tester>();
            LinkedHashMap<String, LinkedHashSet<Tester>> subsets = powerset.powerset(testers.toArray(new Tester[testers.size()]));
            int count = 0;
            this.global.startProgress(subsets.size());
            this.global.writeProgressMessage("Producing processing subsets");
            Vector<GroupedTester> groupedTesters = new Vector<GroupedTester>();
            for (String hash : subsets.keySet()) {
                boolean all;
                this.global.setProgressCurrent(++count);
                LinkedHashSet<Tester> subset = subsets.get(hash);
                if (subset.isEmpty()) continue;
                boolean bl = all = subset.size() == testers.size();
                if (subset.size() == 1) {
                    groupedTesters.add(new GroupedTester(GroupType.Single, all, hash));
                    continue;
                }
                groupedTesters.add(new GroupedTester(GroupType.Intersection, all, hash));
                groupedTesters.add(new GroupedTester(GroupType.Union, all, hash));
            }
            for (GroupedTester groupedTester : groupedTesters) {
                GroupedTesterOptions options = new GroupedTesterOptions(this, groupedTester, true);
                options.setupOutputLabel(this);
                this.testerScores.put(options, new GroupedTesterScores(this, options));
                String metaString = options.getMetaString();
                Vector<GroupedTesterOptions> optionList = (Vector<GroupedTesterOptions>)this.testerOptions.get(metaString);
                if (optionList == null) {
                    optionList = new Vector<GroupedTesterOptions>();
                }
                optionList.add(options);
                this.testerOptions.put(metaString, optionList);
                GroupedTesterScores scores = new GroupedTesterScores(this, options);
                this.testerScores.put(options, scores);
                if (groupedTester.groupType == GroupType.Intersection || groupedTester.groupType == GroupType.Single) {
                    intersections.put(groupedTester.hash, scores);
                    if (groupedTester.allTesters) {
                        containingAllIntersection = scores;
                    }
                }
                if (groupedTester.groupType != GroupType.Union && groupedTester.groupType != GroupType.Single) continue;
                unions.put(groupedTester.hash, scores);
                if (!groupedTester.allTesters) continue;
                containingAllUnion = scores;
            }
            this.global.finishProgress();
        }
    }

    public GroupedTester() {
        this.groupType = GroupType.Root;
        this.hash = "";
    }

    GroupedTester(GroupType groupType, boolean allTesters, String hash) {
        this.groupType = groupType;
        this.allTesters = allTesters;
        this.hash = hash;
    }

    @Override
    public String getName() {
        return "Grouped Tester";
    }

    @Override
    public int compareTo(GroupedTester other) {
        int c = other.hash.compareTo(this.hash);
        if (c == 0) {
            return this.groupType.compareTo(other.groupType);
        }
        return c;
    }

    @Override
    public void testPair(StringPair pair, Collection<GroupedTesterOptions> options) {
        if (this.groupType == GroupType.Root) {
            for (GroupedTesterOptions option : options) {
                Tester<? extends TesterOptions> tester = option.getTester();
                if (tester instanceof GroupedTester) {
                    double score = 1.0;
                    boolean match = true;
                    MatchesList allMatches = new MatchesList();
                    double processingTime = 0.0;
                    GroupType groupType = ((GroupedTester)tester).groupType;
                    if (groupType == GroupType.Union) {
                        score = 0.0;
                        match = false;
                    }
                    boolean first = true;
                    Set gtOptions = tester.testerScores.keySet();
                    for (GroupedTesterOptions subOptions : gtOptions) {
                        Tester<? extends TesterOptions> subTester = subOptions.getTester();
                        if (!subTester.lastSPS.getPair().equals(pair)) {
                            subTester.testPairOnSingleOption(pair);
                        }
                        StringPairScores pairScores = subTester.lastSPS;
                        if (groupType == GroupType.Union) {
                            allMatches.addAll(pairScores.getAllMatches());
                            if (pairScores.getScore() > score) {
                                score = pairScores.getScore();
                            }
                            if (pairScores.isMatch()) {
                                match = true;
                            }
                        } else {
                            score *= pairScores.getScore();
                            if (first) {
                                allMatches.addAll(pairScores.getAllMatches());
                            } else {
                                allMatches.retainAll(pairScores.getAllMatches());
                            }
                            first = false;
                            if (!pairScores.isMatch()) {
                                match = false;
                            }
                        }
                        processingTime += pairScores.getProcessingTime();
                    }
                    this.addScoredPair(option, pair, match, score, processingTime, allMatches);
                    continue;
                }
                if (tester.lastSPS == null || !tester.lastSPS.getPair().equals(pair)) {
                    tester.testPairOnSingleOption(pair);
                }
                this.addScoredPair(option, pair, tester.lastSPS.isMatch(), tester.lastSPS.getScore(), tester.lastSPS.getProcessingTime(), tester.lastSPS.getAllMatches());
            }
        }
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isAllTesters() {
        return this.allTesters;
    }

    public static GroupedTesterScores getUnionTester(String hash) {
        return unions.get(hash);
    }

    public static GroupedTesterScores getIntersectionTester(String hash) {
        return intersections.get(hash);
    }

    public static GroupedTesterScores getContainingAllUnion() {
        return containingAllUnion;
    }

    public static GroupedTesterScores getContainingAllIntersection() {
        return containingAllIntersection;
    }

    public static boolean isProduceSubsets() {
        return produceSubsets;
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    @Override
    public void createOptions(Inputter inputter) {
        Globals.selectedInputter = inputter;
        this.options = GroupedTesterOptions.createOptions(inputter, this);
    }

    @Override
    public GroupedTesterOptions getTesterOptionsInstance() {
        return new GroupedTesterOptions(this);
    }

    public static enum GroupType {
        Intersection,
        Union,
        Single,
        Root;

    }
}

