/*
 * Decompiled with CFR 0.152.
 */
package testbed.testing;

import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;
import model.lookup.LookUpDictionary;
import model.lookup.Node;
import model.lookup.Word;
import model.lookup.WordUtilities;
import testbed.input.Inputter;
import testbed.input.StringPair;
import testbed.testing.MatchesList;
import testbed.testing.StringPairScores;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;
import testbed.testing.ThresholdTesterOptions;

public class DictionaryNormalisedEditDistanceTester
extends Tester<ThresholdTesterOptions> {
    private LookUpDictionary lud;
    TreeMap<ThresholdTesterOptions, StringPairScores> optionScores = new TreeMap();

    @Override
    public void initialize() {
        throw new Error("Unresolved compilation problem: \n\tThe method getInstance() is undefined for the type LookUpDictionary\n");
    }

    @Override
    public String getName() {
        return "Dictionary Normalised Edit Distance";
    }

    @Override
    public String getOutputName() {
        return "Edit Distance (dictionary)";
    }

    @Override
    public void testPair(StringPair pair, Collection<ThresholdTesterOptions> options) {
        final String source = pair.getSource();
        final String target = pair.getTarget();
        final TreeSet<ThresholdTesterOptions> optionsSet = new TreeSet<ThresholdTesterOptions>();
        optionsSet.addAll(options);
        for (ThresholdTesterOptions option : optionsSet) {
            this.optionScores.put(option, new StringPairScores(pair, false, 0.0, 0.0, new MatchesList()));
        }
        double start = (double)System.nanoTime() / 1000000.0;
        Node wordsRoot = new Node(Character.valueOf('@'));
        wordsRoot.next = this.lud.getWordsRoot();
        this.lud.postOrder(wordsRoot, new LookUpDictionary.NodeProcessor(){

            @Override
            public void processNode(Node node) {
                if (node.isWord()) {
                    Word word = (Word)node;
                    double wordScore = DictionaryNormalisedEditDistanceTester.this.normalisedEditDistance(source, word.getWord());
                    for (ThresholdTesterOptions option : optionsSet) {
                        if (!(wordScore >= (double)option.getThreshold())) break;
                        StringPairScores sps = DictionaryNormalisedEditDistanceTester.this.optionScores.get(option);
                        sps.addMatch(word.getWord());
                        if (!word.equals(target)) continue;
                        sps.setScore(wordScore);
                        sps.setMatch(true);
                    }
                }
            }
        });
        double processingTime = (double)System.nanoTime() / 1000000.0 - start;
        for (ThresholdTesterOptions option : optionsSet) {
            StringPairScores sps = this.optionScores.get(option);
            this.addScoredPair(option, pair, sps.isMatch(), sps.getScore(), processingTime, sps.getAllMatches());
        }
    }

    private double normalisedEditDistance(String i, String n) {
        return 1.0 - (double)WordUtilities.getEditDistance(i, n) / (double)Math.max(i.length(), i.length());
    }

    @Override
    public void createOptions(Inputter inputter) {
        this.options = TesterOptions.createOptions(inputter, this);
    }

    @Override
    public ThresholdTesterOptions getTesterOptionsInstance() {
        return new ThresholdTesterOptions(this);
    }
}

