/*
 * Decompiled with CFR 0.152.
 */
package testbed.output;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import testbed.input.InputData;
import testbed.output.AbstractOutputter;
import testbed.output.Outputter;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;
import testbed.testing.TesterScores;

public class ScoresTextOutputter
extends AbstractOutputter
implements Outputter {
    PrintWriter typesWriter;
    PrintWriter tokensWriter;

    @Override
    public String getName() {
        return "Scores - Text";
    }

    private void writeToBothWriters() {
        this.typesWriter.println();
        this.tokensWriter.println();
    }

    private void writeToBothWriters(String text) {
        this.typesWriter.println(text);
        this.tokensWriter.println(text);
    }

    @Override
    public void output() throws IOException {
        File typesFile = new File(this.folder, "scores-text - types.txt");
        typesFile.createNewFile();
        this.typesWriter = new PrintWriter(new FileWriter(typesFile));
        File tokensFile = new File(this.folder, "scores-text - tokens.txt");
        typesFile.createNewFile();
        this.tokensWriter = new PrintWriter(new FileWriter(tokensFile));
        this.writeToBothWriters("Inputter: " + this.inputter.getName());
        this.writeToBothWriters();
        this.typesWriter.println("Types:");
        this.tokensWriter.println("Tokens:");
        this.writeToBothWriters();
        for (Tester tester : this.testers) {
            this.writeToBothWriters(String.valueOf(tester.getOutputLabel()) + "::::");
            this.writeToBothWriters();
            for (TesterScores scores : tester.getAllTesterScores().values()) {
                this.writeToBothWriters(String.valueOf(((TesterOptions)scores.getOptions()).getOutputLabel()) + ":");
                this.writeToBothWriters();
                InputData id = this.inputter.getData(((TesterOptions)scores.getOptions()).getMetadata());
                this.writeToBothWriters("Files:");
                for (File file : id.getFiles()) {
                    this.writeToBothWriters(file.getAbsolutePath());
                }
                this.writeToBothWriters();
                this.writeToBothWriters();
                this.typesWriter.println(scores.getTypesStringRep());
                this.tokensWriter.println(scores.getTokensStringRep());
                this.writeToBothWriters();
            }
        }
        this.typesWriter.close();
        this.tokensWriter.close();
    }
}

