/*
 * Decompiled with CFR 0.152.
 */
package testbed.output;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.TreeSet;
import testbed.output.AbstractOutputter;
import testbed.output.Outputter;
import testbed.testing.StringPairScores;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;
import testbed.testing.TesterScores;

public class ProcessingTimesTextOutputter
extends AbstractOutputter
implements Outputter {
    protected Comparator<StringPairScores> orderByProcessingTime = new Comparator<StringPairScores>(){

        @Override
        public int compare(StringPairScores first, StringPairScores second) {
            int c = Double.valueOf(first.getProcessingTime()).compareTo(second.getProcessingTime());
            if (c == 0) {
                return first.getPair().compareTo(second.getPair());
            }
            return c;
        }
    };

    @Override
    public String getName() {
        return "Processing Times - Text";
    }

    @Override
    public void output() throws IOException {
        File outputFile = new File(this.folder, String.valueOf(this.getName()) + ".txt");
        outputFile.createNewFile();
        PrintWriter outputWriter = new PrintWriter(new FileWriter(outputFile));
        this.global.writeProgressMessage("Calculating Processing Times");
        this.global.startIndeterminateProgress();
        outputWriter.println("Inputter: " + this.inputter.getName());
        outputWriter.println("Files:");
        for (File file : this.inputter.getAllData().getFiles()) {
            outputWriter.println(file.getAbsolutePath());
        }
        outputWriter.println();
        outputWriter.println();
        for (Tester tester : this.testers) {
            for (TesterScores scores : tester.getAllTesterScores().values()) {
                TreeSet<StringPairScores> scoredPairs = new TreeSet<StringPairScores>(this.orderByProcessingTime);
                scoredPairs.addAll(scores.getMatches().values());
                scoredPairs.addAll(scores.getNonMatches().values());
                outputWriter.println();
                outputWriter.println(String.valueOf(((TesterOptions)scores.getOptions()).getOutputLabel()) + ":");
                outputWriter.println("Average Time (Types): " + scores.getTypesAverageScore());
                outputWriter.println("Average Time (Tokens): " + scores.getTokensAverageScore());
                outputWriter.println("Max Time: " + scoredPairs.last().getPair() + ": " + scoredPairs.last().getProcessingTime());
                outputWriter.println("Min Time: " + scoredPairs.first().getPair() + ": " + scoredPairs.first().getProcessingTime());
            }
            outputWriter.close();
            this.global.finishProgress();
        }
    }
}

