/*
 * Decompiled with CFR 0.152.
 */
package testbed.output;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeMap;
import testbed.Globals;
import testbed.input.InputData;
import testbed.input.StringPair;
import testbed.output.Outputter;
import testbed.output.ScoresTextOutputter;
import testbed.testing.GroupedTesterScores;
import testbed.testing.StringPairScores;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;
import testbed.testing.TesterScores;

public class MatchListTextOutputter
extends ScoresTextOutputter
implements Outputter {
    PrintWriter outputWriter;

    private void writeHead(InputData id) {
        this.outputWriter.println("Inputter: " + this.inputter.getName());
        this.outputWriter.println("Files:");
        for (File file : id.getFiles()) {
            this.outputWriter.println(file.getAbsolutePath());
        }
    }

    private void writePairListHeader() {
        this.outputWriter.println("Pair\tTokens\tScore\tTotal Matches\tProcessing Time");
    }

    private void writePairInList(StringPairScores pairScores) {
        if (pairScores == null) {
            System.out.println("null");
        }
        this.outputWriter.println(pairScores.getPair() + "\t" + pairScores.getTokens() + "\t" + pairScores.getScore() + "\t" + pairScores.getTotalMatches() + "\t" + pairScores.getProcessingTime());
    }

    @Override
    public void output() throws IOException {
        this.setupFolderWithName();
        for (Tester tester : this.testers) {
            File testerFolder = new File(this.folder, Globals.convertIllegalFileName(tester.getOutputLabel()));
            testerFolder.mkdirs();
            for (TesterScores scores : tester.getAllTesterScores().values()) {
                StringPairScores pairScores;
                File scoresFile = new File(testerFolder, Globals.convertIllegalFileName(String.valueOf(((TesterOptions)scores.getOptions()).getOutputLabel()) + " - matches.txt"));
                this.outputWriter = new PrintWriter(scoresFile);
                InputData id = this.inputter.getData(((TesterOptions)scores.getOptions()).getMetadata());
                this.writeHead(id);
                this.outputWriter.println();
                this.outputWriter.println(String.valueOf(tester.getOutputLabel()) + ":");
                this.outputWriter.println(((TesterOptions)scores.getOptions()).getOutputLabel());
                this.outputWriter.println();
                TreeMap<StringPair, StringPairScores> list = scores.getMatches();
                this.outputWriter.println("Match Pairs: ");
                this.writePairListHeader();
                int tokens = 0;
                for (StringPair sp : list.keySet()) {
                    pairScores = list.get(sp);
                    this.writePairInList(pairScores);
                    tokens += pairScores.getTokens();
                }
                this.outputWriter.println();
                this.outputWriter.println("Match Types: " + list.size());
                this.outputWriter.println("Match Tokens: " + tokens);
                this.outputWriter.close();
                scoresFile = new File(testerFolder, Globals.convertIllegalFileName(String.valueOf(((TesterOptions)scores.getOptions()).getOutputLabel()) + " - non-matches.txt"));
                this.outputWriter = new PrintWriter(scoresFile);
                this.writeHead(id);
                this.outputWriter.println();
                this.outputWriter.println(String.valueOf(tester.getOutputLabel()) + ":");
                this.outputWriter.println(((TesterOptions)scores.getOptions()).getOutputLabel());
                this.outputWriter.println();
                list = scores.getNonMatches();
                this.outputWriter.println("Non-match Pairs: ");
                this.writePairListHeader();
                tokens = 0;
                for (StringPair sp : list.keySet()) {
                    pairScores = list.get(sp);
                    this.writePairInList(pairScores);
                    tokens += pairScores.getTokens();
                }
                this.outputWriter.println();
                this.outputWriter.println("Non-match Types: " + list.size());
                this.outputWriter.println("Non-match Tokens: " + tokens);
                this.outputWriter.close();
                if (!(scores instanceof GroupedTesterScores)) continue;
                testerFolder = new File(testerFolder, "Exclusive");
                testerFolder.mkdirs();
                scoresFile = new File(testerFolder, Globals.convertIllegalFileName(String.valueOf(((TesterOptions)scores.getOptions()).getOutputLabel()) + " - matches.txt"));
                this.outputWriter = new PrintWriter(scoresFile);
                this.writeHead(id);
                this.outputWriter.println();
                this.outputWriter.println(String.valueOf(tester.getOutputLabel()) + ":");
                this.outputWriter.println(((TesterOptions)scores.getOptions()).getOutputLabel());
                this.outputWriter.println();
                list = ((GroupedTesterScores)scores).getExclusiveMatches();
                this.outputWriter.println("Exclusive Match Pairs: ");
                this.writePairListHeader();
                tokens = 0;
                for (StringPair sp : list.keySet()) {
                    pairScores = list.get(sp);
                    this.writePairInList(pairScores);
                    tokens += pairScores.getTokens();
                }
                this.outputWriter.println();
                this.outputWriter.println("Exclusive Match Types: " + list.size());
                this.outputWriter.println("Exclusive Match Tokens: " + tokens);
                scoresFile = new File(testerFolder, Globals.convertIllegalFileName(String.valueOf(((TesterOptions)scores.getOptions()).getOutputLabel()) + " - non-matches.txt"));
                this.outputWriter = new PrintWriter(scoresFile);
                this.writeHead(id);
                this.outputWriter.println();
                this.outputWriter.println(String.valueOf(tester.getOutputLabel()) + ":");
                this.outputWriter.println(((TesterOptions)scores.getOptions()).getOutputLabel());
                this.outputWriter.println();
                list = ((GroupedTesterScores)scores).getExclusiveNonMatches();
                this.outputWriter.println("Exclusive Non-match Pairs: ");
                this.writePairListHeader();
                tokens = 0;
                for (StringPair sp : list.keySet()) {
                    pairScores = list.get(sp);
                    this.writePairInList(pairScores);
                    tokens += pairScores.getTokens();
                }
                this.outputWriter.println();
                this.outputWriter.println("Exclusive Non-match Types: " + list.size());
                this.outputWriter.println("Exclusive Non-match Tokens: " + tokens);
                this.outputWriter.close();
            }
        }
    }

    @Override
    public String getName() {
        return "Matching Pairs Lists";
    }
}

