/*
 * Decompiled with CFR 0.152.
 */
package testbed.output;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeSet;
import testbed.input.InputData;
import testbed.input.Word;
import testbed.output.AbstractOutputter;
import testbed.output.Outputter;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;
import testbed.testing.TesterScores;

public class DetectionStatsOutputter
extends AbstractOutputter
implements Outputter {
    @Override
    public String getName() {
        return "Detection Stats";
    }

    @Override
    public void output() throws IOException {
        File outputFile = new File(this.folder, String.valueOf(this.getName()) + ".txt");
        outputFile.createNewFile();
        PrintWriter outputWriter = new PrintWriter(new FileWriter(outputFile));
        outputWriter.println("Inputter: " + this.inputter.getName());
        this.global.writeProgressMessage("Calculating Detection Stats");
        this.global.startIndeterminateProgress();
        Tester tester = (Tester)this.testers.iterator().next();
        for (TesterScores scores : tester.getAllTesterScores().values()) {
            InputData id = this.inputter.getData(((TesterOptions)scores.getOptions()).getMetadata());
            int totalWordTokens = 0;
            int totalWordTypes = 0;
            int totalVariantTokens = 0;
            int totalVariantTypes = 0;
            int totalCorrectTokens = 0;
            int totalCorrectTypes = 0;
            int totalReplacedTokens = 0;
            int totalReplacedTypes = 0;
            TreeSet<Word> words = new TreeSet<Word>();
            TreeSet<Word> variants = new TreeSet<Word>();
            TreeSet<Word> correct = new TreeSet<Word>();
            TreeSet<Word> replaced = new TreeSet<Word>();
            for (Word word : id.getWords()) {
                ++totalWordTokens;
                if (words.add(word)) {
                    ++totalWordTypes;
                }
                switch (word.getType()) {
                    case Variant: {
                        ++totalVariantTokens;
                        if (!variants.add(word)) break;
                        ++totalVariantTypes;
                        break;
                    }
                    case Replaced: {
                        ++totalReplacedTokens;
                        if (!replaced.add(word)) break;
                        ++totalReplacedTypes;
                        break;
                    }
                    case Correct: {
                        ++totalCorrectTokens;
                        if (!correct.add(word)) break;
                        ++totalCorrectTypes;
                    }
                }
            }
            outputWriter.println();
            outputWriter.println("Files:");
            for (File file : id.getFiles()) {
                outputWriter.println(file.getAbsolutePath());
            }
            outputWriter.println();
            outputWriter.println();
            outputWriter.println("Total Word Types: " + totalWordTypes);
            outputWriter.println("Total Variant Types: " + totalVariantTypes + " (" + (double)totalVariantTypes / (double)totalWordTypes * 100.0 + "%)");
            outputWriter.println("Total Correct Types: " + totalCorrectTypes + " (" + (double)totalCorrectTypes / (double)totalWordTypes * 100.0 + "%)");
            outputWriter.println("Total Replaced Types: " + totalReplacedTypes + " (" + (double)totalReplacedTypes / (double)totalWordTypes * 100.0 + "%)");
            int nonCorrectTypes = totalWordTypes - totalCorrectTypes;
            outputWriter.println("Total Non-Correct Types: " + nonCorrectTypes + " (" + (double)nonCorrectTypes / (double)totalWordTypes * 100.0 + "%)");
            outputWriter.println("Replacement Coverage (Types): " + (double)totalReplacedTypes / (double)nonCorrectTypes * 100.0 + "%");
            outputWriter.println();
            outputWriter.println("Total Word Tokens: " + totalWordTokens);
            outputWriter.println("Total Variant Tokens: " + totalVariantTokens + " (" + (double)totalVariantTokens / (double)totalWordTokens * 100.0 + "%)");
            outputWriter.println("Total Correct Tokens: " + totalCorrectTokens + " (" + (double)totalCorrectTokens / (double)totalWordTokens * 100.0 + "%)");
            outputWriter.println("Total Replaced Tokens: " + totalReplacedTokens + " (" + (double)totalReplacedTokens / (double)totalWordTokens * 100.0 + "%)");
            int nonCorrectTokens = totalWordTokens - totalCorrectTokens;
            outputWriter.println("Total Non-Correct Tokens: " + nonCorrectTokens + " (" + (double)nonCorrectTokens / (double)totalWordTokens * 100.0 + "%)");
            outputWriter.println("Replacement Coverage (Tokens): " + (double)totalReplacedTokens / (double)nonCorrectTokens * 100.0 + "%");
        }
        outputWriter.close();
        this.global.finishProgress();
    }
}

