/*
 * Decompiled with CFR 0.152.
 */
package testbed.output;

import java.io.IOException;
import java.util.TreeSet;
import testbed.input.InputData;
import testbed.input.Word;
import testbed.output.AbstractGraphOutputter;
import testbed.output.Outputter;
import testbed.testing.TesterOptions;
import testbed.testing.TesterScores;

public class DetectionStatsGraphOutputter
extends AbstractGraphOutputter
implements Outputter {
    @Override
    public String getName() {
        return "Detection Stats Graph";
    }

    @Override
    public void output() throws IOException {
        this.setupFolderWithName();
        AbstractGraphOutputter.DataMethod[] methods = new AbstractGraphOutputter.DataMethod[]{new AbstractGraphOutputter.DataMethod(){

            @Override
            public String getHeader() {
                return "Remaining Variants";
            }

            @Override
            public double getTokens(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTokens = 0;
                int totalVariantTokens = 0;
                for (Word word : id.getWords()) {
                    ++totalWordTokens;
                    if (word.getType() != Word.Type.Variant) continue;
                    ++totalVariantTokens;
                }
                return (double)totalVariantTokens / (double)totalWordTokens * 100.0;
            }

            @Override
            public double getTypes(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTypes = 0;
                int totalVariantTypes = 0;
                TreeSet<Word> words = new TreeSet<Word>();
                TreeSet<Word> variants = new TreeSet<Word>();
                for (Word word : id.getWords()) {
                    if (words.add(word)) {
                        ++totalWordTypes;
                    }
                    if (word.getType() != Word.Type.Variant || !variants.add(word)) continue;
                    ++totalVariantTypes;
                }
                return (double)totalVariantTypes / (double)totalWordTypes * 100.0;
            }
        }, new AbstractGraphOutputter.DataMethod(){

            @Override
            public String getHeader() {
                return "Not Variants";
            }

            @Override
            public double getTokens(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTokens = 0;
                int totalCorrectTokens = 0;
                for (Word word : id.getWords()) {
                    ++totalWordTokens;
                    if (word.getType() != Word.Type.Correct) continue;
                    ++totalCorrectTokens;
                }
                return (double)totalCorrectTokens / (double)totalWordTokens * 100.0;
            }

            @Override
            public double getTypes(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTypes = 0;
                int totalCorrectTypes = 0;
                TreeSet<Word> words = new TreeSet<Word>();
                TreeSet<Word> corrects = new TreeSet<Word>();
                for (Word word : id.getWords()) {
                    if (words.add(word)) {
                        ++totalWordTypes;
                    }
                    if (word.getType() != Word.Type.Correct || !corrects.add(word)) continue;
                    ++totalCorrectTypes;
                }
                return (double)totalCorrectTypes / (double)totalWordTypes * 100.0;
            }
        }, new AbstractGraphOutputter.DataMethod(){

            @Override
            public String getHeader() {
                return "Replaced Variants";
            }

            @Override
            public double getTokens(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTokens = 0;
                int totalReplacedTokens = 0;
                for (Word word : id.getWords()) {
                    ++totalWordTokens;
                    if (word.getType() != Word.Type.Replaced) continue;
                    ++totalReplacedTokens;
                }
                return (double)totalReplacedTokens / (double)totalWordTokens * 100.0;
            }

            @Override
            public double getTypes(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTypes = 0;
                int totalReplacedTypes = 0;
                TreeSet<Word> words = new TreeSet<Word>();
                TreeSet<Word> replaced = new TreeSet<Word>();
                for (Word word : id.getWords()) {
                    if (words.add(word)) {
                        ++totalWordTypes;
                    }
                    if (word.getType() != Word.Type.Replaced || !replaced.add(word)) continue;
                    ++totalReplacedTypes;
                }
                return (double)totalReplacedTypes / (double)totalWordTypes * 100.0;
            }
        }, new AbstractGraphOutputter.DataMethod(){

            @Override
            public String getHeader() {
                return "All Variants";
            }

            @Override
            public double getTokens(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTokens = 0;
                int totalCorrectTokens = 0;
                for (Word word : id.getWords()) {
                    ++totalWordTokens;
                    if (word.getType() != Word.Type.Correct) continue;
                    ++totalCorrectTokens;
                }
                return ((double)totalWordTokens - (double)totalCorrectTokens) / (double)totalWordTokens * 100.0;
            }

            @Override
            public double getTypes(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTypes = 0;
                int totalCorrectTypes = 0;
                TreeSet<Word> words = new TreeSet<Word>();
                TreeSet<Word> corrects = new TreeSet<Word>();
                for (Word word : id.getWords()) {
                    if (words.add(word)) {
                        ++totalWordTypes;
                    }
                    if (word.getType() != Word.Type.Correct || !corrects.add(word)) continue;
                    ++totalCorrectTypes;
                }
                return ((double)totalWordTypes - (double)totalCorrectTypes) / (double)totalWordTypes * 100.0;
            }
        }, new AbstractGraphOutputter.DataMethod(){

            @Override
            public String getHeader() {
                return "Replacement Coverage";
            }

            @Override
            public double getTokens(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTokens = 0;
                int totalCorrectTokens = 0;
                int totalReplacedTokens = 0;
                for (Word word : id.getWords()) {
                    ++totalWordTokens;
                    if (word.getType() == Word.Type.Correct) {
                        ++totalCorrectTokens;
                        continue;
                    }
                    if (word.getType() != Word.Type.Replaced) continue;
                    ++totalReplacedTokens;
                }
                return (double)totalReplacedTokens / ((double)totalWordTokens - (double)totalCorrectTokens) * 100.0;
            }

            @Override
            public double getTypes(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTypes = 0;
                int totalCorrectTypes = 0;
                int totalReplacedTypes = 0;
                TreeSet<Word> words = new TreeSet<Word>();
                TreeSet<Word> corrects = new TreeSet<Word>();
                TreeSet<Word> replaced = new TreeSet<Word>();
                for (Word word : id.getWords()) {
                    if (words.add(word)) {
                        ++totalWordTypes;
                    }
                    if (word.getType() == Word.Type.Correct) {
                        if (!corrects.add(word)) continue;
                        ++totalCorrectTypes;
                        continue;
                    }
                    if (word.getType() != Word.Type.Replaced || !replaced.add(word)) continue;
                    ++totalReplacedTypes;
                }
                return (double)totalReplacedTypes / ((double)totalWordTypes - (double)totalCorrectTypes) * 100.0;
            }
        }, new AbstractGraphOutputter.DataMethod(){

            @Override
            public String getHeader() {
                return "Method Replaced Variants";
            }

            @Override
            public double getTokens(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTokens = 0;
                int totalReplacedTokens = 0;
                for (Word word : id.getWords()) {
                    ++totalWordTokens;
                    if (word.getType() != Word.Type.Replaced) continue;
                    ++totalReplacedTokens;
                }
                double replacementsLeft = (double)totalReplacedTokens * (scores.getTokensRecall() / 100.0);
                return replacementsLeft / (double)totalWordTokens * 100.0;
            }

            @Override
            public double getTypes(TesterScores<? extends TesterOptions> scores) {
                InputData id = DetectionStatsGraphOutputter.this.inputter.getData(scores.getOptions().getMetadata());
                int totalWordTypes = 0;
                int totalReplacedTypes = 0;
                TreeSet<Word> words = new TreeSet<Word>();
                TreeSet<Word> replaced = new TreeSet<Word>();
                for (Word word : id.getWords()) {
                    if (words.add(word)) {
                        ++totalWordTypes;
                    }
                    if (word.getType() != Word.Type.Replaced || !replaced.add(word)) continue;
                    ++totalReplacedTypes;
                }
                double replacementsLeft = (double)totalReplacedTypes * (scores.getTypesRecall() / 100.0);
                return replacementsLeft / (double)totalWordTypes * 100.0;
            }
        }};
        this.createDatFile(methods);
        this.createPltFiles("%");
    }
}

