/*
 * Decompiled with CFR 0.152.
 */
package testbed.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import testbed.Globals;
import testbed.options.ListOption;
import testbed.options.Option;
import testbed.options.StringOption;
import testbed.output.AbstractOutputter;
import testbed.output.Outputter;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;
import testbed.testing.TesterScores;

public abstract class AbstractGraphOutputter
extends AbstractOutputter
implements Outputter {
    private StringOption titleOption;
    private ListOption<String> typeOption;
    private Vector<TesterGraph> testerGraphs = new Vector();

    public AbstractGraphOutputter() {
        this.titleOption = new StringOption("Title");
        String[] types = new String[]{"Histogram", "Line"};
        this.typeOption = new ListOption<String>("Type", types, false);
        this.options.add(this.titleOption);
        this.options.add(this.typeOption);
    }

    protected void createDatFile(DataMethod[] dataMethods) throws IOException {
        for (Tester tester : this.testers) {
            DataMethod[] plotField;
            Option<?> plotOption = tester.getPlotOption();
            String[] plotIndexes = new String[plotOption.getQuantity()];
            int i = 0;
            while (i < plotIndexes.length) {
                plotIndexes[i] = plotOption.next().toString();
                ++i;
            }
            Collection<Option<?>> lineOptions = tester.getNotPlotMovingOptions();
            int quantity = 1;
            for (Option<?> option : lineOptions) {
                if (option.isConstant() || option.isPlotted()) continue;
                quantity *= option.getQuantity();
            }
            String[] lineIndexes = new String[quantity];
            String[] lineHeaders = new String[quantity];
            int i2 = 0;
            while (i2 < quantity) {
                String field = "";
                String header = "";
                for (Option<?> option : lineOptions) {
                    field = String.valueOf(field) + option.next();
                    header = String.valueOf(header) + " / " + field + option.getSuffix();
                }
                lineIndexes[i2] = field;
                if (header.startsWith(" / ")) {
                    header = String.valueOf(header.substring(3)) + " - ";
                }
                lineHeaders[i2] = header;
                ++i2;
            }
            double typesMax = 0.0;
            double tokensMax = 0.0;
            double[][][] typesScores = new double[dataMethods.length][plotIndexes.length][lineIndexes.length];
            double[][][] tokensScores = new double[dataMethods.length][plotIndexes.length][lineIndexes.length];
            for (TesterOptions option : tester.getAllTesterScores().keySet()) {
                int d = 0;
                while (d < dataMethods.length) {
                    double typesData = dataMethods[d].getTypes(tester.getTesterScores(option));
                    double tokensData = dataMethods[d].getTokens(tester.getTesterScores(option));
                    if (typesData > typesMax) {
                        typesMax = typesData;
                    }
                    if (tokensData > tokensMax) {
                        tokensMax = tokensData;
                    }
                    plotField = option.getPlotValue(tester);
                    int x = -1;
                    int i3 = 0;
                    while (i3 < plotIndexes.length) {
                        if (plotIndexes[i3].equals(plotField)) {
                            x = i3;
                        }
                        ++i3;
                    }
                    String lineField = option.getLineValue(tester);
                    int y = -1;
                    int i4 = 0;
                    while (i4 < lineIndexes.length) {
                        if (lineIndexes[i4].equals(lineField)) {
                            y = i4;
                        }
                        ++i4;
                    }
                    typesScores[d][x][y] = typesData;
                    tokensScores[d][x][y] = tokensData;
                    ++d;
                }
            }
            File typesDatFile = new File(this.folder, String.valueOf(Globals.convertIllegalFileName(tester.getOutputLabel())) + "-types.dat");
            typesDatFile.createNewFile();
            PrintWriter typesDatWriter = new PrintWriter(new FileWriter(typesDatFile));
            File tokensDatFile = new File(this.folder, String.valueOf(Globals.convertIllegalFileName(tester.getOutputLabel())) + "-tokens.dat");
            tokensDatFile.createNewFile();
            PrintWriter tokensDatWriter = new PrintWriter(new FileWriter(tokensDatFile));
            typesDatWriter.print("Types");
            tokensDatWriter.print("Tokens");
            plotField = dataMethods;
            int n = dataMethods.length;
            int tokensData = 0;
            while (tokensData < n) {
                DataMethod method = plotField[tokensData];
                String[] stringArray = lineHeaders;
                int n2 = lineHeaders.length;
                int n3 = 0;
                while (n3 < n2) {
                    String header = stringArray[n3];
                    typesDatWriter.print("\t\"" + header + method.getHeader() + "\"");
                    tokensDatWriter.print("\t\"" + header + method.getHeader() + "\"");
                    ++n3;
                }
                ++tokensData;
            }
            typesDatWriter.println();
            tokensDatWriter.println();
            int x = 0;
            while (x < plotIndexes.length) {
                String label = plotIndexes[x];
                if (!label.matches("^[0-9\\.]+$")) {
                    label = "\"" + label + "\"";
                }
                typesDatWriter.print(label);
                tokensDatWriter.print(label);
                int d = 0;
                while (d < dataMethods.length) {
                    int y = 0;
                    while (y < lineIndexes.length) {
                        typesDatWriter.print("\t" + typesScores[d][x][y]);
                        tokensDatWriter.print("\t" + tokensScores[d][x][y]);
                        ++y;
                    }
                    ++d;
                }
                typesDatWriter.println();
                tokensDatWriter.println();
                ++x;
            }
            typesDatWriter.close();
            tokensDatWriter.close();
            this.testerGraphs.add(new TesterGraph(tester, TypesOrTokens.Types, typesDatFile, dataMethods.length * lineHeaders.length, typesMax));
            this.testerGraphs.add(new TesterGraph(tester, TypesOrTokens.Tokens, tokensDatFile, dataMethods.length * lineHeaders.length, tokensMax));
        }
    }

    protected void createPltFiles(String yLabel) throws IOException {
        for (String type : this.typeOption.getSelectedValues()) {
            this.createPltFile(type.toString(), yLabel);
        }
    }

    private void createPltFile(String type, String yLabel) throws IOException {
        for (TesterGraph testerGraph : this.testerGraphs) {
            String with;
            String testerGraphFileName = String.valueOf(testerGraph.getName().replaceAll(" ", "").replaceAll("/", "+")) + "-" + type;
            File pltFile = new File(this.folder, String.valueOf(testerGraphFileName) + ".plt");
            pltFile.createNewFile();
            PrintWriter pltWriter = new PrintWriter(new FileWriter(pltFile));
            pltWriter.println("set term postscript eps enhanced color size 10,6");
            pltWriter.println("set output '" + testerGraphFileName + ".eps'");
            if (type.equals("Histogram")) {
                pltWriter.println("set boxwidth 0.8 absolute");
                pltWriter.println("set style fill solid 1.0 noborder");
                pltWriter.println("set style histogram clustered gap 2 title  offset character 0, 0, 0");
                pltWriter.println("set style data histograms");
            }
            pltWriter.println("set datafile missing '-'");
            pltWriter.println("set grid nopolar");
            pltWriter.println("set grid noxtics nomxtics ytics nomytics noztics nomztics nox2tics nomx2tics noy2tics nomy2tics nocbtics nomcbtics");
            pltWriter.println("set grid layerdefault   linetype 0 linewidth 1.000,  linetype 0 linewidth 1.000");
            pltWriter.println("set xtics border in scale 1,0.5 nomirror rotate by -45  offset character 0, 0, 0");
            int count = 0;
            int xMin = 0;
            int xMax = 0;
            boolean range = false;
            if (type.equals("Line") && testerGraph.tester.getPlotOption().isNumerical()) {
                range = true;
                TesterOptions firstOption = (TesterOptions)testerGraph.tester.getAllTesterScores().firstKey();
                TesterOptions lastOption = (TesterOptions)testerGraph.tester.getAllTesterScores().lastKey();
                String firstStr = firstOption.getPlotValue(testerGraph.tester);
                String lastStr = lastOption.getPlotValue(testerGraph.tester);
                if (firstStr.contains(".")) {
                    double first = Double.parseDouble(firstStr);
                    double last = Double.parseDouble(lastStr);
                    count = (int)(last - first);
                    xMin = (int)first - 1;
                    xMax = (int)last + 1;
                } else {
                    xMin = Integer.parseInt(firstStr);
                    xMax = Integer.parseInt(lastStr);
                    count = xMax - xMin;
                    xMax += xMax / 20;
                }
            } else {
                count = testerGraph.tester.getPlotOption().getQuantity();
                pltWriter.println("set xrange [-1.0 : " + (count + 1) + ".0]");
            }
            pltWriter.println("set title '" + (String)this.titleOption.getSelectedValues().iterator().next() + "'");
            pltWriter.println("set xlabel '" + testerGraph.tester.getPlotOption().getLabel() + "'");
            pltWriter.println("set ylabel '" + yLabel + " " + (Object)((Object)testerGraph.typesortokens) + "'");
            double max = testerGraph.max;
            max = max <= 0.01 ? 0.01 : (max <= 0.1 ? 0.1 : (max <= 1.0 ? 1.0 : (max <= 5.0 ? 5.0 : (max <= 10.0 ? 10.0 : (max <= 50.0 ? 50.0 : (max <= 100.0 ? 100.0 : (max <= 1000.0 ? (double)Integer.parseInt(String.valueOf(String.valueOf(max).charAt(0)) + "00") + 100.0 : (max <= 10000.0 ? (double)Integer.parseInt(String.valueOf(String.valueOf(max).charAt(0)) + "000") + 1000.0 : (max += 1000.0)))))))));
            pltWriter.println("set yrange [ 0.00000 : " + max + " ] noreverse nowriteback");
            String string = with = type.equals("Line") ? " with linespoints" : "";
            if (range) {
                String rangeStr = "";
                rangeStr = count == 0 ? "[-0.2 : 1.2]" : "[" + xMin + " : " + xMax + "]";
                pltWriter.print("plot " + rangeStr + " '" + testerGraph.datFile.getName() + "' using 1:2 title 2" + with);
                int i = 1;
                while (i < testerGraph.numCols) {
                    pltWriter.print(", '' using 1:" + (i + 2) + " title " + (i + 2) + with);
                    ++i;
                }
                pltWriter.println();
            } else {
                pltWriter.print("plot '" + testerGraph.datFile.getName() + "' using 2:xtic(1) ti col" + with);
                int i = 1;
                while (i < testerGraph.numCols) {
                    pltWriter.print(", '' using " + (i + 2) + " ti col" + with);
                    ++i;
                }
                pltWriter.println();
            }
            pltWriter.close();
            String s = null;
            String cmd = "gnuplot " + pltFile.getName();
            try {
                Process p = Runtime.getRuntime().exec(cmd, null, this.folder);
                int i = p.waitFor();
                if (i == 0) {
                    BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((s = stdInput.readLine()) != null) {
                        System.out.println(s);
                    }
                    continue;
                }
                BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((s = stdErr.readLine()) != null) {
                    System.out.println(s);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    protected static interface DataMethod {
        public String getHeader();

        public double getTypes(TesterScores<? extends TesterOptions> var1);

        public double getTokens(TesterScores<? extends TesterOptions> var1);
    }

    private class TesterGraph {
        private Tester<? extends TesterOptions> tester;
        private File datFile;
        private double max;
        private TypesOrTokens typesortokens;
        private int numCols;

        private TesterGraph(Tester<? extends TesterOptions> tester, TypesOrTokens typesortokens, File datFile, int numCols, double max) {
            this.tester = tester;
            this.typesortokens = typesortokens;
            this.datFile = datFile;
            this.numCols = numCols;
            this.max = max;
        }

        private String getName() {
            return String.valueOf(this.tester.getOutputLabel()) + " - " + (Object)((Object)this.typesortokens);
        }
    }

    private static enum TypesOrTokens {
        Types,
        Tokens;

    }
}

