/*
 * Decompiled with CFR 0.152.
 */
package testbed.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import model.Globals;
import testbed.options.AbstractOption;
import testbed.options.Option;
import testbed.options.RepeatingIterator;
import testbed.options.ValuesNotInitialisedException;

public class SampleOption
extends AbstractOption<Integer>
implements Option<Integer> {
    private Vector<File> files;
    private Vector<File> selectedFiles;
    private JFileChooser fc = new JFileChooser();
    private JButton addFileButton;
    private JButton addFolderButton;
    private RepeatingIterator<File> fileIt;

    public SampleOption(String label) {
        super(label);
        this.files = new Vector();
    }

    @Override
    protected String getType() {
        return "file";
    }

    private int getTokens(File file) throws IOException {
        String currentLine;
        LineNumberReader textIn = new LineNumberReader(new FileReader(file));
        Pattern regex = Pattern.compile("<sample number=\"[0-9]+\" tokens=\"([0-9]+)\">");
        while ((currentLine = textIn.readLine()) != null) {
            Matcher matcher = regex.matcher(currentLine);
            if (!matcher.find()) continue;
            textIn.close();
            return Integer.parseInt(matcher.group(1));
        }
        textIn.close();
        throw new IOException("Sample tokens size not found for file: " + file);
    }

    @Override
    public Vector<Integer> calculateSelectedValues() {
        int tokensCount = 0;
        Vector<Integer> toReturn = new Vector<Integer>();
        try {
            for (File file : this.files) {
                toReturn.add(tokensCount += this.getTokens(file));
            }
        }
        catch (IOException ex) {
            Globals.getInstance().showException("Error occurred getting sample sizes", ex);
        }
        return toReturn;
    }

    @Override
    public JComponent getRangeComponent(final Component parent) {
        final JList fileList = new JList();
        fileList.setVisibleRowCount(6);
        JScrollPane fileListSP = new JScrollPane(fileList, 22, 32);
        fileListSP.setAlignmentX(0.0f);
        JPanel inputButtonsPanel = new JPanel(new GridLayout(6, 1));
        this.addFileButton = new JButton("Add file(s)");
        this.addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SampleOption.this.fc.setFileSelectionMode(0);
                SampleOption.this.fc.setMultiSelectionEnabled(true);
                int returnVal = SampleOption.this.fc.showOpenDialog(parent);
                if (returnVal == 0) {
                    File[] filesSelected = SampleOption.this.fc.getSelectedFiles();
                    int i = 0;
                    while (i < filesSelected.length) {
                        if (!SampleOption.this.files.contains(filesSelected[i])) {
                            SampleOption.this.files.add(filesSelected[i]);
                        }
                        ++i;
                    }
                    fileList.setListData(SampleOption.this.files.toArray());
                    SampleOption.this.fireChangeEvent();
                }
            }
        });
        inputButtonsPanel.add(this.addFileButton);
        this.addFolderButton = new JButton("Add folder(s)");
        this.addFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SampleOption.this.fc.setFileSelectionMode(1);
                SampleOption.this.fc.setMultiSelectionEnabled(true);
                int returnVal2 = SampleOption.this.fc.showOpenDialog(parent);
                if (returnVal2 == 0) {
                    File[] directoriesSelected = SampleOption.this.fc.getSelectedFiles();
                    int i = 0;
                    while (i < directoriesSelected.length) {
                        File[] filesFromFolder = directoriesSelected[i].listFiles();
                        int j = 0;
                        while (j < filesFromFolder.length) {
                            if (!filesFromFolder[j].isDirectory() && !SampleOption.this.files.contains(filesFromFolder[j])) {
                                SampleOption.this.files.add(filesFromFolder[j]);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    fileList.setListData(SampleOption.this.files.toArray());
                    SampleOption.this.fireChangeEvent();
                }
            }
        });
        inputButtonsPanel.add(this.addFolderButton);
        JButton removeButton = new JButton("Remove selectd file(s)");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedFiles = fileList.getSelectedValues();
                int i = 0;
                while (i < selectedFiles.length) {
                    SampleOption.this.files.remove(selectedFiles[i]);
                    ++i;
                }
                fileList.setListData(SampleOption.this.files.toArray());
                SampleOption.this.fireChangeEvent();
            }
        });
        inputButtonsPanel.add(removeButton);
        JButton clearButton = new JButton("Clear list");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SampleOption.this.files.clear();
                fileList.setListData(SampleOption.this.files.toArray());
                SampleOption.this.fireChangeEvent();
            }
        });
        inputButtonsPanel.add(clearButton);
        inputButtonsPanel.add(Box.createVerticalGlue());
        inputButtonsPanel.add(Box.createVerticalGlue());
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.add((Component)fileListSP, "Center");
        inputPanel.add((Component)inputButtonsPanel, "East");
        return inputPanel;
    }

    @Override
    public JComponent getSingleComponent(final Component parent) {
        final JTextField fileTF = new JTextField(15);
        fileTF.setEditable(false);
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SampleOption.this.fc.setFileSelectionMode(0);
                SampleOption.this.fc.setMultiSelectionEnabled(false);
                int returnVal = SampleOption.this.fc.showOpenDialog(parent);
                if (returnVal == 0) {
                    File fileSelected = SampleOption.this.fc.getSelectedFile();
                    SampleOption.this.files.clear();
                    SampleOption.this.files.add(fileSelected);
                    fileTF.setText(fileSelected.toString());
                    SampleOption.this.fireChangeEvent();
                }
            }
        });
        JPanel panel = new JPanel();
        panel.add(fileTF);
        panel.add(browseButton);
        return panel;
    }

    public File nextFile() {
        if (this.files == null || this.files.isEmpty()) {
            throw new ValuesNotInitialisedException("Selected values is null");
        }
        return this.fileIt.next();
    }

    @Override
    public void setSelectedValues() {
        this.selectedFiles = this.files;
        this.fileIt = new RepeatingIterator<File>(this.selectedFiles);
        super.setSelectedValues();
    }

    @Override
    public void repeatSelectedValues(int single, int all) {
        Vector<File> repeatedValues = new Vector<File>();
        int i = 0;
        while (i < all) {
            for (File f : this.files) {
                int j = 0;
                while (j < single) {
                    repeatedValues.add(f);
                    ++j;
                }
            }
            ++i;
        }
        this.selectedFiles = repeatedValues;
        super.repeatSelectedValues(single, all);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }
}

