/*
 * Decompiled with CFR 0.152.
 */
package testbed.options;

import java.awt.Component;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import testbed.gui.SpringUtilities;
import testbed.options.AbstractOption;
import testbed.options.IntOption;
import testbed.options.Option;

public class RatioOption
extends AbstractOption<Double>
implements Option<Double> {
    private IntOption recall;
    private IntOption precision;

    public RatioOption(String label, int max) {
        super(label);
        this.precision = new IntOption("precision", 1, max, 1, "");
        this.recall = new IntOption("recall", 1, max, 1, "");
    }

    @Override
    protected String getType() {
        return "ratio";
    }

    @Override
    public Vector<Double> calculateSelectedValues() {
        TreeSet<Double> toReturn = new TreeSet<Double>();
        for (int p : this.precision.calculateSelectedValues()) {
            for (int r : this.recall.calculateSelectedValues()) {
                toReturn.add((double)r / (double)p);
            }
        }
        Vector<Double> vec = new Vector<Double>();
        vec.addAll(toReturn);
        return vec;
    }

    @Override
    public JComponent getRangeComponent(Component parent) {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(String.valueOf(this.precision.getLabel()) + ":"));
        panel.add(this.precision.getRangeComponent(parent));
        panel.add(new JLabel(String.valueOf(this.recall.getLabel()) + ":"));
        panel.add(this.recall.getRangeComponent(parent));
        SpringUtilities.makeCompactGrid(panel, 2, 2, 6, 6, 6, 6);
        return panel;
    }

    @Override
    public JComponent getSingleComponent(Component parent) {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(String.valueOf(this.precision.getLabel()) + ":"));
        panel.add(this.precision.getSingleComponent(parent));
        panel.add(new JLabel(String.valueOf(this.recall.getLabel()) + ":"));
        panel.add(this.recall.getSingleComponent(parent));
        SpringUtilities.makeCompactGrid(panel, 2, 2, 6, 6, 6, 6);
        return panel;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }
}

