/*
 * Decompiled with CFR 0.152.
 */
package testbed.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import testbed.Globals;
import testbed.gui.OptionsPanel;
import testbed.options.AbstractOption;
import testbed.options.Option;
import testbed.testing.Tester;

public class ListOption<E>
extends AbstractOption<E>
implements Option<E> {
    private Object[] list;
    private Vector<E> selected;
    private JList listBox;
    private boolean single = false;

    public ListOption(String label, E[] list, boolean single) {
        super(label);
        this.list = list;
        this.selected = new Vector();
        this.single = single;
    }

    public ListOption(String label, Collection<E> list, boolean single) {
        super(label);
        this.list = list.toArray();
        this.selected = new Vector();
        this.single = single;
    }

    @Override
    public Vector<E> calculateSelectedValues() {
        return this.selected;
    }

    @Override
    public JComponent getRangeComponent(Component parent) {
        if (this.single) {
            return this.getSingleComponent(parent);
        }
        final JComboBox<Object> comboBox = new JComboBox<Object>(this.list);
        comboBox.setEditable(false);
        JButton addButton = new JButton("Add");
        JButton addAllButton = new JButton("Add all (" + this.list.length + ")");
        JButton removeButton = new JButton("Remove");
        this.listBox = new JList();
        Vector<?> thisLastValues = this.getLastValues();
        if (thisLastValues != null) {
            this.listBox.setListData(thisLastValues.toArray());
            this.selected = thisLastValues;
        }
        this.listBox.setVisibleRowCount(5);
        JScrollPane listBoxSP = new JScrollPane(this.listBox);
        final JPanel panel = new JPanel(new BorderLayout());
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = comboBox.getSelectedItem();
                if (selectedItem instanceof Tester) {
                    ((Tester)selectedItem).createOptions(Globals.selectedInputter);
                    OptionsPanel optPanel = new OptionsPanel(1, ((Tester)selectedItem).getOptions());
                    int o = JOptionPane.showConfirmDialog(panel, optPanel, ((Tester)selectedItem).getName(), 2, 3);
                    if (o == 0) {
                        optPanel.setAllOptions();
                        ListOption.this.selected.add(selectedItem);
                        ListOption.this.listBox.setListData(ListOption.this.selected.toArray());
                    }
                } else {
                    ListOption.this.selected.add(selectedItem);
                    ListOption.this.listBox.setListData(ListOption.this.selected.toArray());
                }
                ListOption.this.fireChangeEvent();
            }
        });
        addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] objectArray = ListOption.this.list;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    Object selectedItem = item;
                    if (selectedItem instanceof Tester) {
                        OptionsPanel optPanel = new OptionsPanel(1, ((Tester)selectedItem).getOptions());
                        int o = JOptionPane.showConfirmDialog(panel, optPanel, ((Tester)selectedItem).getName(), 2, 3);
                        if (o == 0) {
                            optPanel.setAllOptions();
                            ListOption.this.selected.add(selectedItem);
                            ListOption.this.listBox.setListData(ListOption.this.selected.toArray());
                        }
                    } else {
                        ListOption.this.selected.add(selectedItem);
                        ListOption.this.listBox.setListData(ListOption.this.selected.toArray());
                    }
                    ListOption.this.fireChangeEvent();
                    ++n2;
                }
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ListOption.this.listBox.isSelectionEmpty()) {
                    Object[] selectedValues;
                    Object[] objectArray = selectedValues = ListOption.this.listBox.getSelectedValues();
                    int n = selectedValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object toDelete = objectArray[n2];
                        ListOption.this.selected.remove(toDelete);
                        ++n2;
                    }
                    ListOption.this.listBox.setListData(ListOption.this.selected.toArray());
                    ListOption.this.fireChangeEvent();
                }
            }
        });
        JPanel topPanel = new JPanel();
        topPanel.add(comboBox);
        topPanel.add(addButton);
        topPanel.add(addAllButton);
        panel.add((Component)topPanel, "North");
        JPanel midPanel = new JPanel();
        midPanel.add(listBoxSP);
        midPanel.add(removeButton);
        panel.add((Component)midPanel, "Center");
        return panel;
    }

    @Override
    public JComponent getSingleComponent(Component parent) {
        final JComboBox<Object> comboBox = new JComboBox<Object>(this.list);
        this.selected.add(this.list[0]);
        Vector<?> thisLastValues = this.getLastValues();
        if (thisLastValues != null) {
            comboBox.setSelectedItem(thisLastValues.firstElement());
            this.selected = thisLastValues;
        }
        comboBox.setEditable(false);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListOption.this.selected.clear();
                ListOption.this.selected.add(comboBox.getSelectedItem());
                ListOption.this.fireChangeEvent();
            }
        });
        return comboBox;
    }

    @Override
    protected String getType() {
        return "list";
    }

    @Override
    public boolean isNumerical() {
        return false;
    }
}

