/*
 * Decompiled with CFR 0.152.
 */
package testbed.options;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import testbed.options.AbstractOption;
import testbed.options.Option;

public class IntOption
extends AbstractOption<Integer>
implements Option<Integer> {
    private int max;
    private int min;
    private int step;
    private boolean range = false;
    private String suffix;
    private JSpinner singleSpinner;
    private JSpinner minSpinner;
    private JSpinner maxSpinner;
    private JSpinner stepSpinner;

    public IntOption(String label, int min, int max, int step, String suffix) {
        super(label);
        this.max = max;
        this.min = min;
        this.step = step;
        this.suffix = suffix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    private SpinnerNumberModel getSpinnerModel() {
        return new SpinnerNumberModel(this.min, this.min, this.max, this.step);
    }

    @Override
    public JComponent getRangeComponent(Component parent) {
        Vector<?> thisLastValues = this.getLastValues();
        boolean lastValuesPresent = thisLastValues != null;
        JPanel rangePanel = new JPanel(new GridLayout(1, 6));
        this.minSpinner = new JSpinner(this.getSpinnerModel());
        if (lastValuesPresent) {
            this.minSpinner.setValue(thisLastValues.firstElement());
        }
        this.minSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IntOption.this.fireChangeEvent();
            }
        });
        this.maxSpinner = new JSpinner(this.getSpinnerModel());
        this.maxSpinner.setValue(lastValuesPresent ? thisLastValues.lastElement() : Integer.valueOf(this.max));
        this.maxSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IntOption.this.fireChangeEvent();
            }
        });
        this.stepSpinner = new JSpinner(new SpinnerNumberModel(1, 0 - this.max, this.max, this.step));
        this.stepSpinner.setValue(lastValuesPresent ? Integer.parseInt(thisLastValues.lastElement().toString()) - Integer.parseInt(thisLastValues.firstElement().toString()) / thisLastValues.size() : this.step);
        this.stepSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IntOption.this.fireChangeEvent();
            }
        });
        rangePanel.add(new JLabel("Min: "));
        rangePanel.add(this.minSpinner);
        rangePanel.add(new JLabel("Max: "));
        rangePanel.add(this.maxSpinner);
        rangePanel.add(new JLabel("Step: "));
        rangePanel.add(this.stepSpinner);
        this.range = true;
        return rangePanel;
    }

    @Override
    public JComponent getSingleComponent(Component parent) {
        this.singleSpinner = new JSpinner(this.getSpinnerModel());
        if (this.getLastValues() != null) {
            this.singleSpinner.setValue(this.getLastValues().firstElement());
        }
        this.singleSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IntOption.this.fireChangeEvent();
            }
        });
        return this.singleSpinner;
    }

    private int getCurrentStep() {
        return (Integer)this.stepSpinner.getValue();
    }

    private int getCurrentMin() {
        return (Integer)this.minSpinner.getValue();
    }

    private int getCurrentMax() {
        return (Integer)this.maxSpinner.getValue();
    }

    @Override
    public Vector<Integer> calculateSelectedValues() {
        Vector<Integer> values = new Vector<Integer>();
        if (this.range) {
            int min = this.getCurrentMin();
            int max = this.getCurrentMax();
            int step = this.getCurrentStep();
            if (step < 0) {
                int i = max;
                while (i >= min) {
                    values.add(i);
                    i += step;
                }
            } else if (step > 0) {
                int i = min;
                while (i <= max) {
                    values.add(i);
                    i += step;
                }
            } else {
                values.add(min);
            }
        } else {
            values.add((Integer)this.singleSpinner.getValue());
        }
        return values;
    }

    @Override
    protected String getType() {
        return "int";
    }

    @Override
    public boolean isNumerical() {
        return true;
    }
}

