/*
 * Decompiled with CFR 0.152.
 */
package testbed.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import testbed.options.AbstractOption;
import testbed.options.Option;

public class FilesOption
extends AbstractOption<File>
implements Option<File> {
    private Vector<File> files;
    private JFileChooser fc = new JFileChooser();
    private JButton addFileButton;
    private JButton addFolderButton;

    public FilesOption(String label) {
        super(label);
        this.files = new Vector();
    }

    @Override
    protected String getType() {
        return "file";
    }

    @Override
    public Vector<File> calculateSelectedValues() {
        return this.files;
    }

    @Override
    public JComponent getRangeComponent(final Component parent) {
        final JList fileList = new JList();
        fileList.setVisibleRowCount(6);
        JScrollPane fileListSP = new JScrollPane(fileList, 22, 32);
        fileListSP.setAlignmentX(0.0f);
        JPanel inputButtonsPanel = new JPanel(new GridLayout(6, 1));
        this.addFileButton = new JButton("Add file(s)");
        this.addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilesOption.this.fc.setFileSelectionMode(0);
                FilesOption.this.fc.setMultiSelectionEnabled(true);
                int returnVal = FilesOption.this.fc.showOpenDialog(parent);
                if (returnVal == 0) {
                    File[] filesSelected = FilesOption.this.fc.getSelectedFiles();
                    int i = 0;
                    while (i < filesSelected.length) {
                        if (!FilesOption.this.files.contains(filesSelected[i])) {
                            FilesOption.this.files.add(filesSelected[i]);
                        }
                        ++i;
                    }
                    fileList.setListData(FilesOption.this.files.toArray());
                    FilesOption.this.fireChangeEvent();
                }
            }
        });
        inputButtonsPanel.add(this.addFileButton);
        this.addFolderButton = new JButton("Add folder(s)");
        this.addFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilesOption.this.fc.setFileSelectionMode(1);
                FilesOption.this.fc.setMultiSelectionEnabled(true);
                int returnVal2 = FilesOption.this.fc.showOpenDialog(parent);
                if (returnVal2 == 0) {
                    File[] directoriesSelected = FilesOption.this.fc.getSelectedFiles();
                    int i = 0;
                    while (i < directoriesSelected.length) {
                        File[] filesFromFolder = directoriesSelected[i].listFiles();
                        int j = 0;
                        while (j < filesFromFolder.length) {
                            if (!filesFromFolder[j].isDirectory() && !FilesOption.this.files.contains(filesFromFolder[j])) {
                                FilesOption.this.files.add(filesFromFolder[j]);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    fileList.setListData(FilesOption.this.files.toArray());
                    FilesOption.this.fireChangeEvent();
                }
            }
        });
        inputButtonsPanel.add(this.addFolderButton);
        JButton removeButton = new JButton("Remove selectd file(s)");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedFiles = fileList.getSelectedValues();
                int i = 0;
                while (i < selectedFiles.length) {
                    FilesOption.this.files.remove(selectedFiles[i]);
                    ++i;
                }
                fileList.setListData(FilesOption.this.files.toArray());
                FilesOption.this.fireChangeEvent();
            }
        });
        inputButtonsPanel.add(removeButton);
        JButton clearButton = new JButton("Clear list");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilesOption.this.files.clear();
                fileList.setListData(FilesOption.this.files.toArray());
                FilesOption.this.fireChangeEvent();
            }
        });
        inputButtonsPanel.add(clearButton);
        inputButtonsPanel.add(Box.createVerticalGlue());
        inputButtonsPanel.add(Box.createVerticalGlue());
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.add((Component)fileListSP, "Center");
        inputPanel.add((Component)inputButtonsPanel, "East");
        return inputPanel;
    }

    @Override
    public JComponent getSingleComponent(final Component parent) {
        final JTextField fileTF = new JTextField(15);
        fileTF.setEditable(false);
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilesOption.this.fc.setFileSelectionMode(0);
                FilesOption.this.fc.setMultiSelectionEnabled(false);
                int returnVal = FilesOption.this.fc.showOpenDialog(parent);
                if (returnVal == 0) {
                    File fileSelected = FilesOption.this.fc.getSelectedFile();
                    FilesOption.this.files.clear();
                    FilesOption.this.files.add(fileSelected);
                    fileTF.setText(fileSelected.toString());
                    FilesOption.this.fireChangeEvent();
                }
            }
        });
        JPanel panel = new JPanel();
        panel.add(fileTF);
        panel.add(browseButton);
        return panel;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }
}

