/*
 * Decompiled with CFR 0.152.
 */
package testbed.options;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import testbed.options.AbstractOption;
import testbed.options.Option;

public class DoubleOption
extends AbstractOption<Double>
implements Option<Double> {
    private double max;
    private double min;
    private double step;
    private boolean range = false;
    private String suffix;
    private JSpinner singleSpinner;
    private JSpinner minSpinner;
    private JSpinner maxSpinner;
    private JSpinner stepSpinner;

    public DoubleOption(String label, double min, double max, double step, String suffix) {
        super(label);
        this.max = max;
        this.min = min;
        this.step = step;
        this.suffix = suffix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    private SpinnerNumberModel getSpinnerModel() {
        return new SpinnerNumberModel(this.min, this.min, this.max, this.step);
    }

    @Override
    public JComponent getRangeComponent(Component parent) {
        TreeSet thisLastValues = new TreeSet();
        thisLastValues.addAll(this.getLastValues());
        boolean lastValuesPresent = thisLastValues != null;
        JPanel rangePanel = new JPanel(new GridLayout(1, 6));
        this.minSpinner = new JSpinner(this.getSpinnerModel());
        if (lastValuesPresent) {
            this.minSpinner.setValue(thisLastValues.first());
        }
        this.minSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DoubleOption.this.fireChangeEvent();
            }
        });
        this.maxSpinner = new JSpinner(this.getSpinnerModel());
        this.maxSpinner.setValue(lastValuesPresent ? (Double)thisLastValues.last() : this.max);
        this.maxSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DoubleOption.this.fireChangeEvent();
            }
        });
        this.stepSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.0 - this.max, this.max, this.step));
        this.stepSpinner.setValue(lastValuesPresent ? Double.parseDouble(((Double)thisLastValues.last()).toString()) - Double.parseDouble(((Double)thisLastValues.first()).toString()) / (double)thisLastValues.size() : this.step);
        this.stepSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DoubleOption.this.fireChangeEvent();
            }
        });
        rangePanel.add(new JLabel("Min: "));
        rangePanel.add(this.minSpinner);
        rangePanel.add(new JLabel("Max: "));
        rangePanel.add(this.maxSpinner);
        rangePanel.add(new JLabel("Step: "));
        rangePanel.add(this.stepSpinner);
        this.range = true;
        return rangePanel;
    }

    @Override
    public JComponent getSingleComponent(Component parent) {
        this.singleSpinner = new JSpinner(this.getSpinnerModel());
        if (this.getLastValues() != null) {
            this.singleSpinner.setValue(this.getLastValues().firstElement());
        }
        this.singleSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DoubleOption.this.fireChangeEvent();
            }
        });
        return this.singleSpinner;
    }

    private double getCurrentStep() {
        return (Double)this.stepSpinner.getValue();
    }

    private double getCurrentMin() {
        return (Double)this.minSpinner.getValue();
    }

    private double getCurrentMax() {
        return (Double)this.maxSpinner.getValue();
    }

    @Override
    public Vector<Double> calculateSelectedValues() {
        Vector<Double> values = new Vector<Double>();
        if (this.range) {
            double min = this.getCurrentMin();
            double max = this.getCurrentMax();
            double step = this.getCurrentStep();
            if (step < 0.0) {
                double i = max;
                while (i >= min) {
                    values.add(i);
                    i += step;
                }
            } else if (step > 0.0) {
                double i = min;
                while (i <= max) {
                    values.add(i);
                    i += step;
                }
            } else {
                values.add(min);
            }
        } else {
            values.add((Double)this.singleSpinner.getValue());
        }
        return values;
    }

    @Override
    protected String getType() {
        return "double";
    }

    @Override
    public boolean isNumerical() {
        return true;
    }
}

