/*
 * Decompiled with CFR 0.152.
 */
package testbed.options;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import testbed.options.ChangeListener;
import testbed.options.Option;
import testbed.options.RepeatingIterator;
import testbed.options.ValuesNotInitialisedException;

public abstract class AbstractOption<E>
implements Option<E> {
    protected int quantity;
    boolean plottable = false;
    boolean plot = false;
    protected String label;
    private Vector<E> selectedValues;
    private Vector<ChangeListener> changeListeners = new Vector();
    private boolean isConstant = false;
    protected static TreeMap<String, Vector<?>> lastValues = new TreeMap();
    private RepeatingIterator<E> it;

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    public boolean hasNext() {
        if (this.selectedValues == null) {
            throw new ValuesNotInitialisedException("Selected values is null");
        }
        if (this.selectedValues.isEmpty()) {
            throw new ValuesNotInitialisedException("Selected values empty");
        }
        return this.it.hasNext();
    }

    @Override
    public E next() {
        if (this.selectedValues == null || this.selectedValues.isEmpty()) {
            throw new ValuesNotInitialisedException("Selected values is null");
        }
        return this.it.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public AbstractOption(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isConstant() {
        if (this.selectedValues == null || this.selectedValues.isEmpty()) {
            return this.isConstant(this.calculateSelectedValues());
        }
        return this.isConstant;
    }

    @Override
    public Vector<E> getSelectedValues() {
        if (this.selectedValues == null || this.selectedValues.isEmpty()) {
            throw new ValuesNotInitialisedException();
        }
        return this.selectedValues;
    }

    public boolean isConstant(Vector<E> values) {
        Iterator<E> it = values.iterator();
        E first = it.next();
        while (it.hasNext()) {
            if (it.next().equals(first)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSelectedValues() {
        this.selectedValues = this.calculateSelectedValues();
        this.quantity = this.selectedValues.size();
        this.setLastValues();
        this.it = new RepeatingIterator<E>(this.selectedValues);
        Iterator<E> it = this.selectedValues.iterator();
        E first = it.next();
        while (it.hasNext()) {
            if (it.next().equals(first)) continue;
            this.isConstant = false;
            return;
        }
        this.isConstant = true;
    }

    @Override
    public Vector<E> getRepeatedSelectedValues(int single, int all) {
        Vector repeatedValues = new Vector();
        Vector current = this.calculateSelectedValues();
        int i = 0;
        while (i < all) {
            for (Object e : current) {
                int j = 0;
                while (j < single) {
                    repeatedValues.add(e);
                    ++j;
                }
            }
            ++i;
        }
        return repeatedValues;
    }

    @Override
    public void repeatSelectedValues(int single, int all) {
        Vector<E> repeatedValues = new Vector<E>();
        int i = 0;
        while (i < all) {
            for (E e : this.getSelectedValues()) {
                int j = 0;
                while (j < single) {
                    repeatedValues.add(e);
                    ++j;
                }
            }
            ++i;
        }
        this.selectedValues = repeatedValues;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void fireChangeEvent() {
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged();
        }
    }

    @Override
    public int compareTo(Option<E> other) {
        return this.getLabel().compareTo(other.getLabel());
    }

    protected void setLastValues() {
        lastValues.put(String.valueOf(this.getType()) + this.label, this.calculateSelectedValues());
    }

    protected Vector<?> getLastValues() {
        return lastValues.get(String.valueOf(this.getType()) + this.label);
    }

    public int getLastValuesQuantity() {
        Vector<?> thisLastValues = this.getLastValues();
        return thisLastValues == null ? 1 : thisLastValues.size();
    }

    public String toString() {
        return this.getLabel();
    }

    protected abstract String getType();

    @Override
    public String getSuffix() {
        return "";
    }

    @Override
    public boolean isPlottable() {
        return this.plottable;
    }

    @Override
    public void setIsPlottable(boolean plottable) {
        this.plottable = plottable;
    }

    @Override
    public boolean isPlotted() {
        return this.plot;
    }

    @Override
    public void setIsPlotted(boolean plot) {
        this.plot = plot;
    }
}

