/*
 * Decompiled with CFR 0.152.
 */
package testbed.input;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import testbed.input.AbstractInputter;
import testbed.input.Inputter;
import testbed.input.StringPair;

public class VariantsListInputter
extends AbstractInputter
implements Inputter {
    @Override
    public void parse(File file) throws IOException {
        LineNumberReader textIn = new LineNumberReader(new FileReader(file));
        String currentLine = "file not ready";
        String[] currentLineArray = new String[3];
        File lFile = new File("logs/variantslog.txt");
        lFile.getParentFile().mkdirs();
        PrintWriter logWriter = new PrintWriter(new FileWriter(lFile));
        int count = 0;
        try {
            while (!currentLine.equals("end")) {
                if (textIn.ready()) {
                    currentLine = textIn.readLine();
                    if (currentLine.equals("end")) continue;
                    currentLineArray = currentLine.split("\t");
                    if (!VariantsListInputter.isValidWord(currentLineArray[2])) {
                        logWriter.println(String.valueOf(textIn.getLineNumber()) + "- " + currentLineArray[2] + " is invalid real word");
                        continue;
                    }
                    if (!VariantsListInputter.isValidWord(currentLineArray[1])) {
                        logWriter.println(String.valueOf(textIn.getLineNumber()) + "- " + currentLineArray[1] + " is invalid variant");
                        continue;
                    }
                    this.addPair(file, new StringPair(this, currentLineArray[1], currentLineArray[2]));
                    ++count;
                    logWriter.println(String.valueOf(textIn.getLineNumber()) + "- Added: " + currentLineArray[1] + " to variant list");
                    continue;
                }
                logWriter.println(String.valueOf(textIn.getLineNumber()) + ": file not ready");
            }
            logWriter.println(String.valueOf(count) + " added to variants list sucessfully");
        }
        finally {
            logWriter.close();
            textIn.close();
        }
    }

    private static boolean isValidWord(String word) {
        if (word.length() < 2) {
            return false;
        }
        int i = 0;
        while (i < word.length()) {
            if (!VariantsListInputter.isValidCharacter(word.charAt(i))) {
                return false;
            }
            ++i;
        }
        return !word.contains("--");
    }

    private static boolean isValidCharacter(char letter) {
        if (letter == ' ' || letter == '-') {
            return true;
        }
        return VariantsListInputter.isLetter(letter);
    }

    private static boolean isLetter(char letter) {
        if (letter == '\'' || letter == '\u00ed' || letter == '\u00eb') {
            return true;
        }
        return Character.isLetter(letter);
    }

    @Override
    public String getName() {
        return "Known Variants List Reader";
    }
}

