/*
 * Decompiled with CFR 0.152.
 */
package testbed.input;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import testbed.input.AbstractInputter;
import testbed.input.Inputter;
import testbed.input.StringPair;

public class VardedXMLInputter
extends AbstractInputter
implements Inputter {
    @Override
    public String getName() {
        return "VARDED XML Reader";
    }

    @Override
    public void parse(File file) throws IOException {
        String currentLine;
        LineNumberReader textIn = new LineNumberReader(new FileReader(file));
        Pattern regex = Pattern.compile("<replaced (orig|variant)=\"[^\"]*\"[^<]*");
        while ((currentLine = textIn.readLine()) != null) {
            Matcher matcher = regex.matcher(currentLine);
            while (matcher.find()) {
                String match = matcher.group();
                match = match.replaceFirst("<replaced (orig|variant)=\"", "");
                String source = match.substring(0, match.indexOf("\""));
                String target = match.substring(match.lastIndexOf(">") + 1);
                source = source.replaceAll("&apos;", "'");
                target = target.replaceAll("&apos;", "'");
                StringPair sp = new StringPair(this, source, target);
                this.addPair(file, sp);
            }
        }
        textIn.close();
    }
}

