/*
 * Decompiled with CFR 0.152.
 */
package testbed.input;

import testbed.input.Inputter;

public class StringPair
implements Comparable<StringPair> {
    private String source;
    private String target;
    private boolean realWord;
    private boolean shouldReplace;
    private Inputter inputter;

    StringPair(Inputter inputter, String source, String target) {
        this.source = source;
        this.target = target;
        this.inputter = inputter;
        this.realWord = false;
        this.shouldReplace = true;
    }

    StringPair(Inputter inputter, String source, String target, boolean realWord) {
        this(inputter, source, target);
        this.realWord = realWord;
        this.shouldReplace = true;
    }

    StringPair(Inputter inputter, String source, String target, boolean realWord, boolean shouldReplace) {
        this(inputter, source, target, realWord);
        this.shouldReplace = shouldReplace;
    }

    public StringPair clone() {
        return new StringPair(this.inputter, this.source, this.target);
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String toString() {
        return String.valueOf(this.source) + " -> " + this.target;
    }

    @Override
    public int compareTo(StringPair other) {
        int c = this.source.compareToIgnoreCase(other.source);
        if (c == 0) {
            return this.target.compareToIgnoreCase(other.target);
        }
        return c;
    }

    public boolean equals(StringPair other) {
        return this.source.equals(other.source) && this.target.equals(other.target);
    }

    public boolean equals(Object other) {
        if (other instanceof StringPair) {
            return this.equals((StringPair)other);
        }
        return super.equals(other);
    }

    public Inputter getInputter() {
        return this.inputter;
    }

    public boolean isRealWord() {
        return this.realWord;
    }

    public boolean shouldReplace() {
        return this.shouldReplace;
    }
}

