/*
 * Decompiled with CFR 0.152.
 */
package testbed.input;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import testbed.input.AbstractInputter;
import testbed.input.InputData;
import testbed.input.Inputter;
import testbed.input.MultiDimensionalArray;
import testbed.input.StringPair;
import testbed.input.Word;

public class SampleInputterVardVariantsOnly
extends AbstractInputter
implements Inputter {
    private static TreeMap<String, TreeMap<String, Integer>> metadataCodes;
    private MultiDimensionalArray<InputData> dataArray;

    @Override
    public void initialize(Collection<File> files) {
        super.initialize(files);
        TreeMap<String, TreeSet<String>> fieldData = new TreeMap<String, TreeSet<String>>();
        try {
            for (File file : files) {
                TreeMap<String, String> metaDataHeaders = this.getMetadata(file);
                for (String field : metaDataHeaders.keySet()) {
                    TreeSet<String> data = (TreeSet<String>)fieldData.get(field);
                    if (data == null) {
                        data = new TreeSet<String>();
                    }
                    data.add(metaDataHeaders.get(field));
                    fieldData.put(field, data);
                }
            }
        }
        catch (IOException ex) {
            this.global.showException("Error occurred parsing meta headers", ex);
        }
        metadataCodes = new TreeMap();
        int[] dims = new int[fieldData.size()];
        int i = 0;
        for (String field : fieldData.keySet()) {
            TreeSet data = (TreeSet)fieldData.get(field);
            data.add("All");
            dims[i] = data.size();
            TreeMap<String, Integer> fieldDataCodes = new TreeMap<String, Integer>();
            int j = 0;
            for (String dataItem : data) {
                fieldDataCodes.put(dataItem, j);
                ++j;
            }
            ++i;
            metadataCodes.put(field, fieldDataCodes);
        }
        this.dataArray = new MultiDimensionalArray(dims);
    }

    private TreeMap<String, String> getMetadata(File file) throws IOException {
        String currentLine;
        LineNumberReader textIn = new LineNumberReader(new FileReader(file));
        Pattern regex = Pattern.compile("<meta field=\"([^\"]*)\">([^<]*)");
        TreeMap<String, String> toReturn = new TreeMap<String, String>();
        while ((currentLine = textIn.readLine()) != null) {
            Matcher matcher = regex.matcher(currentLine);
            while (matcher.find()) {
                toReturn.put(matcher.group(1), matcher.group(2));
            }
        }
        textIn.close();
        toReturn.put("File", this.getLocalFileName(file));
        return toReturn;
    }

    @Override
    public String getName() {
        return "Samples - Vard Variants only";
    }

    private boolean addDataToInputData(InputData inputData, File file, Collection<StringPair> pairs, Collection<Word> words) {
        if (!inputData.addFile(file)) {
            return false;
        }
        inputData.addAllPairs(pairs);
        inputData.addAllWords(words);
        return true;
    }

    private void addData(TreeMap<String, String> metadata, File file, Collection<StringPair> pairs, Collection<Word> words) {
        InputData id = this.getData(metadata);
        if (id == null) {
            id = new InputData();
            this.dataArray.put(this.getIndicies(metadata), id);
        }
        this.addDataToInputData(id, file, pairs, words);
        if (!metadata.isEmpty()) {
            TreeSet<String> keys = new TreeSet<String>();
            keys.addAll(metadata.keySet());
            for (String key : keys) {
                String val = metadata.remove(key);
                this.addData(metadata, file, pairs, words);
                metadata.put(key, val);
            }
        }
    }

    private int[] getIndicies(TreeMap<String, String> metadata) {
        int[] indicies = new int[metadataCodes.size()];
        int i = 0;
        for (String field : metadataCodes.keySet()) {
            String data = metadata.get(field);
            if (data == null) {
                data = "All";
            }
            indicies[i] = metadataCodes.get(field).get(data);
            ++i;
        }
        return indicies;
    }

    @Override
    public InputData getData(TreeMap<String, String> metadata) {
        return this.dataArray.get(this.getIndicies(metadata));
    }

    @Override
    public void parse(File file) throws IOException {
        throw new Error("Unresolved compilation problem: \n\tThe method getInstance() is undefined for the type DocumentModel\n");
    }

    @Override
    public Collection<String> getPossibleFieldValues(String field) {
        return metadataCodes.get(field).keySet();
    }

    @Override
    public Collection<String> getMetaDataFields() {
        return metadataCodes.keySet();
    }
}

