/*
 * Decompiled with CFR 0.152.
 */
package testbed.input;

import java.util.TreeMap;

public class MultiDimensionalArray<E> {
    private int[] dimensions;
    private int[] factors;
    private TreeMap<Integer, E> data;

    public MultiDimensionalArray(int[] arg) {
        this.dimensions = new int[arg.length];
        this.factors = new int[arg.length];
        int product = 1;
        int i = arg.length - 1;
        while (i >= 0) {
            this.dimensions[i] = arg[i];
            this.factors[i] = product;
            product *= this.dimensions[i];
            --i;
        }
        this.data = new TreeMap();
    }

    private int getOffset(int[] indicies) {
        if (indicies.length != this.dimensions.length) {
            throw new IllegalArgumentException("Wrong number of indicies");
        }
        int offset = 0;
        int i = 0;
        while (i < this.dimensions.length) {
            if (indicies[i] < 0 || indicies[i] >= this.dimensions[i]) {
                throw new IndexOutOfBoundsException();
            }
            offset += this.factors[i] * indicies[i];
            ++i;
        }
        return offset;
    }

    public E get(int[] indicies) {
        return this.data.get(this.getOffset(indicies));
    }

    public void put(int[] indicies, E toAdd) {
        this.data.put(this.getOffset(indicies), toAdd);
    }
}

