/*
 * Decompiled with CFR 0.152.
 */
package testbed.input;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import model.Globals;
import testbed.input.InputData;
import testbed.input.Inputter;
import testbed.input.StringPair;
import testbed.input.Word;

public abstract class AbstractInputter
implements Inputter {
    protected InputData allData;
    protected String commonFolder = "";
    protected TreeMap<String, InputData> data;
    protected Globals global = Globals.getInstance();

    protected void addWord(File file, Word word) {
        this.allData.addWord(word);
        this.data.get(this.getLocalFileName(file)).addWord(word);
    }

    protected void addPair(File file, StringPair pair) {
        this.allData.addPair(pair);
        this.data.get(this.getLocalFileName(file)).addPair(pair);
    }

    @Override
    public void initialize(Collection<File> files) {
        TreeSet<File> filesToAdd = new TreeSet<File>();
        filesToAdd.addAll(files);
        this.allData = new InputData();
        this.allData.addAllFiles(files);
        this.data = new TreeMap();
        this.commonFolder = AbstractInputter.getCommonFolderString(files);
        for (File file : files) {
            String fileString = this.getLocalFileName(file);
            InputData inputData = new InputData();
            inputData.addFile(file);
            this.data.put(fileString, inputData);
        }
        this.data.put("All", this.allData);
    }

    @Override
    public void parse() throws IOException {
        int count = 0;
        TreeSet<File> files = this.allData.getFiles();
        int totalFiles = files.size();
        this.global.startProgress(totalFiles);
        for (File file : files) {
            this.global.setProgressCurrent(++count);
            this.global.writeProgressMessage("Parsing " + file.getName() + " (" + count + "/" + totalFiles + ")");
            this.parse(file);
        }
        this.global.finishProgress();
    }

    protected abstract void parse(File var1) throws IOException;

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Inputter other) {
        return this.getName().compareTo(other.getName());
    }

    protected String getLocalFileName(File file) {
        String toReturn = file.getAbsolutePath().replace(this.commonFolder, "").replaceAll("/", ".");
        if (toReturn.startsWith(".")) {
            return toReturn.substring(1);
        }
        return toReturn;
    }

    protected static String getCommonFolderString(Collection<File> files) {
        String latest = files.iterator().next().getAbsolutePath();
        latest = latest.substring(0, latest.lastIndexOf(File.separator));
        for (File file : files) {
            String currentFileString = file.getAbsolutePath();
            while (!currentFileString.startsWith(latest)) {
                latest = latest.substring(0, latest.lastIndexOf(File.separator));
            }
        }
        return latest;
    }

    @Override
    public Collection<String> getMetaDataFields() {
        Vector<String> toReturn = new Vector<String>();
        toReturn.add("File");
        return toReturn;
    }

    @Override
    public InputData getAllData() {
        return this.allData;
    }

    @Override
    public InputData getData(TreeMap<String, String> metadata) {
        if (!metadata.keySet().contains("File")) {
            throw new IllegalArgumentException("Only File name metadata is applicable");
        }
        return this.data.get(metadata.get("File"));
    }

    @Override
    public Collection<String> getPossibleFieldValues(String field) {
        if (field != "File") {
            throw new IllegalArgumentException("Only File name metadata is applicable");
        }
        return this.data.keySet();
    }
}

