/*
 * Decompiled with CFR 0.152.
 */
package testbed.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import model.ErrorMessageHandler;
import model.ProgressListener;
import testbed.Globals;
import testbed.gui.OptionsPanel;
import testbed.gui.SpringUtilities;
import testbed.input.Inputter;
import testbed.output.Outputter;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;

public class UserInterface
implements ActionListener,
ProgressListener,
ErrorMessageHandler {
    static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private JButton[] buttons;
    private JList fileList;
    private JList testersList;
    private JList outputtersList;
    private Vector<File> files;
    private JTextField outputFolderTF;
    private JProgressBar progressBar;
    private static JLabel progressLabel;
    private JFileChooser fc;
    private JFrame frame;
    private File outputFolder;
    int fileCounter;
    String outputFolderString;
    private JComboBox inputterChooser;
    private Inputter selectedInputter;
    private Collection<Tester<? extends TesterOptions>> selectedTesters;
    private Collection<Outputter> selectedOutputters;
    private model.Globals vardGlobal;

    private UserInterface() {
        throw new Error("Unresolved compilation problems: \n\tThe type UserInterface must implement the inherited abstract method ErrorMessageHandler.showError(String)\n\tThe method setExceptionHandler(UserInterface) is undefined for the type Globals\n");
    }

    private void createGUI() {
        this.inputterChooser = new JComboBox<Object>(Globals.inputters.toArray());
        this.fileList = new JList<File>(this.files);
        this.fileList.setVisibleRowCount(3);
        JScrollPane fileListSP = new JScrollPane(this.fileList, 22, 32);
        fileListSP.setAlignmentX(0.0f);
        JButton[] jButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton button = jButtonArray[n2];
            button.addActionListener(this);
            ++n2;
        }
        JPanel inputButtonsPanel = new JPanel(new GridLayout(6, 1));
        int i = 0;
        while (i < 4) {
            inputButtonsPanel.add(this.buttons[i]);
            ++i;
        }
        inputButtonsPanel.add(Box.createVerticalGlue());
        inputButtonsPanel.add(Box.createVerticalGlue());
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        inputPanel.add((Component)this.inputterChooser, "North");
        inputPanel.add((Component)fileListSP, "Center");
        inputPanel.add((Component)inputButtonsPanel, "East");
        this.testersList = new JList<Object>(Globals.testers.toArray());
        this.testersList.setVisibleRowCount(5);
        JScrollPane testersListSP = new JScrollPane(this.testersList);
        JPanel processPanel = new JPanel(new BorderLayout());
        processPanel.setBorder(BorderFactory.createTitledBorder("Testers"));
        processPanel.add((Component)testersListSP, "Center");
        JPanel outputFolderPanel = new JPanel(new SpringLayout());
        JLabel folderLabel = new JLabel("Output Folder:", 11);
        outputFolderPanel.add(folderLabel);
        this.outputFolderTF = new JTextField(20);
        folderLabel.setLabelFor(this.outputFolderTF);
        outputFolderPanel.add(this.outputFolderTF);
        outputFolderPanel.add(this.buttons[6]);
        SpringUtilities.makeCompactGrid(outputFolderPanel, 1, 3, 6, 6, 6, 6);
        this.outputtersList = new JList<Object>(Globals.outputters.toArray());
        this.outputtersList.setVisibleRowCount(5);
        JScrollPane outputtersListSP = new JScrollPane(this.outputtersList);
        JPanel outputPanel = new JPanel(new BorderLayout());
        outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        outputPanel.add((Component)outputtersListSP, "Center");
        outputPanel.add((Component)outputFolderPanel, "South");
        JPanel bottomButtons = new JPanel(new GridLayout(1, 2));
        bottomButtons.add(this.buttons[4]);
        bottomButtons.add(this.buttons[5]);
        progressLabel = new JLabel("");
        this.progressBar = new JProgressBar(0);
        JPanel progressPanel = new JPanel(new GridLayout(2, 1));
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        progressPanel.add(progressLabel);
        progressPanel.add(this.progressBar);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)inputPanel, "North");
        topPanel.add((Component)processPanel, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)progressPanel, "Center");
        bottomPanel.add((Component)bottomButtons, "South");
        this.fc = new JFileChooser();
        this.frame = new JFrame("Evaluation Testbed");
        this.frame.getContentPane().add((Component)topPanel, "North");
        this.frame.getContentPane().add((Component)outputPanel, "Center");
        this.frame.getContentPane().add((Component)bottomPanel, "South");
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setLocation(UserInterface.SCREEN_SIZE.width / 2 - this.frame.getWidth() / 2, UserInterface.SCREEN_SIZE.height / 2 - this.frame.getHeight() / 2);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public static void run() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error occurred setting look and feel.\n\n" + ex.getMessage(), "Error", 0);
        }
        UserInterface ui = new UserInterface();
        ui.createGUI();
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        int buttonNumber = -1;
        int i = 0;
        while (i < this.buttons.length) {
            if (a.getSource().equals(this.buttons[i])) {
                buttonNumber = i;
            }
            ++i;
        }
        switch (buttonNumber) {
            case 0: {
                this.fc.setFileSelectionMode(0);
                this.fc.setMultiSelectionEnabled(true);
                int returnVal = this.fc.showOpenDialog(this.frame);
                if (returnVal == 0) {
                    File[] filesSelected = this.fc.getSelectedFiles();
                    int i2 = 0;
                    while (i2 < filesSelected.length) {
                        if (!this.files.contains(filesSelected[i2])) {
                            this.files.add(filesSelected[i2]);
                        }
                        ++i2;
                    }
                }
                this.fileList.setListData(this.files);
                break;
            }
            case 1: {
                this.fc.setFileSelectionMode(1);
                this.fc.setMultiSelectionEnabled(true);
                int returnVal2 = this.fc.showOpenDialog(this.frame);
                if (returnVal2 == 0) {
                    File[] directoriesSelected = this.fc.getSelectedFiles();
                    int i3 = 0;
                    while (i3 < directoriesSelected.length) {
                        File[] filesFromFolder = directoriesSelected[i3].listFiles();
                        int j = 0;
                        while (j < filesFromFolder.length) {
                            if (!(filesFromFolder[j].isDirectory() || filesFromFolder[j].isHidden() || this.files.contains(filesFromFolder[j]))) {
                                this.files.add(filesFromFolder[j]);
                            }
                            ++j;
                        }
                        ++i3;
                    }
                }
                this.fileList.setListData(this.files);
                break;
            }
            case 2: {
                Object[] selectedFiles = this.fileList.getSelectedValues();
                int i4 = 0;
                while (i4 < selectedFiles.length) {
                    this.files.remove(selectedFiles[i4]);
                    ++i4;
                }
                this.fileList.setListData(this.files);
                break;
            }
            case 3: {
                this.files.removeAllElements();
                this.fileList.setListData(this.files);
                break;
            }
            case 4: {
                this.outputFolderString = this.outputFolderTF.getText();
                if (this.files.size() == 0) {
                    JOptionPane.showMessageDialog(this.frame, "Please provide atleast one file to process.", "Error", 0);
                    return;
                }
                if (this.outputFolderString.equals("")) {
                    JOptionPane.showMessageDialog(this.frame, "Please provide an output folder.", "Error", 0);
                    return;
                }
                this.selectedTesters = new TreeSet<Tester<? extends TesterOptions>>();
                this.selectedOutputters = new TreeSet<Outputter>();
                Object[] objectArray = this.testersList.getSelectedValues();
                int n = objectArray.length;
                int filesFromFolder = 0;
                while (filesFromFolder < n) {
                    Object t = objectArray[filesFromFolder];
                    this.selectedTesters.add((Tester)t);
                    ++filesFromFolder;
                }
                objectArray = this.outputtersList.getSelectedValues();
                n = objectArray.length;
                filesFromFolder = 0;
                while (filesFromFolder < n) {
                    Object o = objectArray[filesFromFolder];
                    this.selectedOutputters.add((Outputter)o);
                    ++filesFromFolder;
                }
                if (this.selectedTesters.isEmpty()) {
                    JOptionPane.showMessageDialog(this.frame, "You must select atleast one processor.", "Error", 0);
                    return;
                }
                if (this.selectedOutputters.isEmpty()) {
                    JOptionPane.showMessageDialog(this.frame, "You must select atleast one outputter.", "Error", 0);
                    return;
                }
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UserInterface.this.vardGlobal.lockFinishProgress();
                            UserInterface.this.vardGlobal.startIndeterminateProgress();
                            UserInterface.this.vardGlobal.writeProgressMessage("Inputting");
                            UserInterface.this.processInput();
                            if (UserInterface.this.displayOptions()) {
                                UserInterface.this.vardGlobal.startIndeterminateProgress();
                                UserInterface.this.vardGlobal.writeProgressMessage("Processing");
                                UserInterface.this.processTesters();
                                UserInterface.this.vardGlobal.startIndeterminateProgress();
                                UserInterface.this.vardGlobal.writeProgressMessage("Outputting");
                                UserInterface.this.processOutput();
                            }
                            UserInterface.this.vardGlobal.unlockFinishProgress();
                            UserInterface.this.vardGlobal.finishProgress();
                        }
                        catch (IOException ex) {
                            UserInterface.this.vardGlobal.showException("Error occurred", ex);
                        }
                    }
                });
                thread.start();
                break;
            }
            case 5: {
                System.exit(0);
                break;
            }
            case 6: {
                this.fc.setFileSelectionMode(1);
                this.fc.setMultiSelectionEnabled(false);
                int saveReturnVal = this.fc.showSaveDialog(this.frame);
                if (saveReturnVal != 0) break;
                this.outputFolder = this.fc.getSelectedFile();
                this.outputFolderTF.setText(this.outputFolder.toString());
            }
        }
    }

    private boolean displayOptions() {
        int o;
        OptionsPanel optPanel;
        for (Tester<? extends TesterOptions> tester : this.selectedTesters) {
            tester.createOptions(this.selectedInputter);
            if (tester.getOptions().size() <= 0) continue;
            optPanel = new OptionsPanel(1000, tester.getOptions());
            o = JOptionPane.showConfirmDialog(this.frame, optPanel, tester.getName(), 2, 3);
            if (o == 2) {
                return false;
            }
            optPanel.setAllOptions();
        }
        for (Outputter outputter : this.selectedOutputters) {
            if (outputter.getOptions().size() <= 0) continue;
            optPanel = new OptionsPanel(100, outputter.getOptions());
            o = JOptionPane.showConfirmDialog(this.frame, optPanel, outputter.getName(), 2, 3);
            if (o == 2) {
                return false;
            }
            optPanel.setAllOptions();
        }
        return true;
    }

    private void processInput() throws IOException {
        this.selectedInputter = (Inputter)this.inputterChooser.getSelectedItem();
        this.selectedInputter.initialize(this.files);
        this.selectedInputter.parse();
    }

    private void processTesters() {
        for (Tester<? extends TesterOptions> tester : this.selectedTesters) {
            tester.initialize();
            tester.test(this.selectedInputter);
        }
    }

    private void processOutput() throws IOException {
        Calendar now = Calendar.getInstance();
        String date = String.valueOf(now.get(1)) + "-" + now.get(2) + "-" + now.get(5) + " " + now.get(11) + "h" + now.get(12) + "m" + now.get(13) + "s";
        File folder = new File(String.valueOf(this.outputFolderString) + "/" + date);
        folder.mkdirs();
        for (Outputter outputter : this.selectedOutputters) {
            outputter.initialize(this.selectedInputter, this.selectedTesters, folder);
            outputter.output();
        }
    }

    private void setButtonsEnabled(boolean e) {
        this.buttons[0].setEnabled(e);
        this.buttons[1].setEnabled(e);
        this.buttons[2].setEnabled(e);
        this.buttons[3].setEnabled(e);
        this.buttons[4].setEnabled(e);
        this.buttons[6].setEnabled(e);
        this.outputFolderTF.setEditable(e);
        this.inputterChooser.setEnabled(e);
        this.testersList.setEnabled(e);
        this.outputtersList.setEnabled(e);
        this.fileList.setEnabled(e);
    }

    @Override
    public void setProgressCurrent(int current) {
        this.progressBar.setValue(current);
    }

    @Override
    public void terminateProgressDisplay() {
    }

    @Override
    public void startIndeterminateProgress() {
        this.progressBar.setIndeterminate(true);
        this.setButtonsEnabled(false);
    }

    @Override
    public void startProgress(int max) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMaximum(max);
        this.setButtonsEnabled(false);
    }

    @Override
    public void finishProgress() {
        this.progressBar.setIndeterminate(false);
        this.setButtonsEnabled(true);
    }

    @Override
    public void writeProgressMessage(String message) {
        progressLabel.setText(message);
    }

    @Override
    public void showException(String message, Throwable e) {
        JOptionPane.showMessageDialog(this.frame, String.valueOf(message) + "\n\n" + e.getMessage(), "Error", 0);
    }

    @Override
    public /* synthetic */ void showError(String string) {
        throw new Error("Unresolved compilation problem: \n\tThe type UserInterface must implement the inherited abstract method ErrorMessageHandler.showError(String)\n");
    }
}

