/*
 * Decompiled with CFR 0.152.
 */
package testbed.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import testbed.gui.SpringUtilities;
import testbed.options.ChangeListener;
import testbed.options.Option;
import testbed.options.RepeatingIterator;

public class OptionsPanel
extends JPanel {
    private static final long serialVersionUID = 8281321276860893898L;
    private TreeMap<Option<?>, JRadioButton> plotRadioButtons = new TreeMap();
    private JList selectedList;
    private Collection<Option<?>> options;

    public OptionsPanel(int maxQuantity, final Collection<Option<?>> options) {
        super(new BorderLayout());
        ButtonGroup plotRBGroup = new ButtonGroup();
        this.options = options;
        this.selectedList = new JList();
        this.selectedList.setVisibleRowCount(maxQuantity < 5 ? maxQuantity : 5);
        this.selectedList.setEnabled(false);
        JPanel optionsPanel = new JPanel(new SpringLayout());
        for (Option<?> option : options) {
            JLabel optionLabel = new JLabel(String.valueOf(option.getLabel()) + ": ", 11);
            JPanel optionTitlePanel = new JPanel(new BorderLayout());
            if (option.isPlottable()) {
                JRadioButton rb = new JRadioButton();
                plotRBGroup.add(rb);
                this.plotRadioButtons.put(option, rb);
                optionTitlePanel.add((Component)rb, "West");
            } else {
                optionTitlePanel.add(Box.createGlue(), "West");
            }
            optionTitlePanel.add((Component)optionLabel, "Center");
            optionsPanel.add(optionTitlePanel);
            JComponent optionComp = maxQuantity == 1 ? option.getSingleComponent(this) : option.getRangeComponent(this);
            optionLabel.setLabelFor(optionComp);
            optionsPanel.add(optionComp);
            option.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged() {
                    boolean noneYet = false;
                    for (Option opt : options) {
                        if (opt.calculateSelectedValues().size() != 0) continue;
                        noneYet = true;
                    }
                    if (!noneYet) {
                        Vector optionsIts = new Vector();
                        int varyingCount = 0;
                        int quantity = 0;
                        for (Option option : options) {
                            int n = option.calculateSelectedValues().size();
                            if (n > quantity) {
                                quantity = n;
                            }
                            if (!option.isConstant()) {
                                ++varyingCount;
                                continue;
                            }
                            optionsIts.add(new RepeatingIterator(option.calculateSelectedValues()));
                        }
                        if (varyingCount > 1) {
                            int[] sizes = new int[varyingCount];
                            int i = 0;
                            for (Option option : options) {
                                if (option.isConstant()) continue;
                                sizes[i] = option.calculateSelectedValues().size();
                                ++i;
                            }
                            i = 0;
                            for (Option option : options) {
                                if (option.isConstant()) continue;
                                int s = 1;
                                int a = 1;
                                int f = i + 1;
                                while (f < sizes.length) {
                                    s *= sizes[f];
                                    ++f;
                                }
                                int b = i - 1;
                                while (b >= 0) {
                                    a *= sizes[b];
                                    --b;
                                }
                                quantity = s * a * sizes[i];
                                optionsIts.add(option.getRepeatedSelectedValues(s, a).iterator());
                                ++i;
                            }
                        } else if (varyingCount == 1) {
                            for (Option option : options) {
                                if (option.isConstant()) continue;
                                optionsIts.add(new RepeatingIterator(option.calculateSelectedValues()));
                            }
                        }
                        String[] optionSets = new String[quantity];
                        int i = 0;
                        while (i < quantity) {
                            optionSets[i] = "";
                            for (Iterator iterator : optionsIts) {
                                int n = i;
                                optionSets[n] = String.valueOf(optionSets[n]) + " / " + iterator.next();
                            }
                            optionSets[i] = optionSets[i].substring(3);
                            ++i;
                        }
                        OptionsPanel.this.selectedList.setListData(optionSets);
                    }
                }
            });
        }
        SpringUtilities.makeCompactGrid(optionsPanel, options.size(), 2, 6, 6, 6, 6);
        this.add((Component)optionsPanel, "Center");
        JScrollPane listSP = new JScrollPane(this.selectedList, 22, 32);
        this.add((Component)listSP, "South");
        for (Option<?> option : options) {
            option.fireChangeEvent();
        }
    }

    public void setAllOptions() {
        int varyingCount = 0;
        for (Option<?> option : this.options) {
            if (option.isPlottable() && this.plotRadioButtons.get(option).isSelected()) {
                option.setIsPlotted(true);
            }
            option.setSelectedValues();
            if (option.isConstant()) continue;
            ++varyingCount;
        }
        if (varyingCount < 2) {
            return;
        }
        int[] sizes = new int[varyingCount];
        int i = 0;
        for (Option<?> option : this.options) {
            if (option.isConstant()) continue;
            sizes[i] = option.getSelectedValues().size();
            ++i;
        }
        i = 0;
        for (Option<?> option : this.options) {
            if (option.isConstant()) continue;
            int s = 1;
            int a = 1;
            int f = i + 1;
            while (f < sizes.length) {
                s *= sizes[f];
                ++f;
            }
            int b = i - 1;
            while (b >= 0) {
                a *= sizes[b];
                --b;
            }
            option.repeatSelectedValues(s, a);
            ++i;
        }
    }
}

