/*
 * Decompiled with CFR 0.152.
 */
package testbed;

import java.util.TreeSet;
import testbed.input.Inputter;
import testbed.input.SampleInputter;
import testbed.input.SampleInputterAllVariant;
import testbed.input.SampleInputterRemoveTags;
import testbed.input.SampleInputterVardVariantsAndReplacedTags;
import testbed.input.SampleInputterVardVariantsOnly;
import testbed.input.VARDInputter;
import testbed.input.VardedXMLInputter;
import testbed.input.VariantsListInputter;
import testbed.output.AverageScoreGraphOutputter;
import testbed.output.DetectionStatsGraphOutputter;
import testbed.output.DetectionStatsOutputter;
import testbed.output.FalsePositivesGraphOutputter;
import testbed.output.MatchListTextOutputter;
import testbed.output.Outputter;
import testbed.output.PrecisionGraphOutputter;
import testbed.output.ProcessingTimeGraphOutputter;
import testbed.output.ProcessingTimesTextOutputter;
import testbed.output.RecallAgainstPrecisionGraphOutputter;
import testbed.output.RecallGraphOutputter;
import testbed.output.ScoresTextOutputter;
import testbed.output.WouldReplaceGraphOutputter;
import testbed.testing.DictionaryCheckSourceTester;
import testbed.testing.DictionaryCheckTargetTester;
import testbed.testing.DictionaryNormalisedEditDistanceTester;
import testbed.testing.GroupedTester;
import testbed.testing.NormalisedEditDistanceTester;
import testbed.testing.NorvigTester;
import testbed.testing.SoundexTester;
import testbed.testing.Tester;
import testbed.testing.TesterOptions;
import testbed.testing.TrainingTester;
import testbed.testing.VARD2Tester;
import testbed.testing.VARDKVLTester;
import testbed.testing.VARDRulesTester;
import testbed.testing.VARDSoundexTester;
import testbed.testing.VARDWordDetectTester;

public class Globals {
    public static TreeSet<Inputter> inputters = new TreeSet();
    public static TreeSet<Tester<? extends TesterOptions>> testers = new TreeSet();
    public static TreeSet<Outputter> outputters = new TreeSet();
    public static Inputter selectedInputter;
    public static boolean storeMatches;

    static {
        storeMatches = true;
    }

    public static void populate() {
        inputters.add(new VariantsListInputter());
        inputters.add(new VardedXMLInputter());
        inputters.add(new VARDInputter());
        inputters.add(new SampleInputter());
        inputters.add(new SampleInputterAllVariant());
        inputters.add(new SampleInputterRemoveTags());
        inputters.add(new SampleInputterVardVariantsOnly());
        inputters.add(new SampleInputterVardVariantsAndReplacedTags());
        testers.add(new VARDSoundexTester());
        testers.add(new SoundexTester());
        testers.add(new VARDRulesTester());
        testers.add(new VARDKVLTester());
        testers.add(new VARD2Tester());
        testers.add(new DictionaryCheckSourceTester());
        testers.add(new DictionaryCheckTargetTester());
        testers.add(new NormalisedEditDistanceTester());
        testers.add(new DictionaryNormalisedEditDistanceTester());
        testers.add(new VARDWordDetectTester());
        testers.add(new GroupedTester());
        testers.add(new TrainingTester());
        testers.add(new NorvigTester());
        outputters.add(new ScoresTextOutputter());
        outputters.add(new ProcessingTimesTextOutputter());
        outputters.add(new MatchListTextOutputter());
        outputters.add(new RecallGraphOutputter());
        outputters.add(new PrecisionGraphOutputter());
        outputters.add(new FalsePositivesGraphOutputter());
        outputters.add(new ProcessingTimeGraphOutputter());
        outputters.add(new AverageScoreGraphOutputter());
        outputters.add(new DetectionStatsOutputter());
        outputters.add(new RecallAgainstPrecisionGraphOutputter());
        outputters.add(new DetectionStatsGraphOutputter());
        outputters.add(new WouldReplaceGraphOutputter());
    }

    public static String convertIllegalFileName(String filename) {
        return filename.replaceAll("[\\?\\[\\]/\\=\\+\\<\\>\\:\\;,\\*\\|\\^]+", "-");
    }
}

