/*
 * Decompiled with CFR 0.152.
 */
package sampler.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import model.Globals;
import model.Setup;
import sampler.gui.SpringUtilities;

public class TrainingSamplesUI
implements ActionListener {
    static final Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
    private JButton[] buttons = new JButton[]{new JButton("Add file(s)"), new JButton("Add folder(s)"), new JButton("Remove selected file(s)"), new JButton("Clear list"), new JButton("Process listed file(s)"), new JButton("Exit"), new JButton("Browse"), new JButton("Browse")};
    private JList fileList;
    private TreeSet<File> files = new TreeSet();
    private JScrollPane fileListSP;
    private JTextField outputFolderTF;
    private JProgressBar progressBar;
    private static JLabel progressLabel;
    private JFileChooser fc;
    private JFileChooser setupFC;
    private JFrame frame;
    private JTextField sampleSizeTF;
    private JTextField minContributionTF;
    private JTextField maxContributionTF;
    private JTextField toleranceTF;
    private File outputFolder;
    boolean inputFinished = false;
    boolean filesFinished = false;
    private int fileCounter = 0;
    private Timer fileTimer;
    private String outputFolderString;
    private JComboBox setupComboBox;
    private static Globals global;

    private TrainingSamplesUI() {
        global = Globals.getInstance();
    }

    private void createGUI() {
        JPanel setupPanel = new JPanel(new BorderLayout());
        setupPanel.setBorder(BorderFactory.createTitledBorder("Setup"));
        Vector<Object> previousSetups = new Vector();
        try {
            previousSetups = Setup.getPreviousSetupsList();
        }
        catch (IOException e) {
            global.showException("Error occurred collecting list of previous setups", e);
            return;
        }
        this.setupComboBox = new JComboBox(previousSetups);
        this.setupComboBox.setEditable(true);
        setupPanel.setTransferHandler(new SetupFolderTransferHandler());
        final JTextField comboBoxTF = new JTextField(20);
        comboBoxTF.setTransferHandler(new SetupFolderTransferHandler());
        comboBoxTF.setEditable(false);
        this.setupComboBox.setEditor(new ComboBoxEditor(){

            @Override
            public void addActionListener(ActionListener arg0) {
                comboBoxTF.addActionListener(arg0);
            }

            @Override
            public Component getEditorComponent() {
                return comboBoxTF;
            }

            @Override
            public Object getItem() {
                return comboBoxTF.getText();
            }

            @Override
            public void removeActionListener(ActionListener arg0) {
                comboBoxTF.removeActionListener(arg0);
            }

            @Override
            public void selectAll() {
                comboBoxTF.selectAll();
            }

            @Override
            public void setItem(Object arg0) {
                comboBoxTF.setText(arg0.toString());
            }
        });
        setupPanel.add((Component)this.setupComboBox, "Center");
        setupPanel.add((Component)this.buttons[7], "East");
        this.setupFC = new JFileChooser();
        this.setupFC.setFileSelectionMode(1);
        this.setupFC.setMultiSelectionEnabled(false);
        this.setupFC.setCurrentDirectory(new File(System.getProperty("user.dir")));
        this.fc = new JFileChooser();
        this.fileList = new JList<Object>(this.files.toArray());
        this.fileList.setVisibleRowCount(10);
        this.fileList.setTransferHandler(new AddTransferHandler());
        this.fileListSP = new JScrollPane(this.fileList, 22, 32);
        this.fileListSP.setAlignmentX(0.0f);
        JButton[] jButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            JButton button = jButtonArray[n2];
            button.addActionListener(this);
            ++n2;
        }
        JPanel inputButtonsPanel = new JPanel(new GridLayout(6, 1));
        int i = 0;
        while (i < 4) {
            inputButtonsPanel.add(this.buttons[i]);
            ++i;
        }
        inputButtonsPanel.add(Box.createVerticalGlue());
        inputButtonsPanel.add(Box.createVerticalGlue());
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        inputPanel.add((Component)this.fileListSP, "Center");
        inputPanel.add((Component)inputButtonsPanel, "East");
        JPanel optionsPanel = new JPanel(new SpringLayout());
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        JLabel sampleSizeLabel = new JLabel("Sample Size:", 11);
        this.sampleSizeTF = new JTextField("1000", 5);
        sampleSizeLabel.setLabelFor(this.sampleSizeTF);
        optionsPanel.add(sampleSizeLabel);
        optionsPanel.add(this.sampleSizeTF);
        JLabel toleranceLabel = new JLabel("Tolerance:", 11);
        this.toleranceTF = new JTextField("10", 4);
        toleranceLabel.setLabelFor(this.toleranceTF);
        optionsPanel.add(toleranceLabel);
        optionsPanel.add(this.toleranceTF);
        JLabel minContributionLabel = new JLabel("Min. Contribution:", 11);
        this.minContributionTF = new JTextField("10", 4);
        minContributionLabel.setLabelFor(this.minContributionTF);
        optionsPanel.add(minContributionLabel);
        optionsPanel.add(this.minContributionTF);
        JLabel maxContributionLabel = new JLabel("Max. Contribution:", 11);
        this.maxContributionTF = new JTextField("100", 4);
        maxContributionLabel.setLabelFor(this.maxContributionTF);
        optionsPanel.add(maxContributionLabel);
        optionsPanel.add(this.maxContributionTF);
        SpringUtilities.makeCompactGrid(optionsPanel, 2, 4, 6, 6, 6, 6);
        JPanel outputFilePanel = new JPanel(new SpringLayout());
        JLabel folderLabel = new JLabel("Output Folder:", 11);
        outputFilePanel.add(folderLabel);
        this.outputFolderTF = new JTextField(20);
        this.outputFolderTF.setTransferHandler(new FolderTransferHandler());
        folderLabel.setLabelFor(this.outputFolderTF);
        outputFilePanel.add(this.outputFolderTF);
        outputFilePanel.add(this.buttons[6]);
        SpringUtilities.makeCompactGrid(outputFilePanel, 1, 3, 6, 6, 6, 6);
        JPanel bottomButtons = new JPanel(new GridLayout(1, 2));
        bottomButtons.add(this.buttons[4]);
        bottomButtons.add(this.buttons[5]);
        progressLabel = new JLabel("");
        this.progressBar = new JProgressBar(0);
        JPanel progressPanel = new JPanel(new GridLayout(2, 1));
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        progressPanel.add(progressLabel);
        progressPanel.add(this.progressBar);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)progressPanel, "Center");
        bottomPanel.add((Component)bottomButtons, "South");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)setupPanel, "North");
        topPanel.add((Component)inputPanel, "Center");
        topPanel.add((Component)optionsPanel, "South");
        this.frame = new JFrame("Text Sampler");
        this.frame.getContentPane().add((Component)topPanel, "North");
        this.frame.getContentPane().add((Component)outputFilePanel, "Center");
        this.frame.getContentPane().add((Component)bottomPanel, "South");
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setLocation(TrainingSamplesUI.SCREEN_SIZE.width / 2 - this.frame.getWidth() / 2, TrainingSamplesUI.SCREEN_SIZE.height / 2 - this.frame.getHeight() / 2);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Error occurred setting look and feel.\n\n" + ex.getMessage(), "Error", 0);
        }
        TrainingSamplesUI ui = new TrainingSamplesUI();
        ui.createGUI();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        throw new Error("Unresolved compilation problem: \n\tThe method getListStringFromFolder(File) in the type Setup is not applicable for the arguments (String)\n");
    }

    private void setButtonsEnabled(boolean e) {
        this.buttons[0].setEnabled(e);
        this.buttons[1].setEnabled(e);
        this.buttons[2].setEnabled(e);
        this.buttons[3].setEnabled(e);
        this.buttons[4].setEnabled(e);
        this.buttons[6].setEnabled(e);
        this.outputFolderTF.setEditable(e);
    }

    public void finishMessages() {
        progressLabel.setText("");
        this.setButtonsEnabled(true);
    }

    public void writeMessage(String message) {
        this.setButtonsEnabled(false);
        progressLabel.setText(message);
    }

    public void displayError(String message) {
        JOptionPane.showMessageDialog(this.frame, message, "Error", 0);
    }

    public void showException(String message, Exception ex) {
        JOptionPane.showMessageDialog(this.frame, String.valueOf(message) + "\n\n" + ex.getMessage(), "Error", 0);
        ex.printStackTrace();
    }

    public String getCommonFolderString() {
        String latest = this.files.first().getAbsolutePath();
        latest = latest.substring(0, latest.lastIndexOf(File.separator));
        for (File file : this.files) {
            String currentFileString = file.getAbsolutePath();
            while (!currentFileString.startsWith(latest)) {
                latest = latest.substring(0, latest.lastIndexOf(File.separator));
            }
        }
        return latest.replace("\\", "\\\\");
    }

    private static void walkFolder(TreeSet<File> toAddTo, File folder) {
        File[] filesFromFolder;
        File[] fileArray = filesFromFolder = folder.listFiles();
        int n = filesFromFolder.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                if (!file.isHidden() && !toAddTo.contains(file)) {
                    toAddTo.add(file);
                }
            } else {
                TrainingSamplesUI.walkFolder(toAddTo, file);
            }
            ++n2;
        }
    }

    private class AddTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -3375927171804520959L;

        private AddTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List filesAdded;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                filesAdded = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (filesAdded.isEmpty()) {
                return false;
            }
            new Thread(){

                @Override
                public void run() {
                    for (File file : filesAdded) {
                        if (file.isDirectory()) {
                            TrainingSamplesUI.walkFolder(TrainingSamplesUI.this.files, file);
                            continue;
                        }
                        TrainingSamplesUI.this.files.add(file);
                    }
                    TrainingSamplesUI.this.fileList.setListData(TrainingSamplesUI.this.files.toArray());
                }
            }.start();
            return true;
        }
    }

    private class FolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -260318740428503951L;

        private FolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List files;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (files.isEmpty()) {
                return false;
            }
            File folder = (File)files.get(0);
            if (!folder.isDirectory()) {
                folder = folder.getParentFile();
            }
            TrainingSamplesUI.this.outputFolderTF.setText(folder.getAbsolutePath());
            return true;
        }
    }

    private class SetupFolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -260318740428503951L;

        private SetupFolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            throw new Error("Unresolved compilation problem: \n\tThe method getListStringFromFolder(File) in the type Setup is not applicable for the arguments (String)\n");
        }
    }
}

