/*
 * Decompiled with CFR 0.152.
 */
package sampler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import model.ConfidenceWeights;
import model.Setup;
import model.doc.DocumentModel;
import model.doc.InvalidInstanceChangeException;
import model.lookup.LookUpDictionary;
import sampler.Partition;
import sampler.RandomAccessQueue;

public class Sampler {
    private static final String NEW_LINE = System.getProperty("line.separator");

    public String getCommonFolderString(Collection<File> files) {
        String latest = files.iterator().next().getAbsolutePath();
        latest = latest.substring(0, latest.lastIndexOf(File.separator));
        for (File file : files) {
            String currentFileString = file.getAbsolutePath();
            while (!currentFileString.startsWith(latest)) {
                latest = latest.substring(0, latest.lastIndexOf(File.separator));
            }
        }
        return latest;
    }

    public void buildSamplesAllInOne(Set<File> inputFiles, File outputFolder, int sampleSize, int tolerance, int minContribution, int maxContribution, Setup setup) throws IOException, BadLocationException, InvalidInstanceChangeException {
        outputFolder.mkdir();
        RandomAccessQueue<Partition> allPartitions = new RandomAccessQueue<Partition>();
        File partitionFolder = new File(outputFolder, "partitioned_files");
        partitionFolder.mkdir();
        File samplesFolder = new File(outputFolder, "samples");
        samplesFolder.mkdir();
        File remainderFolder = new File(outputFolder, "remainder");
        remainderFolder.mkdir();
        File tooFewFolder = new File(outputFolder, "too_few_tokens");
        tooFewFolder.mkdir();
        String commonFolder = this.getCommonFolderString(inputFiles);
        LookUpDictionary lud = new LookUpDictionary(setup);
        ConfidenceWeights confidenceWeights = new ConfidenceWeights(setup);
        DocumentModel docModel = new DocumentModel(setup, confidenceWeights, lud);
        Charset charset = docModel.getCharset();
        for (File file : inputFiles) {
            Object line;
            String fileString = file.getAbsolutePath().replace(commonFolder, "");
            Collection<Partition> partitions = this.partitionFile(file, minContribution, maxContribution, docModel);
            if (partitions.isEmpty()) {
                File oFile = new File(String.valueOf(tooFewFolder.getAbsolutePath()) + fileString);
                oFile.getParentFile().mkdirs();
                oFile.createNewFile();
                PrintWriter ofw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(oFile), charset));
                LineNumberReader in = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
                while ((line = in.readLine()) != null) {
                    ofw.println((String)line);
                }
                ofw.close();
                in.close();
                continue;
            }
            File pFile = new File(String.valueOf(partitionFolder.getAbsolutePath()) + fileString);
            pFile.getParentFile().mkdirs();
            pFile.createNewFile();
            PrintWriter pfw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pFile), charset));
            line = partitions.iterator();
            while (line.hasNext()) {
                Partition partition = line.next();
                pfw.println();
                pfw.println("<partition file=\"" + partition.file.getAbsolutePath() + "\" part=\"" + partition.number + "\" tokens=\"" + partition.words + "\">");
                pfw.print(partition.text);
                pfw.println("</partition>");
            }
            pfw.close();
            allPartitions.addAll(partitions);
        }
        Vector<Partition> sampleParts = new Vector<Partition>();
        int currentCount = 0;
        int samples = 0;
        int repeatCount = 0;
        int sampleMakeRepeat = 0;
        while (!allPartitions.isEmpty()) {
            ++repeatCount;
            int partitionSize = ((Partition)allPartitions.element()).words;
            int nextCount = currentCount + partitionSize;
            if (nextCount <= sampleSize + tolerance) {
                currentCount = nextCount;
                sampleParts.add((Partition)allPartitions.remove());
            }
            if (nextCount < sampleSize - tolerance) continue;
            if (nextCount > sampleSize + tolerance) {
                if (sampleMakeRepeat > 100 && currentCount > 0) {
                    System.err.println("Can't make sample big enough: Sample_" + (samples + 1));
                    this.outputSample(remainderFolder, samples + 1, currentCount, sampleParts, charset);
                    currentCount = 0;
                    ++samples;
                    repeatCount = 0;
                    sampleMakeRepeat = 0;
                    sampleParts.clear();
                    continue;
                }
                if (repeatCount != 20) continue;
                for (Partition sample : sampleParts) {
                    allPartitions.add(sample);
                }
                currentCount = 0;
                sampleParts.clear();
                ++sampleMakeRepeat;
                repeatCount = 0;
                continue;
            }
            this.outputSample(samplesFolder, samples + 1, currentCount, sampleParts, charset);
            currentCount = 0;
            ++samples;
            repeatCount = 0;
            sampleMakeRepeat = 0;
            sampleParts.clear();
        }
        if (!sampleParts.isEmpty()) {
            this.outputSample(remainderFolder, samples + 1, currentCount, sampleParts, charset);
        }
    }

    private static String padWithZeroes(int num) {
        if (num < 10) {
            return "000" + num;
        }
        if (num < 100) {
            return "00" + num;
        }
        if (num < 1000) {
            return "0" + num;
        }
        return "" + num;
    }

    private void outputSample(File outputFolder, int number, int wordCount, Collection<Partition> sampleParts, Charset charset) throws IOException {
        PrintWriter textOut = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputFolder, "Sample_" + Sampler.padWithZeroes(number) + ".txt")), charset));
        textOut.println("<sample number=\"" + number + "\" tokens=\"" + wordCount + "\">");
        for (Partition partition : sampleParts) {
            textOut.println();
            textOut.println("<partition file=\"" + partition.file.getAbsolutePath() + "\" part=\"" + partition.number + "\" tokens=\"" + partition.words + "\">");
            textOut.print(partition.text);
            textOut.println("</partition>");
        }
        textOut.println();
        textOut.println("</sample>");
        textOut.close();
        System.out.println("Created Sample_" + number + ": " + wordCount + " words");
    }

    private int getContribution(int minContribution, int maxContribution, int instancesLeft) {
        int contribution = new Random().nextInt(maxContribution - minContribution) + minContribution;
        if (instancesLeft - contribution != 0 && instancesLeft - contribution < minContribution && (contribution += instancesLeft) > maxContribution) {
            return this.getContribution(minContribution, maxContribution, instancesLeft);
        }
        return contribution;
    }

    private Collection<Partition> partitionFile(File file, int n, int n2, DocumentModel documentModel) throws IOException, BadLocationException, InvalidInstanceChangeException {
        throw new Error("Unresolved compilation problem: \n\tThe method processNewFile(File) in the type DocumentModel is not applicable for the arguments (File, boolean, boolean)\n");
    }
}

