/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.TreeMap;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.Globals;
import model.SuggestedReplacement;
import model.doc.CannotExecuteException;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.TextReplacementHandler;
import model.doc.ThreadableEdit;
import model.doc.VariantInstance;
import model.doc.WordHolder;

public class RevertAllReplacedEdit
extends AbstractUndoableEdit
implements ThreadableEdit {
    private static final long serialVersionUID = 1L;
    private TreeMap<ReplacedInstance, VariantInstance> instances;
    private WordHolder wh;
    private InstanceHolder<ReplacedInstance> from;
    private Globals global = Globals.getInstance();
    private final TextReplacementHandler textReplacementHandler;
    private final boolean isAlone;
    private boolean executed = false;
    private boolean undone = false;
    private String progressMessage;

    public RevertAllReplacedEdit(WordHolder wh, SuggestedReplacement rep, TextReplacementHandler textReplacementHandler) throws InvalidInstanceChangeException {
        this.wh = wh;
        this.textReplacementHandler = textReplacementHandler;
        this.from = wh.getAsReplaced(rep.getReplacementStringWithoutChangingCapitalisation());
        if (this.from == null) {
            throw new InvalidInstanceChangeException("Replacement not found.");
        }
        this.isAlone = this.from.size() == 1;
        this.instances = new TreeMap();
        for (ReplacedInstance ri : this.from.getInstances()) {
            VariantInstance vi = (VariantInstance)ri.getPreviousInstance();
            if (vi == null) {
                vi = new VariantInstance(ri);
            }
            this.instances.put(ri, vi);
        }
        this.progressMessage = "Revert all " + this.instances.firstKey().toString();
    }

    @Override
    public void execute() throws CannotExecuteException {
        if (!this.executed) {
            block12: {
                this.global.startProgress(this.instances.size());
                this.global.writeProgressMessage("Executing: " + this.progressMessage);
                int count = 0;
                try {
                    try {
                        for (ReplacedInstance ri : this.instances.keySet()) {
                            ri.setPreviousInstance(this.instances.get(ri));
                            ri.revertInText(this.textReplacementHandler);
                            this.global.setProgressCurrent(++count);
                        }
                        break block12;
                    }
                    catch (BadLocationException e) {
                        try {
                            for (ReplacedInstance ri : this.instances.keySet()) {
                                if (!ri.isReverted()) continue;
                                ri.setupInText(this.textReplacementHandler);
                                this.global.setProgressCurrent(--count);
                            }
                        }
                        catch (BadLocationException ex) {
                            this.global.showException("Reversing " + this.progressMessage + " failed.", ex);
                        }
                    }
                    this.global.showException(String.valueOf(this.progressMessage) + " failed.", e);
                    throw new CannotExecuteException(String.valueOf(this.progressMessage) + " failed.");
                }
                finally {
                    this.global.finishProgress();
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Executing: " + this.progressMessage);
            this.from.emptyInstances();
            this.wh.getAsVariant().addInstances(this.instances.values());
            if (this.isAlone) {
                this.wh.removeAsReplaced(this.instances.firstKey().getReplacement().getReplacementStringWithoutChangingCapitalisation());
            }
        } else {
            throw new CannotExecuteException("Cannot execute twice.");
        }
        this.executed = true;
        this.global.finishProgress();
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.executed) {
            block12: {
                this.global.startProgress(this.instances.size());
                this.global.writeProgressMessage("Undoing: " + this.progressMessage);
                int count = 0;
                this.wh.getAsVariant().removeInstances(this.instances.values());
                this.from.addInstances(this.instances.keySet());
                try {
                    try {
                        for (ReplacedInstance ri : this.instances.keySet()) {
                            ri.setupInText(this.textReplacementHandler);
                            this.global.setProgressCurrent(++count);
                        }
                        break block12;
                    }
                    catch (BadLocationException e) {
                        try {
                            for (ReplacedInstance ri : this.instances.keySet()) {
                                if (!ri.isSetup()) continue;
                                ri.revertInText(this.textReplacementHandler);
                                this.global.setProgressCurrent(--count);
                            }
                        }
                        catch (BadLocationException ex) {
                            this.global.showException("Reversing undo " + this.progressMessage + " failed.", ex);
                        }
                    }
                    this.global.showException("Undoing " + this.progressMessage + " failed.", e);
                    throw new CannotUndoException();
                }
                finally {
                    this.global.finishProgress();
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Undoing: " + this.progressMessage);
            if (this.isAlone) {
                this.wh.addAsReplaced(this.instances.firstKey().getReplacement().getReplacementStringWithoutChangingCapitalisation(), this.from);
            }
        } else {
            throw new CannotUndoException();
        }
        this.undone = true;
        this.global.finishProgress();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.undone) {
            block12: {
                this.global.startProgress(this.instances.size());
                this.global.writeProgressMessage("Redoing: " + this.progressMessage);
                int count = 0;
                try {
                    try {
                        for (ReplacedInstance ri : this.instances.keySet()) {
                            ri.revertInText(this.textReplacementHandler);
                            this.global.setProgressCurrent(++count);
                        }
                        break block12;
                    }
                    catch (BadLocationException e) {
                        try {
                            for (ReplacedInstance ri : this.instances.keySet()) {
                                if (!ri.isReverted()) continue;
                                ri.setupInText(this.textReplacementHandler);
                                this.global.setProgressCurrent(--count);
                            }
                        }
                        catch (BadLocationException ex) {
                            this.global.showException("Reversing redo " + this.progressMessage + " failed.", ex);
                        }
                    }
                    this.global.showException("Redoing " + this.progressMessage + " failed.", e);
                    throw new CannotRedoException();
                }
                finally {
                    this.global.finishProgress();
                }
            }
            this.global.startIndeterminateProgress();
            this.global.writeProgressMessage("Redoing: " + this.progressMessage);
            this.from.removeInstances(this.instances.keySet());
            this.wh.getAsVariant().addInstances(this.instances.values());
            if (this.isAlone) {
                this.wh.removeAsReplaced(this.instances.firstKey().getReplacement().getReplacementStringWithoutChangingCapitalisation());
            }
        } else {
            throw new CannotRedoException();
        }
        this.undone = false;
        this.global.finishProgress();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return this.progressMessage;
    }

    public String getActionName() {
        return "Revert all";
    }
}

