/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.SuggestedReplacement;
import model.doc.HolderChangeListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.ReplacedInstance;
import model.doc.TextReplacementHandler;
import model.doc.VariantInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;
import model.lookup.ReplacementWord;
import model.lookup.VariantReplacement;

public class NormaliseVariantInstanceEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private final VariantInstance vi;
    private ReplacedInstance ri;
    private boolean addToKVL;
    private final InstanceHolder<VariantInstance> from;
    private InstanceHolder<ReplacedInstance> to;
    private boolean toIsNew = true;
    private final WordHolder wh;
    private final LookUpDictionary lud;
    private final TextReplacementHandler textReplacementHandler;
    private final SuggestedReplacement rep;
    private boolean executed = false;
    private boolean undone = false;

    public NormaliseVariantInstanceEdit(VariantInstance vi, SuggestedReplacement rep, TextReplacementHandler textReplacementHandler, HolderChangeListener holderChangeListener, LookUpDictionary lud, boolean auto, boolean addToKVL, boolean changeCapitalisation) throws InvalidInstanceChangeException {
        this.vi = vi;
        this.textReplacementHandler = textReplacementHandler;
        this.lud = lud;
        this.rep = rep;
        this.addToKVL = addToKVL;
        this.wh = vi.holder;
        this.from = this.wh.getAsVariant();
        this.to = this.wh.getAsReplaced(rep.getReplacementStringWithoutChangingCapitalisation());
        if (this.to == null) {
            this.to = new InstanceHolder(this.wh.getWord(), this.wh, holderChangeListener);
            this.toIsNew = true;
        }
        String replacementOriginal = changeCapitalisation ? rep.getReplacementString(vi.getCapitalisation()) : rep.getReplacementStringWithoutChangingCapitalisation();
        HashMap<String, String> entitiesContainedWithin = new HashMap<String, String>();
        String replacementDisplayString = textReplacementHandler.getTextWithReplacedEntities(replacementOriginal, entitiesContainedWithin);
        this.ri = null;
        Instance p = vi;
        while ((p = p.getPreviousInstance()) != null && p != vi) {
            if (p.getType() != 102 || !((ReplacedInstance)p).getReplacement().equals(rep)) continue;
            this.ri = (ReplacedInstance)p;
            break;
        }
        if (this.ri == null) {
            this.ri = new ReplacedInstance(vi, replacementOriginal, replacementDisplayString, entitiesContainedWithin, this.to, auto, rep);
        }
    }

    public ReplacedInstance getReplacedInstance() {
        return this.ri;
    }

    public void execute() throws InvalidInstanceChangeException, BadLocationException {
        if (!this.executed) {
            if (this.from.removeInstance(this.vi)) {
                ReplacementWord newRW;
                VariantReplacement newVR;
                if (!this.to.addInstance(this.ri)) {
                    this.from.addInstance(this.vi);
                    throw new InvalidInstanceChangeException(this.vi + " could not be replaced");
                }
                this.ri.setupInText(this.textReplacementHandler);
                this.vi.setPreviousInstance(this.ri);
                if (this.toIsNew) {
                    this.wh.addAsReplaced(this.rep.getReplacementStringWithoutChangingCapitalisation(), this.to);
                }
                if (this.addToKVL && (newVR = this.lud.addUserVariant(this.rep.getOriginal(), this.rep.getReplacementStringWithoutChangingCapitalisation())) != null && (newRW = newVR.getReplacement()) != null) {
                    this.rep.setReplacementWord("KV", newVR.getReplacement());
                }
                this.executed = true;
                return;
            }
            throw new InvalidInstanceChangeException(this.vi + " could not be replaced");
        }
        throw new InvalidInstanceChangeException("Can only execute once. Replace " + this.vi + " with " + this.rep.getReplacementStringWithoutChangingCapitalisation());
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.executed) {
            try {
                this.ri.revertInText(this.textReplacementHandler);
                if (this.to.removeInstance(this.ri)) {
                    if (!this.from.addInstance(this.vi)) {
                        this.to.addInstance(this.ri);
                        this.ri.setupInText(this.textReplacementHandler);
                        throw new CannotUndoException();
                    }
                    if (this.toIsNew) {
                        this.wh.removeAsReplaced(this.rep.getReplacementStringWithoutChangingCapitalisation());
                    }
                    this.undone = true;
                    return;
                }
            }
            catch (BadLocationException ex) {
                throw new CannotUndoException();
            }
        }
        throw new CannotUndoException();
    }

    @Override
    public void redo() throws CannotRedoException {
        block7: {
            if (this.undone) {
                try {
                    if (this.from.removeInstance(this.vi)) {
                        ReplacementWord newRW;
                        VariantReplacement newVR;
                        if (!this.to.addInstance(this.ri)) {
                            this.from.addInstance(this.vi);
                            throw new CannotRedoException();
                        }
                        this.ri.setupInText(this.textReplacementHandler);
                        if (this.toIsNew) {
                            this.wh.addAsReplaced(this.rep.getReplacementStringWithoutChangingCapitalisation(), this.to);
                        }
                        if (this.addToKVL && (newVR = this.lud.addUserVariant(this.rep.getOriginal(), this.rep.getReplacementStringWithoutChangingCapitalisation())) != null && (newRW = newVR.getReplacement()) != null) {
                            this.rep.setReplacementWord("KV", newVR.getReplacement());
                        }
                        this.undone = false;
                        return;
                    }
                    break block7;
                }
                catch (BadLocationException ex) {
                    throw new CannotRedoException();
                }
            }
            throw new CannotRedoException();
        }
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return "Normalise (" + this.ri.toString() + ")";
    }

    public String getActionName() {
        return "Normalise instance";
    }

    public WordHolder getWordHolder() {
        return this.wh;
    }
}

