/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.doc.CorrectInstance;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InvalidInstanceChangeException;
import model.doc.VariantInstance;
import model.doc.WordHolder;

public class MarkFInstanceAsTEdit<F extends Instance, T extends Instance>
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    F fi;
    T ti;
    int fromType;
    int toType;
    InstanceHolder<F> from;
    InstanceHolder<T> to;
    WordHolder wh;
    boolean executed = false;
    boolean undone = false;

    public MarkFInstanceAsTEdit(F fi, int toType) throws InvalidInstanceChangeException {
        this.fi = fi;
        this.wh = ((Instance)fi).getHolder();
        this.fromType = ((Instance)fi).getType();
        this.toType = toType;
        if (this.fromType == toType) {
            throw new InvalidInstanceChangeException("Can't mark instance as same type of instance.");
        }
        switch (this.fromType) {
            case 101: {
                this.from = this.wh.getAsVariant();
                break;
            }
            case 103: {
                this.from = this.wh.getAsCorrect();
                break;
            }
            case 102: {
                throw new InvalidInstanceChangeException("Can't mark replaced instance as something else. Use revert back instead.");
            }
            default: {
                throw new InvalidInstanceChangeException("From instance type not recognised.");
            }
        }
        switch (toType) {
            case 101: {
                this.to = this.wh.getAsVariant();
                this.ti = new VariantInstance((Instance)fi, this.wh.getAsVariant());
                break;
            }
            case 103: {
                this.to = this.wh.getAsCorrect();
                this.ti = new CorrectInstance((Instance)fi, this.wh.getAsCorrect());
                break;
            }
            case 102: {
                throw new InvalidInstanceChangeException("Can't mark instance as replaced, use replace instead.");
            }
            default: {
                throw new InvalidInstanceChangeException("To instance type not recognised.");
            }
        }
        Object p = fi;
        while ((p = ((Instance)p).getPreviousInstance()) != null && p != fi) {
            if (((Instance)p).getType() != toType) continue;
            this.ti = p;
            break;
        }
    }

    public void execute() throws InvalidInstanceChangeException {
        if (!this.executed) {
            if (this.from.removeInstance(this.fi)) {
                if (this.to.addInstance(this.ti)) {
                    this.executed = true;
                    return;
                }
                this.from.addInstance(this.fi);
            }
        } else {
            throw new InvalidInstanceChangeException("Can only execute once. " + this.fi + " to " + WordHolder.getTypeString(this.toType));
        }
        throw new InvalidInstanceChangeException(this.fi + " could not be marked as " + WordHolder.getTypeString(this.toType));
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.executed && this.to.removeInstance(this.ti)) {
            if (this.from.addInstance(this.fi)) {
                this.undone = true;
                return;
            }
            this.to.addInstance(this.ti);
        }
        throw new CannotUndoException();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.undone && this.from.removeInstance(this.fi)) {
            if (this.to.addInstance(this.ti)) {
                this.undone = false;
                return;
            }
            this.from.addInstance(this.fi);
        }
        throw new CannotRedoException();
    }

    @Override
    public boolean canUndo() {
        return this.executed;
    }

    @Override
    public boolean canRedo() {
        return this.undone;
    }

    @Override
    public String getPresentationName() {
        return "Mark instance as " + WordHolder.getTypeString(this.toType) + " (" + ((Instance)this.fi).getDisplayString() + ")";
    }

    public String getActionName() {
        return "Mark instance as " + WordHolder.getTypeString(this.toType);
    }

    public int getToType() {
        return this.toType;
    }

    public T getToInstance() {
        return this.ti;
    }
}

