/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import model.Globals;
import model.Setup;
import model.doc.DocumentXMLElement;
import model.doc.Instance;
import model.doc.TextReplacementHandler;

public class JoinInstance
extends DocumentXMLElement {
    private Collection<Instance> instancesHidden;
    private Collection<JoinInstance> joinInstancesHidden;
    private final String displayString;
    private final String originalDisplayText;
    private final String originalXMLText;
    private int startAtReplace = -1;

    public JoinInstance(Position start, Position end, String text, String displayText, String originalXMLText, String originalDisplayText) {
        super(start, end, text, true);
        this.displayString = displayText;
        this.originalDisplayText = this.replaceLineBreaksForMarkers(originalDisplayText, "[lb]");
        this.originalXMLText = originalXMLText;
        this.instancesHidden = null;
        this.joinInstancesHidden = null;
    }

    public JoinInstance(Position start, Position end, String text, String displayText, String originalDisplayText, LinkedHashMap<String, String> attributes, Setup setup) {
        super(start, end, text, attributes, setup);
        this.displayString = displayText;
        this.originalDisplayText = this.replaceLineBreaksForMarkers(originalDisplayText, setup.getJoinLineBreakMarker());
        this.originalXMLText = this.replaceLineBreakMarkersWithLineBreak(this.getAttributeValue(setup.getJoinOriginalAttribute()), setup.getJoinLineBreakMarker());
        this.instancesHidden = null;
        this.joinInstancesHidden = null;
    }

    @Override
    public boolean areRequiredAttributesPresent(Setup setup) {
        return this.isAttributePresent(setup.getJoinOriginalAttribute());
    }

    public void setupInText(TextReplacementHandler textReplacementHandler, Collection<JoinInstance> joinInstancesHidden) throws BadLocationException {
        this.joinInstancesHidden = joinInstancesHidden;
        this.instancesHidden = textReplacementHandler.removeInstances(this.getStart(), this.getEnd(), true);
        textReplacementHandler.removeIgnored(this.getStart(), this.getEnd());
        textReplacementHandler.replaceText(this.getStart(), this.getEnd(), this.getText(), true);
        textReplacementHandler.parseInstances(this.getStart(), this.getEnd());
        this.startAtReplace = this.getStartOffset();
    }

    public void revertInText(TextReplacementHandler textReplacementHandler) throws BadLocationException {
        textReplacementHandler.removeInstances(this.getStart(), this.getEnd(), false);
        textReplacementHandler.replaceText(this.getStart(), this.getEnd(), this.originalXMLText, true);
        textReplacementHandler.parseIgnored(this.getStart(), this.getEnd());
        int offset = 0;
        if (this.startAtReplace > -1) {
            offset = this.getStartOffset() - this.startAtReplace;
        }
        if (this.instancesHidden != null) {
            textReplacementHandler.restoreInstances(this.instancesHidden, offset);
        } else {
            textReplacementHandler.parseInstances(this.getStart(), this.getEnd());
        }
        if (this.joinInstancesHidden != null) {
            textReplacementHandler.restoreJoins(this.joinInstancesHidden, offset);
        }
    }

    public String getOriginalDisplayText() {
        return this.originalDisplayText;
    }

    @Override
    public String getDisplayString() {
        return this.displayString;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getOriginalDisplayText()) + " -> " + this.getDisplayString();
    }

    public String revertString() {
        return String.valueOf(this.getOriginalDisplayText()) + " <- " + this.getDisplayString();
    }

    private String replaceLineBreaksForMarkers(String text, String marker) {
        return text.replace("\n\r", marker).replace("\n", marker).replace("\r", marker);
    }

    private String replaceXMLElements(String text) {
        String replaced = text.replace("<", "&lt;");
        replaced = replaced.replace(">", "&gt;");
        replaced = replaced.replace("\"", "&quot;");
        return replaced;
    }

    private String replaceLineBreakMarkersWithLineBreak(String text, String marker) {
        return text.replace(marker, Globals.NEW_LINE);
    }

    @Override
    protected void updateAttributes(Setup setup) {
        super.updateAttributes(setup);
        this.setAttribute(setup.getJoinOriginalAttribute(), this.replaceXMLElements(this.replaceLineBreaksForMarkers(this.originalXMLText, setup.getJoinLineBreakMarker())));
    }

    @Override
    protected String getTag(Setup setup) {
        return setup.getJoinTag();
    }
}

