/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import model.Capitalisation;
import model.doc.DocumentElement;
import model.doc.HolderChangeListener;
import model.doc.Instance;
import model.doc.WordHolder;

public class InstanceHolder<E extends Instance>
implements Comparable<InstanceHolder<E>> {
    private final TreeSet<E> instances;
    private String word;
    private Capitalisation.CapType capitalisation;
    private int type;
    private final WordHolder wordHolder;
    private final HolderChangeListener holderChangeListener;

    InstanceHolder(String word, WordHolder wordHolder, HolderChangeListener holderChangeListener) {
        this.word = word;
        this.instances = new TreeSet();
        this.wordHolder = wordHolder;
        this.holderChangeListener = holderChangeListener;
    }

    public boolean contains(Instance instance) {
        if (instance == null) {
            return false;
        }
        return this.instances.contains(instance);
    }

    public Capitalisation.CapType getCapitalisation() {
        if (this.isEmpty()) {
            return Capitalisation.CapType.empty;
        }
        return this.capitalisation;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "0 instances error";
        }
        this.word = Capitalisation.changeWordToMatch(this.word, this.getCapitalisation());
        if (this.type == 102) {
            return String.valueOf(this.word) + " -> " + Capitalisation.changeWordToMatch(((Instance)this.instances.first()).getDisplayString(), this.getCapitalisation()) + " (" + this.instances.size() + ")";
        }
        return String.valueOf(this.word) + " (" + this.instances.size() + ")";
    }

    public String toRevertString() {
        if (this.isEmpty()) {
            return "0 instances error";
        }
        this.word = Capitalisation.changeWordToMatch(this.word, this.getCapitalisation());
        if (this.type == 102) {
            return String.valueOf(this.word) + " <- " + Capitalisation.changeWordToMatch(((Instance)this.instances.first()).getDisplayString(), this.getCapitalisation()) + " (" + this.instances.size() + ")";
        }
        return String.valueOf(this.word) + " (" + this.instances.size() + ")";
    }

    public String tabbedString() {
        if (this.isEmpty()) {
            return "";
        }
        this.word = Capitalisation.changeWordToMatch(this.word, this.getCapitalisation());
        if (this.type == 102) {
            return String.valueOf(this.word) + "\t" + Capitalisation.changeWordToMatch(((Instance)this.instances.first()).getDisplayString(), this.getCapitalisation()) + "\t" + this.instances.size();
        }
        return String.valueOf(this.word) + "\t" + this.instances.size();
    }

    boolean removeInstance(E toRemove) {
        this.holderChangeListener.instanceAboutToChange((Instance)toRemove, this.type);
        if (this.instances.remove(toRemove)) {
            if (this.instances.isEmpty()) {
                this.capitalisation = Capitalisation.getCapitalisation(null);
                this.holderChangeListener.holderEmptied(this, (Instance)toRemove, this.type);
            } else {
                this.capitalisation = ((Instance)this.instances.first()).capitalisation;
                for (Instance i : this.instances) {
                    if (i.capitalisation == this.capitalisation) continue;
                    this.capitalisation = Capitalisation.getCapitalisation(this.word.toLowerCase());
                    break;
                }
            }
            this.holderChangeListener.listChanged(this, this.type);
            return true;
        }
        return false;
    }

    boolean addInstance(E toAdd) {
        this.type = ((Instance)toAdd).getType();
        boolean fireFilled = false;
        if (this.instances.isEmpty()) {
            fireFilled = true;
        }
        if (this.instances.add(toAdd)) {
            if (fireFilled) {
                this.capitalisation = ((Instance)toAdd).capitalisation;
                this.holderChangeListener.holderFilled(this, (Instance)toAdd, this.type);
            } else if (this.capitalisation != ((Instance)toAdd).capitalisation) {
                this.capitalisation = Capitalisation.getCapitalisation(this.word.toLowerCase());
            }
            this.holderChangeListener.instanceChanged((Instance)toAdd, this.type);
            this.holderChangeListener.listChanged(this, this.type);
            return true;
        }
        return false;
    }

    TreeSet<E> getInstances() {
        return this.instances;
    }

    void emptyInstances() {
        if (!this.instances.isEmpty()) {
            this.capitalisation = Capitalisation.getCapitalisation(null);
            for (Instance instance : this.instances) {
                this.holderChangeListener.instanceAboutToChange(instance, this.type);
            }
            Instance lastRemoved = (Instance)this.instances.first();
            this.instances.clear();
            this.holderChangeListener.holderEmptied(this, lastRemoved, this.type);
            this.holderChangeListener.listChanged(this, this.type);
        }
    }

    boolean addInstances(Collection<E> newInstances) {
        if (!newInstances.isEmpty()) {
            this.type = ((Instance)newInstances.iterator().next()).getType();
            boolean fireFilled = false;
            if (this.instances.isEmpty()) {
                fireFilled = true;
            }
            if (this.instances.addAll(newInstances)) {
                Capitalisation.CapType newCap = this.capitalisation;
                for (Instance i : newInstances) {
                    if (newCap == i.capitalisation) continue;
                    newCap = Capitalisation.getCapitalisation(this.word.toLowerCase());
                    break;
                }
                this.capitalisation = newCap;
                if (fireFilled) {
                    this.holderChangeListener.holderFilled(this, (Instance)this.instances.last(), this.type);
                }
                for (Instance instance : newInstances) {
                    this.holderChangeListener.instanceChanged(instance, this.type);
                }
                this.holderChangeListener.listChanged(this, this.type);
                return true;
            }
        }
        return false;
    }

    void removeInstances(Collection<E> instancesToRemove) {
        if (!instancesToRemove.isEmpty()) {
            for (Instance instance : instancesToRemove) {
                this.holderChangeListener.instanceAboutToChange(instance, this.type);
            }
            Instance lastRemoved = (Instance)instancesToRemove.iterator().next();
            this.instances.removeAll(instancesToRemove);
            if (this.instances.isEmpty()) {
                this.capitalisation = Capitalisation.getCapitalisation(null);
                this.holderChangeListener.holderEmptied(this, lastRemoved, this.type);
            } else {
                this.capitalisation = ((Instance)this.instances.first()).capitalisation;
                for (Instance i : this.instances) {
                    if (i.capitalisation == this.capitalisation) continue;
                    this.capitalisation = Capitalisation.getCapitalisation(this.word.toLowerCase());
                    break;
                }
            }
            this.holderChangeListener.listChanged(this, this.type);
        }
    }

    @Override
    public int compareTo(InstanceHolder<E> ih) {
        if (this.instances.isEmpty()) {
            if (ih.instances.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (ih.instances.isEmpty()) {
            return 1;
        }
        return ((Instance)this.instances.first()).compareAlphabeticallyTo((DocumentElement)ih.instances.first());
    }

    public int compareToNonGeneric(InstanceHolder<? extends Instance> ih) {
        if (this.instances.isEmpty()) {
            if (ih.instances.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (ih.instances.isEmpty()) {
            return 1;
        }
        return ((Instance)this.instances.first()).compareAlphabeticallyTo((Instance)ih.instances.first());
    }

    public boolean isEmpty() {
        return this.instances.isEmpty();
    }

    public E getInstanceAtPos(int caretPos) {
        for (Instance i : this.instances) {
            if (i.containsPosition(caretPos)) {
                return (E)i;
            }
            if (i.getStartOffset() <= caretPos) continue;
            return null;
        }
        return null;
    }

    public void changeHighlights(Highlighter highlighter, Highlighter.HighlightPainter painter) throws BadLocationException {
        for (Instance instance : this.instances) {
            instance.changeHighlight(highlighter, painter);
        }
    }

    public void removeHighlights(Highlighter highlighter) {
        for (Instance instance : this.instances) {
            instance.removeHighlight(highlighter);
        }
    }

    public E firstInstance() {
        if (this.instances.isEmpty()) {
            return null;
        }
        return (E)((Instance)this.instances.first());
    }

    public E lastInstance() {
        if (this.instances.isEmpty()) {
            return null;
        }
        return (E)((Instance)this.instances.last());
    }

    public E nextInstance(Instance instance) {
        if (this.instances.isEmpty()) {
            return null;
        }
        if (instance == null) {
            return (E)((Instance)this.instances.first());
        }
        Instance nextInstance = this.instances.higher(instance);
        if (nextInstance == null) {
            nextInstance = (Instance)this.instances.first();
        }
        return (E)nextInstance;
    }

    public E previousInstance(Instance instance) {
        if (this.instances.isEmpty()) {
            return null;
        }
        if (instance == null) {
            return (E)((Instance)this.instances.last());
        }
        Instance prevInstance = this.instances.lower(instance);
        if (prevInstance == null) {
            prevInstance = (Instance)this.instances.last();
        }
        return (E)prevInstance;
    }

    public int getPosition(Instance instance) {
        if (instance == null) {
            return 0;
        }
        return this.instances.headSet(instance).size() + 1;
    }

    public int size() {
        return this.instances.size();
    }

    public int getType() {
        if (this.instances.isEmpty()) {
            return -1;
        }
        return this.type;
    }

    public WordHolder getWordHolder() {
        return this.wordHolder;
    }

    public int getInstancesSize() {
        return this.instances.size();
    }

    public static class AlphaComparator
    implements Comparator<InstanceHolder<? extends Instance>> {
        @Override
        public int compare(InstanceHolder<? extends Instance> ih1, InstanceHolder<? extends Instance> ih2) {
            int c = ((InstanceHolder)ih1).word.compareToIgnoreCase(((InstanceHolder)ih2).word);
            if (c == 0) {
                return ih1.compareToNonGeneric(ih2);
            }
            return c;
        }
    }

    public static class FreqComparator
    implements Comparator<InstanceHolder<? extends Instance>> {
        @Override
        public int compare(InstanceHolder<? extends Instance> ih1, InstanceHolder<? extends Instance> ih2) {
            int f = ih2.getInstancesSize() - ih1.getInstancesSize();
            if (f == 0) {
                int c = ((InstanceHolder)ih1).word.compareToIgnoreCase(((InstanceHolder)ih2).word);
                if (c == 0) {
                    return ih1.compareToNonGeneric(ih2);
                }
                return c;
            }
            return f;
        }
    }
}

