/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import model.Capitalisation;
import model.Setup;
import model.doc.DocumentXMLElement;
import model.doc.InstanceHolder;
import model.doc.WordHolder;

public abstract class Instance
extends DocumentXMLElement {
    protected final Capitalisation.CapType capitalisation;
    protected final WordHolder holder;
    protected Instance previousInstance;
    protected final InstanceHolder<? extends Instance> instanceHolder;
    protected final Map<String, String> entitiesContainedWithin;
    private final String displayString;

    protected Instance(Position start, Position end, String originalText, String displayText, Map<String, String> entitiesContainedWithin, WordHolder holder, InstanceHolder<? extends Instance> instanceHolder, boolean isXMLRequired) {
        super(start, end, originalText, isXMLRequired);
        this.displayString = displayText;
        this.entitiesContainedWithin = entitiesContainedWithin;
        if (holder == null) {
            throw new NullPointerException("WordHolder null");
        }
        if (instanceHolder == null) {
            throw new NullPointerException("InstanceHolder null");
        }
        this.holder = holder;
        this.instanceHolder = instanceHolder;
        this.capitalisation = Capitalisation.getCapitalisation(displayText);
        this.previousInstance = null;
    }

    protected Instance(Position start, Position end, String originalText, String displayText, Map<String, String> entitiesContainedWithin, LinkedHashMap<String, String> attributes, Setup setup, WordHolder holder, InstanceHolder<? extends Instance> instanceHolder) {
        super(start, end, originalText, attributes, setup);
        this.displayString = displayText;
        this.entitiesContainedWithin = entitiesContainedWithin;
        if (holder == null) {
            throw new NullPointerException("WordHolder null");
        }
        if (instanceHolder == null) {
            throw new NullPointerException("InstanceHolder null");
        }
        this.holder = holder;
        this.instanceHolder = instanceHolder;
        this.capitalisation = Capitalisation.getCapitalisation(displayText);
        this.previousInstance = null;
    }

    protected Instance(Instance oldInstance, InstanceHolder<? extends Instance> instanceHolder) {
        super(oldInstance.getStart(), oldInstance.getEnd(), oldInstance.getText(), true);
        this.displayString = oldInstance.getDisplayString();
        this.entitiesContainedWithin = oldInstance.entitiesContainedWithin;
        this.holder = oldInstance.getHolder();
        this.instanceHolder = instanceHolder;
        this.capitalisation = Capitalisation.getCapitalisation(this.getDisplayString());
        this.previousInstance = oldInstance;
    }

    protected Instance(Instance oldInstance, InstanceHolder<? extends Instance> instanceHolder, String originalText, String displayText, Map<String, String> entitiesContainedWithin) {
        super(oldInstance.getStart(), oldInstance.getEnd(), originalText, true);
        this.displayString = displayText;
        this.entitiesContainedWithin = entitiesContainedWithin;
        this.holder = oldInstance.getHolder();
        this.instanceHolder = instanceHolder;
        this.capitalisation = Capitalisation.getCapitalisation(this.getDisplayString());
        this.previousInstance = oldInstance;
    }

    public String analysisString() {
        return String.valueOf(this.getType()) + ": " + this.getDisplayString() + " (" + this.getStartOffset() + " - " + this.getEndOffset() + ")";
    }

    @Override
    public String toString() {
        return this.analysisString();
    }

    public abstract int getType();

    Instance getPreviousInstance() {
        return this.previousInstance;
    }

    public Capitalisation.CapType getCapitalisation() {
        return this.capitalisation;
    }

    public WordHolder getHolder() {
        return this.holder;
    }

    public abstract boolean removeSelfFromHolder();

    public abstract void addSelfToHolder();

    public InstanceHolder<? extends Instance> getInstanceHolder() {
        return this.instanceHolder;
    }

    @Override
    public boolean saveStart() {
        if (super.saveStart()) {
            if (this.previousInstance != null) {
                this.previousInstance.saveStart();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean restoreStart(StyledDocument doc, int offset) throws BadLocationException {
        if (super.restoreStart(doc, offset)) {
            if (this.previousInstance != null) {
                this.previousInstance.restoreStart(doc, offset);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean restoreStartAndEnd(StyledDocument doc, int offset) throws BadLocationException {
        if (super.restoreStartAndEnd(doc, offset)) {
            if (this.previousInstance != null) {
                this.previousInstance.restoreStartAndEnd(doc, offset);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayString() {
        return this.displayString;
    }

    public void setPreviousInstance(Instance previousInstance) {
        this.previousInstance = previousInstance;
    }
}

