/*
 * Decompiled with CFR 0.152.
 */
package model.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import model.ConfidenceWeights;
import model.Globals;
import model.IgnoreCaseComparator;
import model.MethodScores;
import model.MethodScoresUpdate;
import model.Setup;
import model.SuggestedReplacement;
import model.doc.CannotExecuteException;
import model.doc.DocumentElement;
import model.doc.DocumentElementList;
import model.doc.Entity;
import model.doc.ForeignText;
import model.doc.ForeignTextListener;
import model.doc.HolderChangeListener;
import model.doc.IgnorableText;
import model.doc.IgnorableTextListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.InstanceList;
import model.doc.InvalidInstanceChangeException;
import model.doc.JoinInstance;
import model.doc.PartitionElement;
import model.doc.TextReplacementHandler;
import model.doc.ThreadableEdit;
import model.doc.WordHolder;
import model.doc.XMLUtilities;
import model.lookup.LookUpDictionary;
import model.lookup.ReplacementWord;
import model.lookup.VariantReplacement;
import model.lookup.Word;
import model.sample.Partition;
import vardwrapper.NormalisationStats;

public class DocumentModel
implements HolderChangeListener,
TextReplacementHandler,
DocumentElementList.ListChangeListener {
    private static final Pattern XML_TAG_PATTERN = Pattern.compile("</?([^> ]+)(?: [^>]*)?>");
    private final List<DocumentChangeListener> documentChangeListeners;
    private FileType fileSavedType;
    private File fileLoaded;
    private File fileSaved;
    private boolean hasDocumentChanged;
    private Charset charset;
    private final TreeSet<WordHolder> words;
    private final TreeMap<Integer, TreeSet<InstanceHolder<? extends Instance>>> holderLists = new TreeMap();
    private final TreeMap<Integer, ArrayList<HolderChangeListener>> changeListeners = new TreeMap();
    private final List<HolderChangeListener> allTypesChangeListeners = new ArrayList<HolderChangeListener>();
    private final List<ForeignTextListener> foreignTextListeners;
    private final List<IgnorableTextListener> ignorableTextListeners;
    private StyledDocument doc;
    private Setup setup;
    private final ConfidenceWeights confidenceWeights;
    private final LookUpDictionary lud;
    private String[] shortCounts = new String[5];
    private static Globals global;
    private final InstanceList instances;
    private final DocumentElementList<JoinInstance> allJoins;
    private final DocumentElementList<IgnorableText> ignored;
    private final DocumentElementList<ForeignText> allForeign;
    private final DocumentElementList<Entity> entities;
    private final Collection<DocumentElementList<? extends DocumentElement>> elementLists;
    private final DocumentElementList<PartitionElement> partitionElements;
    private PartitionElement currentPartition;
    private final SortedSet<String> foreignLanguages;

    public DocumentModel(Setup setup, ConfidenceWeights confidenceWeights, LookUpDictionary lud) {
        global = Globals.getInstance();
        this.hasDocumentChanged = false;
        this.documentChangeListeners = new ArrayList<DocumentChangeListener>();
        this.setup = setup;
        this.confidenceWeights = confidenceWeights;
        this.lud = lud;
        this.words = new TreeSet();
        this.instances = new InstanceList();
        this.allJoins = new DocumentElementList();
        this.allForeign = new DocumentElementList();
        this.ignored = new DocumentElementList();
        this.entities = new DocumentElementList();
        this.partitionElements = new DocumentElementList();
        this.instances.addChangeListener(this);
        this.allJoins.addChangeListener(this);
        this.allForeign.addChangeListener(this);
        this.elementLists = new ArrayList<DocumentElementList<? extends DocumentElement>>();
        this.elementLists.add(this.instances);
        this.elementLists.add(this.allJoins);
        this.elementLists.add(this.ignored);
        this.elementLists.add(this.allForeign);
        this.elementLists.add(this.entities);
        this.elementLists.add(this.partitionElements);
        this.foreignTextListeners = new ArrayList<ForeignTextListener>();
        this.ignorableTextListeners = new ArrayList<IgnorableTextListener>();
        this.foreignLanguages = new TreeSet<String>(new IgnoreCaseComparator());
        int[] nArray = WordHolder.types;
        int n = WordHolder.types.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            this.holderLists.put(t, new TreeSet<InstanceHolder<? extends Instance>>(new InstanceHolder.AlphaComparator()));
            this.changeListeners.put(t, new ArrayList());
            ++n2;
        }
        this.addChangeListener(new HolderChangeListener(){

            @Override
            public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
            }

            @Override
            public void instanceAboutToChange(Instance instance, int type) {
                DocumentModel.this.instances.remove(instance.getStart());
            }

            @Override
            public void instanceChanged(Instance instance, int type) {
                DocumentModel.this.instances.put(instance.getStart(), instance);
            }

            @Override
            public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance i, int type) {
                ((TreeSet)DocumentModel.this.holderLists.get(type)).remove(holder);
            }

            @Override
            public void holderFilled(InstanceHolder<? extends Instance> holder, Instance i, int type) {
                ((TreeSet)DocumentModel.this.holderLists.get(type)).add(holder);
            }

            @Override
            public void suppressChanges() {
            }

            @Override
            public void unSuppressChanges() {
            }
        });
        this.addChangeListener(confidenceWeights, 102);
        this.newEmptyDocument();
    }

    public void addChangeListener(HolderChangeListener hcl) {
        this.allTypesChangeListeners.add(hcl);
    }

    public void addChangeListener(HolderChangeListener hcl, int type) {
        ArrayList<HolderChangeListener> hcls = this.changeListeners.get(type);
        if (hcls == null) {
            hcls = new ArrayList();
            this.changeListeners.put(type, hcls);
        }
        hcls.add(hcl);
    }

    public StyledDocument getDoc() {
        return this.doc;
    }

    private int getDocLength() {
        return this.doc.getLength();
    }

    public TreeSet<InstanceHolder<? extends Instance>> getHolderList(int type) {
        return this.holderLists.get(type);
    }

    public void openPartition(Partition partition) throws BadLocationException, InvalidInstanceChangeException, IOException {
        if (partition == null) {
            return;
        }
        global.lockFinishProgress();
        this.suppressChanges();
        try {
            this.clear();
            this.readFile(partition.getFile());
            this.currentPartition = this.parsePartitionTags(partition.getSequence());
            this.processCurrentPartition();
        }
        finally {
            this.unSuppressChanges();
            global.unlockFinishProgress();
            global.finishProgress();
        }
    }

    public void openPartition(File file, PartitionElement partitionElement) throws BadLocationException, InvalidInstanceChangeException, IOException {
        if (partitionElement == null) {
            return;
        }
        global.lockFinishProgress();
        this.suppressChanges();
        try {
            this.clear();
            this.readFile(file);
            this.currentPartition = partitionElement;
            this.processCurrentPartition();
        }
        finally {
            this.unSuppressChanges();
            global.unlockFinishProgress();
            global.finishProgress();
        }
    }

    private void processCurrentPartition() throws BadLocationException, InvalidInstanceChangeException, IOException {
        if (this.currentPartition != null) {
            this.currentPartition.setState(Partition.State.started);
            Position docStart = this.doc.createPosition(this.getStartOfDoc());
            IgnorableText before = new IgnorableText(docStart, this.currentPartition.getStart());
            this.ignored.put(docStart, before);
            this.fireIgnoreEvent(before);
            Position docEnd = this.doc.createPosition(this.getEndOfDoc());
            IgnorableText after = new IgnorableText(this.currentPartition.getEnd(), docEnd);
            this.ignored.put(this.currentPartition.getEnd(), after);
            this.fireIgnoreEvent(after);
            int partitionStart = this.currentPartition.getStartOffset();
            this.ignoreText(partitionStart, this.currentPartition.getEndOffset());
            this.parseXMLTags(partitionStart, this.currentPartition.getEndOffset(), false, false, false);
            this.parseSpecialEntities(partitionStart, this.currentPartition.getEndOffset());
            this.newReadWords(partitionStart, this.currentPartition.getEndOffset());
            this.saveWithTags(this.fileLoaded);
            this.fireDocumentChangedFromSavedEvent(false);
        } else {
            global.showError("Partition could not be opened.");
        }
    }

    public void processNewFile(File file) throws BadLocationException, InvalidInstanceChangeException {
        global.lockFinishProgress();
        this.suppressChanges();
        try {
            this.clear();
            this.readFile(file);
            this.parsePartitionTags(-1);
            this.ignoreText(this.getStartOfDoc(), this.getEndOfDoc());
            this.parseXMLTags(this.getStartOfDoc(), this.getEndOfDoc(), false, false, false);
            this.parseSpecialEntities(this.getStartOfDoc(), this.getEndOfDoc());
            this.newReadWords(this.getStartOfDoc(), this.getEndOfDoc());
            this.fireDocumentChangedFromSavedEvent(false);
        }
        finally {
            this.unSuppressChanges();
            global.unlockFinishProgress();
            global.finishProgress();
        }
    }

    public void trainFromFile(File file, boolean addXMLRepsToDictionary, boolean removeXMLOrigsFromDictionary, boolean removeXMLVariantsFromDictionary, boolean addXMLNotVariantsToDictionary) throws BadLocationException, InvalidInstanceChangeException {
        global.lockFinishProgress();
        this.suppressChanges();
        try {
            this.clear();
            this.readFile(file);
            this.parsePartitionTags(-1);
            this.ignoreText(this.getStartOfDoc(), this.getEndOfDoc());
            this.parseXMLTags(this.getStartOfDoc(), this.getEndOfDoc(), true, addXMLRepsToDictionary, removeXMLOrigsFromDictionary);
            if (removeXMLVariantsFromDictionary) {
                TreeSet<Instance> variants = this.getInstances(101);
                for (Instance instance : variants) {
                    String variant = instance.getDisplayString();
                    if (!this.lud.removeWord(variant)) continue;
                    this.lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + variant);
                }
            }
            if (addXMLNotVariantsToDictionary) {
                TreeSet<Instance> notVariants = this.getInstances(103);
                for (Instance instance : notVariants) {
                    String word = instance.getDisplayString();
                    if (this.lud.checkWords(word) != null) continue;
                    Word wordInDic = this.lud.addUserWord(word);
                    this.lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + wordInDic);
                }
            }
            this.fireDocumentChangedFromSavedEvent(false);
        }
        finally {
            this.unSuppressChanges();
            global.unlockFinishProgress();
            global.finishProgress();
        }
    }

    public void processNewText(String text, AttributeSet atts) throws BadLocationException, InvalidInstanceChangeException {
        global.lockFinishProgress();
        try {
            int start = this.insertText(text, atts);
            this.ignoreText(start, this.getEndOfDoc());
            this.parseXMLTags(start, this.getEndOfDoc(), false, false, false);
            this.parseSpecialEntities(start, this.getEndOfDoc());
            this.newReadWords(start, this.getEndOfDoc());
        }
        finally {
            global.unlockFinishProgress();
            global.finishProgress();
        }
    }

    public void processSpan(int start, int end) throws BadLocationException, InvalidInstanceChangeException {
        global.lockFinishProgress();
        try {
            this.ignoreText(start, end);
            this.parseXMLTags(start, end, false, false, false);
            this.parseSpecialEntities(start, end);
            this.newReadWords(start, end);
        }
        finally {
            global.unlockFinishProgress();
            global.finishProgress();
        }
    }

    public void newEmptyDocument() {
        this.clear();
        this.fileLoaded = null;
        this.fireFileChangedEvent();
    }

    private void clear() {
        this.fileSaved = null;
        this.doc = new DefaultStyledDocument();
        this.words.clear();
        this.instances.clear();
        this.entities.clear();
        this.partitionElements.clear();
        this.ignored.clear();
        this.allForeign.clear();
        this.allJoins.clear();
        this.currentPartition = null;
        this.setForeignLanguages(this.setup.getLanguages());
        for (TreeSet<InstanceHolder<? extends Instance>> ts : this.holderLists.values()) {
            ts.clear();
        }
        this.charset = this.setup.getEncoding().equals("detect") ? Charset.defaultCharset() : Charset.forName(this.setup.getEncoding());
        this.fireClearedEvent();
        this.fireDocumentChangedFromSavedEvent(false);
    }

    private WordHolder getReferenceTo(String word) {
        WordHolder newWH = new WordHolder(word, this);
        if (!this.words.add(newWH)) {
            return this.words.floor(newWH);
        }
        newWH.setDictionaryRef(this.lud.checkWords(word));
        return newWH;
    }

    public SortedSet<String> getForeignLanguages() {
        return this.foreignLanguages;
    }

    private void setForeignLanguages(Collection<String> langs) {
        this.foreignLanguages.clear();
        for (String lang : langs) {
            this.foreignLanguages.add(lang);
        }
    }

    private void addForeignLanguage(String lang) {
        this.foreignLanguages.add(lang);
    }

    private void addForeign(ForeignText foreignText) {
        this.allForeign.put(foreignText.getStart(), foreignText);
        this.addForeignLanguage(foreignText.getLanguage());
        if (!this.setup.isLanguageToProcess(foreignText.getLanguage())) {
            this.displayForeignAsNotAllowedLanguage(foreignText);
        }
    }

    private void removeForeign(ForeignText foreignText) throws BadLocationException, InvalidInstanceChangeException {
        this.allForeign.remove(foreignText.getStart());
        this.removeForeignDisplayAsNotAllowedLanguage(foreignText);
    }

    private void displayForeignAsNotAllowedLanguage(ForeignText foreignText) {
        Collection<Instance> instancesHidden = this.removeInstances(foreignText.getStart(), foreignText.getEnd(), false);
        Collection<JoinInstance> joinInstancesHidden = this.removeJoins(foreignText.getStart(), foreignText.getEnd(), false);
        this.removeIgnored(foreignText.getStart(), foreignText.getEnd());
        foreignText.setHiddenInstances(instancesHidden, joinInstancesHidden);
        for (ForeignTextListener ftl : this.foreignTextListeners) {
            ftl.showAsForeign(foreignText);
        }
    }

    private void removeForeignDisplayAsNotAllowedLanguage(ForeignText foreignText) throws BadLocationException, InvalidInstanceChangeException {
        for (ForeignTextListener ftl : this.foreignTextListeners) {
            ftl.ignoreThatForeign(foreignText);
        }
        if (foreignText.getInstancesHidden() != null) {
            this.restoreInstances(foreignText.getInstancesHidden());
        }
        if (foreignText.getJoinInstancesHidden() != null) {
            this.restoreJoins(foreignText.getJoinInstancesHidden());
        }
        this.processSpan(foreignText.getStartOffset(), foreignText.getEndOffset());
    }

    public void addForeignTextListener(ForeignTextListener ftl) {
        this.foreignTextListeners.add(ftl);
    }

    public void removeForeignTextListener(ForeignTextListener ftl) {
        this.foreignTextListeners.remove(ftl);
    }

    public RemoveForeignEdit getRemoveForeignEdit(Position startPos, Position endPos) {
        return new RemoveForeignEdit(startPos, endPos);
    }

    public RemoveForeignEdit getRemoveForeignEdit(int start, int end) throws BadLocationException {
        return new RemoveForeignEdit(this.doc.createPosition(start), this.doc.createPosition(end));
    }

    public RemoveForeignEdit getRemoveForeignEdit(ForeignText foreignText) {
        return new RemoveForeignEdit(foreignText.getStart(), foreignText.getEnd());
    }

    public MarkSpanAsForeignEdit getMarkAsForeignEdit(int start, int end, String lang) throws BadLocationException {
        return new MarkSpanAsForeignEdit(this.doc.createPosition(start), this.doc.createPosition(end), lang);
    }

    public ChangeForeignTextLanguageEdit getChangeForeignTextLanguageEdit(ForeignText foreignText, String newLang) {
        return new ChangeForeignTextLanguageEdit(foreignText, newLang);
    }

    public JoinEdit getJoinEdit(int start, int end) throws BadLocationException {
        return new JoinEdit(start, end, this);
    }

    private boolean parseSpecialEntities(int start, int end) throws BadLocationException {
        Position emStartPos;
        int emEnd;
        int emStart;
        if (end - start < 1) {
            return false;
        }
        if (end > this.getEndOfDoc()) {
            end = this.getEndOfDoc();
        }
        int offset = 0;
        boolean entityFound = false;
        for (Map.Entry<String, String> entityMapping : this.setup.getEntities().entrySet()) {
            offset = 0;
            Pattern emPattern = Pattern.compile(entityMapping.getKey());
            Matcher emMatcher = emPattern.matcher(this.doc.getText(start, (end -= offset) - start));
            String entityReplacement = entityMapping.getValue();
            while (emMatcher.find()) {
                emStart = start + emMatcher.start() - offset;
                emEnd = start + emMatcher.end() - offset;
                emStartPos = this.doc.createPosition(emStart);
                if (this.entities.isThereAnElementAt(emStartPos) || this.ignored.isThereAnElementAt(emStartPos)) continue;
                this.replaceText(this.doc.createPosition(emStart), this.doc.createPosition(emEnd), entityReplacement, false);
                offset += emEnd - emStart - entityReplacement.length();
                Position entityStartPos = this.doc.createPosition(emStart);
                Position entityEndPos = this.doc.createPosition(emStart + entityReplacement.length());
                Entity previousEntity = this.entities.getPreviousElement(entityStartPos);
                if (previousEntity != null && previousEntity.getEndOffset() >= emStart) {
                    previousEntity.restoreEnd(this.doc);
                }
                this.entities.put(entityStartPos, new Entity(entityStartPos, entityEndPos, emMatcher.group(), entityReplacement));
                entityFound = true;
            }
        }
        Pattern entityPattern = Pattern.compile("&#?(x?)([a-fA-F0-9]+);");
        Matcher entityMatcher = entityPattern.matcher(this.doc.getText(start, (end -= offset) - start));
        offset = 0;
        while (entityMatcher.find()) {
            char c;
            String x = entityMatcher.group(1);
            String entity = entityMatcher.group(2);
            String wholeEntity = entityMatcher.group();
            emStart = start + entityMatcher.start() - offset;
            emEnd = start + entityMatcher.end() - offset;
            emStartPos = this.doc.createPosition(emStart);
            if (this.entities.isThereAnElementAt(emStartPos) || this.ignored.isThereAnElementAt(emStartPos)) continue;
            String entityRep = "";
            if (x.isEmpty() && entity.matches("[0-9]+")) {
                int dec = Integer.parseInt(entity);
                c = (char)dec;
                entityRep = String.valueOf(entityRep) + c;
            } else {
                int hex = Integer.parseInt(entity, 16);
                c = (char)hex;
                entityRep = String.valueOf(entityRep) + c;
            }
            this.replaceText(this.doc.createPosition(emStart), this.doc.createPosition(emEnd), entityRep, false);
            offset += emEnd - emStart - entityRep.length();
            Position entityStartPos = this.doc.createPosition(emStart);
            Position entityEndPos = this.doc.createPosition(emStart + entityRep.length());
            Entity previousEntity = this.entities.getPreviousElement(entityStartPos);
            if (previousEntity != null && previousEntity.getEndOffset() >= emStart) {
                previousEntity.restoreEnd(this.doc);
            }
            this.entities.put(entityStartPos, new Entity(entityStartPos, entityEndPos, wholeEntity, entityRep));
            entityFound = true;
        }
        return entityFound;
    }

    private String getTextWithRevertedEntities(Position start, Position end) throws BadLocationException {
        int startInt = start.getOffset();
        String revertedText = this.doc.getText(startInt, end.getOffset() - startInt);
        List<Entity> entitiesFound = this.entities.getElementsInSpan(start, end);
        int offset = 0;
        for (Entity entity : entitiesFound) {
            int pos = entity.getStartOffset() - startInt + offset;
            String current = entity.getReplacement();
            String reverted = entity.getText();
            revertedText = String.valueOf(revertedText.substring(0, pos)) + reverted + revertedText.substring(pos + current.length());
            offset += reverted.length() - current.length();
        }
        return revertedText;
    }

    private static Pattern getXMLTagPattern(String tag, boolean dotall) {
        if (dotall) {
            return Pattern.compile("<" + tag + "([^>]*)>(.+?)</" + tag + ">", 32);
        }
        return Pattern.compile("<" + tag + "([^>]*)>(.+?)</" + tag + ">");
    }

    private void ignoreText(int start, int end) throws BadLocationException {
        try {
            global.startProgress(end - start);
            global.writeProgressMessage("Ignoring text which should be ignored...");
            for (Pattern ignorePattern : this.setup.getIgnoredPatterns()) {
                Matcher ignoreMatcher = ignorePattern.matcher(this.doc.getText(start, end - start));
                while (ignoreMatcher.find()) {
                    String tag;
                    String match = ignoreMatcher.group();
                    Matcher xmlMatcher = XML_TAG_PATTERN.matcher(match);
                    if (xmlMatcher.matches() && this.setup.isVARDXMLTag(tag = xmlMatcher.group(1))) continue;
                    int ignoreStart = start + ignoreMatcher.start();
                    int ignoreEnd = start + ignoreMatcher.end();
                    Position startPos = this.doc.createPosition(ignoreStart);
                    if (!this.ignored.isThereAnElementAt(startPos) && !this.isForeignAndNotAllowedLanguage(startPos)) {
                        IgnorableText toIgnore = new IgnorableText(startPos, this.doc.createPosition(ignoreEnd));
                        this.ignored.put(this.doc.createPosition(ignoreStart), toIgnore);
                        this.fireIgnoreEvent(toIgnore);
                    }
                    global.setProgressCurrent(ignoreEnd);
                }
            }
        }
        finally {
            global.finishProgress();
        }
    }

    private void parseXMLTags(int start, int end, boolean trainFromXML, boolean addXMLRepsToDictionary, boolean removeXMLOrigsFromDictionary) throws BadLocationException, InvalidInstanceChangeException {
        if (end - start < 1) {
            return;
        }
        try {
            global.startProgress(end - start);
            global.writeProgressMessage("Reading " + this.setup.getVariantTag() + " xml tags...");
            int offset = 0;
            Pattern variantPattern = DocumentModel.getXMLTagPattern(this.setup.getVariantTag(), false);
            Matcher variantMatcher = variantPattern.matcher(this.doc.getText(start, end - start));
            while (variantMatcher.find()) {
                int tagStart = start + variantMatcher.start() - offset;
                Position startPos = this.doc.createPosition(tagStart);
                if (this.ignored.isThereAnElementAt(startPos) || this.isForeignAndNotAllowedLanguage(startPos)) continue;
                int tagEnd = start + variantMatcher.end() - offset;
                String attributesString = variantMatcher.group(1);
                String variant = variantMatcher.group(2);
                int variantStart = start + variantMatcher.start(2) - offset;
                int variantEnd = start + variantMatcher.end(2) - offset;
                int firstRemoveLength = variantStart - tagStart;
                int secondRemoveLength = (tagEnd -= firstRemoveLength) - (variantEnd -= firstRemoveLength);
                this.doc.remove(tagStart, firstRemoveLength);
                this.doc.remove(variantEnd, secondRemoveLength);
                offset += firstRemoveLength + secondRemoveLength;
                WordHolder wh = this.getReferenceTo(variant);
                Position endPos = this.doc.createPosition(variantEnd);
                String variantDisplay = variant;
                HashMap<String, String> entitiesContainedWithin = new HashMap<String, String>(2);
                if (this.parseSpecialEntities(tagStart, variantEnd)) {
                    int endInt = endPos.getOffset();
                    startPos = this.doc.createPosition(tagStart);
                    variantDisplay = this.doc.getText(tagStart, endInt - tagStart);
                    offset += variant.length() - variantDisplay.length();
                    List<Entity> entitiesFound = this.entities.getElementsInSpan(startPos, endPos);
                    for (Entity entity : entitiesFound) {
                        entitiesContainedWithin.put(entity.getReplacement(), entity.getText());
                    }
                }
                wh.addVariant(startPos, endPos, variant, variantDisplay, entitiesContainedWithin, XMLUtilities.getAttributes(attributesString), this.setup);
                global.setProgressCurrent(tagEnd - start + offset);
            }
            global.startProgress((end -= offset) - start);
            global.writeProgressMessage("Reading " + this.setup.getNotvariantTag() + " xml tags...");
            offset = 0;
            Pattern notvariantPattern = DocumentModel.getXMLTagPattern(this.setup.getNotvariantTag(), false);
            Matcher notvariantMatcher = notvariantPattern.matcher(this.doc.getText(start, end - start));
            while (notvariantMatcher.find()) {
                int tagStart = start + notvariantMatcher.start() - offset;
                Position startPos = this.doc.createPosition(tagStart);
                if (this.ignored.isThereAnElementAt(startPos) || this.isForeignAndNotAllowedLanguage(startPos)) continue;
                int tagEnd = start + notvariantMatcher.end() - offset;
                String attributesString = notvariantMatcher.group(1);
                String word = notvariantMatcher.group(2);
                int wordStart = start + notvariantMatcher.start(2) - offset;
                int wordEnd = start + notvariantMatcher.end(2) - offset;
                int firstRemoveLength = wordStart - tagStart;
                int secondRemoveLength = (tagEnd -= firstRemoveLength) - (wordEnd -= firstRemoveLength);
                this.doc.remove(tagStart, firstRemoveLength);
                this.doc.remove(wordEnd, secondRemoveLength);
                offset += firstRemoveLength + secondRemoveLength;
                Position endPos = this.doc.createPosition(wordEnd);
                String wordDisplay = word;
                HashMap<String, String> entitiesContainedWithin = new HashMap<String, String>(2);
                if (this.parseSpecialEntities(tagStart, wordEnd)) {
                    int endInt = endPos.getOffset();
                    startPos = this.doc.createPosition(tagStart);
                    wordDisplay = this.doc.getText(tagStart, endInt - tagStart);
                    offset += word.length() - wordDisplay.length();
                    List<Entity> entitiesFound = this.entities.getElementsInSpan(startPos, endPos);
                    for (Entity entity : entitiesFound) {
                        entitiesContainedWithin.put(entity.getReplacement(), entity.getText());
                    }
                }
                WordHolder wh = this.getReferenceTo(word);
                wh.addCorrect(startPos, endPos, word, wordDisplay, entitiesContainedWithin, XMLUtilities.getAttributes(attributesString), this.setup);
                global.setProgressCurrent(tagEnd - start + offset);
            }
            global.startProgress((end -= offset) - start);
            global.writeProgressMessage("Reading <normalised> xml tags...");
            offset = 0;
            Pattern normalisedPattern = DocumentModel.getXMLTagPattern(this.setup.getNormalisedTag(), false);
            Matcher normalisedMatcher = normalisedPattern.matcher(this.doc.getText(start, end - start));
            this.confidenceWeights.setUpdate(trainFromXML);
            while (normalisedMatcher.find()) {
                ReplacementWord replacementWord;
                VariantReplacement newVR;
                int tagStart = start + normalisedMatcher.start() - offset;
                Position startPos = this.doc.createPosition(tagStart);
                if (this.ignored.isThereAnElementAt(startPos) || this.isForeignAndNotAllowedLanguage(startPos)) continue;
                String attributesString = normalisedMatcher.group(1);
                LinkedHashMap<String, String> attributes = XMLUtilities.getAttributes(attributesString);
                String normalisedOriginalXMLText = attributes.get(this.setup.getNormalisedOriginalAttribute());
                if (normalisedOriginalXMLText == null) {
                    global.showError(String.valueOf(normalisedMatcher.group()) + " does not contain " + this.setup.getNormalisedOriginalAttribute() + " attribute.");
                    continue;
                }
                HashMap<String, String> originalEntitiesContainedWithin = new HashMap<String, String>();
                String normalisedOriginalDisplayText = this.getTextWithReplacedEntities(normalisedOriginalXMLText, originalEntitiesContainedWithin);
                String autoString = attributes.get(this.setup.getNormalisedAutoAttribute());
                boolean auto = autoString == null ? false : Boolean.parseBoolean(autoString);
                String replacement = normalisedMatcher.group(2);
                int tagEnd = start + normalisedMatcher.end() - offset;
                int replacementStart = start + normalisedMatcher.start(2) - offset;
                int replacementEnd = start + normalisedMatcher.end(2) - offset;
                int firstRemoveLength = replacementStart - tagStart;
                int secondRemoveLength = (tagEnd -= firstRemoveLength) - (replacementEnd -= firstRemoveLength);
                this.doc.remove(tagStart, firstRemoveLength);
                this.doc.remove(replacementEnd, secondRemoveLength);
                offset += firstRemoveLength + secondRemoveLength;
                Position endPos = this.doc.createPosition(replacementEnd);
                String replacementDisplay = replacement;
                HashMap<String, String> entitiesContainedWithin = new HashMap<String, String>(2);
                if (this.parseSpecialEntities(tagStart, replacementEnd)) {
                    int endInt = endPos.getOffset();
                    startPos = this.doc.createPosition(tagStart);
                    replacementDisplay = this.doc.getText(tagStart, endInt - tagStart);
                    offset += replacement.length() - replacementDisplay.length();
                    List<Entity> entitiesFound = this.entities.getElementsInSpan(startPos, endPos);
                    for (Entity entity : entitiesFound) {
                        entitiesContainedWithin.put(entity.getReplacement(), entity.getText());
                    }
                }
                boolean wordNotInDic = false;
                Word wordInDic = this.lud.checkWords(replacementDisplay);
                if (wordInDic == null) {
                    wordNotInDic = true;
                    wordInDic = new Word(replacementDisplay, null, true, 1);
                }
                SuggestedReplacement rep = null;
                String variant = normalisedOriginalDisplayText;
                List<SuggestedReplacement> reps = this.lud.findReplacements(variant, 0, this.confidenceWeights);
                if (wordNotInDic && trainFromXML && addXMLRepsToDictionary && !auto) {
                    wordInDic = this.lud.addUserWord(replacementDisplay);
                    this.lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + wordInDic);
                }
                if (trainFromXML && removeXMLOrigsFromDictionary && !auto && this.lud.removeWord(variant)) {
                    this.lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + variant);
                }
                for (SuggestedReplacement r : reps) {
                    if (!r.getReplacementStringWithoutChangingCapitalisation().equalsIgnoreCase(wordInDic.getWord())) continue;
                    rep = r;
                    rep.setReplacementString(replacementDisplay);
                    break;
                }
                if (rep == null) {
                    rep = new SuggestedReplacement(variant, replacementDisplay, wordInDic.getFreq(), wordInDic.isUserAdded());
                    if (reps.size() != 0) {
                        SuggestedReplacement first = (SuggestedReplacement)reps.iterator().next();
                        for (Map.Entry<String, Object> entry : first.getMethodScoresUpdates().entrySet()) {
                            MethodScores origUpdate = ((MethodScoresUpdate)entry.getValue()).getUpdate();
                            MethodScores newUpdate = new MethodScores(0.0, origUpdate.fp() + origUpdate.tp());
                            rep.setScoreUpdate(entry.getKey(), new MethodScoresUpdate(((MethodScoresUpdate)entry.getValue()).getToUpdate(), newUpdate));
                        }
                    } else {
                        Set<Map.Entry<String, MethodScores>> cwMSs = this.confidenceWeights.getScores().entrySet();
                        for (Map.Entry<String, Object> entry : cwMSs) {
                            rep.setScoreUpdate(entry.getKey(), new MethodScoresUpdate((MethodScores)entry.getValue(), new MethodScores(0.0, 0.0)));
                        }
                    }
                    rep.reCalculateScore(this.confidenceWeights);
                }
                if (trainFromXML && (newVR = this.lud.addUserVariant(rep.getOriginal(), rep.getReplacementStringWithoutChangingCapitalisation())) != null && (replacementWord = newVR.getReplacement()) != null) {
                    rep.setReplacementWord("KV", newVR.getReplacement());
                }
                WordHolder wh = this.getReferenceTo(normalisedOriginalDisplayText);
                wh.addReplaced(startPos, endPos, replacement, replacementDisplay, entitiesContainedWithin, normalisedOriginalDisplayText, originalEntitiesContainedWithin, attributes, this.setup, rep);
                global.setProgressCurrent(tagEnd - start + offset);
            }
            this.confidenceWeights.setUpdateToDefault();
            global.startProgress((end -= offset) - start);
            global.writeProgressMessage("Dealing with <join> xml tags...");
            offset = 0;
            Pattern joinPattern = DocumentModel.getXMLTagPattern(this.setup.getJoinTag(), false);
            Matcher joinMatcher = joinPattern.matcher(this.doc.getText(start, end - start));
            while (joinMatcher.find()) {
                int tagStart = start + joinMatcher.start() - offset;
                Position startPos = this.doc.createPosition(tagStart);
                if (this.ignored.isThereAnElementAt(startPos) || this.isForeignAndNotAllowedLanguage(startPos)) continue;
                String attributesString = joinMatcher.group(1);
                LinkedHashMap<String, String> attributes = XMLUtilities.getAttributes(attributesString);
                String originalXMLText = attributes.get(this.setup.getJoinOriginalAttribute());
                if (originalXMLText == null) {
                    global.showError(String.valueOf(joinMatcher.group()) + " does not contain " + this.setup.getJoinOriginalAttribute() + " attribute.");
                    continue;
                }
                String originalDisplayText = this.getTextWithReplacedEntities(originalXMLText, new HashMap<String, String>(2));
                int tagEnd = start + joinMatcher.end() - offset;
                String text = joinMatcher.group(2);
                int textStart = start + joinMatcher.start(2) - offset;
                int textEnd = start + joinMatcher.end(2) - offset;
                int firstRemoveLength = textStart - tagStart;
                int secondRemoveLength = (tagEnd -= firstRemoveLength) - (textEnd -= firstRemoveLength);
                this.doc.remove(tagStart, firstRemoveLength);
                this.doc.remove(textEnd, secondRemoveLength);
                offset += firstRemoveLength + secondRemoveLength;
                Position endPos = this.doc.createPosition(textEnd);
                String textDisplay = text;
                if (this.parseSpecialEntities(tagStart, textEnd)) {
                    int endInt = endPos.getOffset();
                    startPos = this.doc.createPosition(tagStart);
                    textDisplay = this.doc.getText(tagStart, endInt - tagStart);
                    offset += text.length() - textDisplay.length();
                }
                JoinInstance joinInstance = new JoinInstance(startPos, endPos, text, textDisplay, originalDisplayText, attributes, this.setup);
                this.allJoins.put(this.doc.createPosition(tagStart), joinInstance);
                global.setProgressCurrent(tagEnd - start + offset);
            }
            global.startProgress((end -= offset) - start);
            global.writeProgressMessage("Dealing with marked-up foreign text...");
            offset = 0;
            Pattern foreignPattern = DocumentModel.getXMLTagPattern(this.setup.getForeignTag(), true);
            Matcher foreignMatcher = foreignPattern.matcher(this.doc.getText(start, end - start));
            while (foreignMatcher.find()) {
                int tagStart = start + foreignMatcher.start() - offset;
                Position startPos = this.doc.createPosition(tagStart);
                if (this.ignored.isThereAnElementAt(startPos)) continue;
                int tagEnd = start + foreignMatcher.end() - offset;
                int textStart = start + foreignMatcher.start(2) - offset;
                int textEnd = start + foreignMatcher.end(2) - offset;
                String attributesString = foreignMatcher.group(1);
                int firstRemoveLength = textStart - tagStart;
                int secondRemoveLength = (tagEnd -= firstRemoveLength) - (textEnd -= firstRemoveLength);
                this.doc.remove(tagStart, firstRemoveLength);
                this.doc.remove(textEnd, secondRemoveLength);
                offset += firstRemoveLength + secondRemoveLength;
                LinkedHashMap<String, String> attributes = XMLUtilities.getAttributes(attributesString);
                if (attributes.containsKey(this.setup.getForeignLanguageAttribute())) {
                    ForeignText foreign = new ForeignText(this.doc.createPosition(tagStart), this.doc.createPosition(textEnd), attributes, this.setup);
                    this.addForeign(foreign);
                }
                global.setProgressCurrent(tagEnd);
            }
        }
        finally {
            global.finishProgress();
        }
    }

    private PartitionElement parsePartitionTags(int seqToProcess) throws BadLocationException {
        PartitionElement partitionToProcess = null;
        int start = this.getStartOfDoc();
        int end = this.getEndOfDoc();
        if (end - start < 1) {
            return null;
        }
        try {
            global.startProgress(end - start);
            global.writeProgressMessage("Dealing with marked-up partitions...");
            int offset = 0;
            Pattern partitionPattern = DocumentModel.getXMLTagPattern(this.setup.getPartitionTag(), true);
            Matcher partitionMatcher = partitionPattern.matcher(this.doc.getText(start, end - start));
            while (partitionMatcher.find()) {
                int tagStart = start + partitionMatcher.start() - offset;
                int tagEnd = start + partitionMatcher.end() - offset;
                int textStart = start + partitionMatcher.start(2) - offset;
                int textEnd = start + partitionMatcher.end(2) - offset;
                String attributesString = partitionMatcher.group(1);
                int firstRemoveLength = textStart - tagStart;
                int secondRemoveLength = (tagEnd -= firstRemoveLength) - (textEnd -= firstRemoveLength);
                this.doc.remove(tagStart, firstRemoveLength);
                this.doc.remove(textEnd, secondRemoveLength);
                offset += firstRemoveLength + secondRemoveLength;
                Position startPos = this.doc.createPosition(tagStart);
                Position endPos = this.doc.createPosition(textEnd);
                LinkedHashMap<String, String> attributes = XMLUtilities.getAttributes(attributesString);
                PartitionElement partition = new PartitionElement(startPos, endPos, attributes, this.setup);
                this.partitionElements.put(partition.getStart(), partition);
                if (seqToProcess > 0 && seqToProcess == partition.getSequence()) {
                    partitionToProcess = partition;
                }
                global.setProgressCurrent(tagEnd);
            }
        }
        finally {
            global.finishProgress();
        }
        return partitionToProcess;
    }

    private void newReadWords(int start, int end) throws BadLocationException {
        if (end - start < 1) {
            return;
        }
        if (end > this.getEndOfDoc()) {
            end = this.getEndOfDoc();
        }
        global.startProgress(end - start);
        global.writeProgressMessage("Evaluating words...");
        try {
            String text = this.doc.getText(start, end - start);
            Pattern wordPattern = this.setup.getWordPattern();
            Matcher wordMatcher = wordPattern.matcher(text);
            int textLength = text.length();
            while (wordMatcher.find()) {
                int wmStart = wordMatcher.start();
                int wordStart = start + wmStart;
                Position startPos = this.doc.createPosition(wordStart);
                if (this.ignored.isThereAnElementAt(startPos) || this.isForeignAndNotAllowedLanguage(startPos) || this.instances.isThereAnElementAt(startPos)) continue;
                global.setProgressCurrent(wmStart);
                int wmEnd = wordMatcher.end();
                String currentWordString = wordMatcher.group();
                char charBefore = 'S';
                if (wmStart > 0) {
                    charBefore = text.charAt(wmStart - 1);
                }
                char charAfter = 'E';
                if (wmEnd < textLength) {
                    charAfter = text.charAt(wmEnd);
                }
                if (!this.isValidWord(currentWordString) || Character.isDigit(charBefore) || Character.isDigit(charAfter)) continue;
                WordHolder wh = this.getReferenceTo(currentWordString);
                int wordEnd = wordStart + currentWordString.length();
                Position endPos = this.doc.createPosition(wordEnd);
                String originalText = this.getTextWithRevertedEntities(startPos, endPos);
                HashMap<String, String> entitiesContainedWithin = new HashMap<String, String>(2);
                List<Entity> entitiesInText = this.entities.getElementsInSpan(startPos, endPos);
                for (Entity entity : entitiesInText) {
                    entitiesContainedWithin.put(entity.getReplacement(), entity.getText());
                }
                boolean override = false;
                Collection<Pattern> nonvariantPatterns = this.setup.getNonvariantOverridePatterns();
                for (Pattern pattern : nonvariantPatterns) {
                    if (!pattern.matcher(currentWordString).matches()) continue;
                    wh.addCorrect(startPos, endPos, originalText, currentWordString, entitiesContainedWithin);
                    override = true;
                    break;
                }
                if (!override) {
                    Collection<Pattern> variantPatterns = this.setup.getVariantOverridePatterns();
                    for (Pattern pattern : variantPatterns) {
                        if (!pattern.matcher(currentWordString).matches()) continue;
                        wh.addVariant(startPos, endPos, originalText, currentWordString, entitiesContainedWithin);
                        override = true;
                        break;
                    }
                }
                if (override) continue;
                if (wh.isInDictionary()) {
                    wh.addCorrect(startPos, endPos, originalText, currentWordString, entitiesContainedWithin);
                    continue;
                }
                wh.addVariant(startPos, endPos, originalText, currentWordString, entitiesContainedWithin);
            }
        }
        finally {
            global.finishProgress();
        }
    }

    private boolean isForeignAndNotAllowedLanguage(Position pos) {
        ForeignText ft = this.allForeign.getElementAt(pos);
        if (ft != null) {
            return !this.setup.isLanguageToProcess(ft.getLanguage());
        }
        return false;
    }

    private int insertText(String text, AttributeSet textStyle) throws BadLocationException {
        if (text.length() < 1) {
            return this.getEndOfDoc();
        }
        try {
            if (this.doc.getLength() > 0) {
                this.doc.insertString(this.getEndOfDoc() + 1, "\n\n", null);
            } else {
                this.doc.insertString(0, "\n", null);
            }
            int start = this.getEndOfDoc();
            this.doc.insertString(start, text, textStyle);
            return start;
        }
        catch (BadLocationException e) {
            global.showException("Error occurred inserting text.", e);
            return this.getEndOfDoc();
        }
    }

    private boolean isValidWord(String word) {
        return !word.contains("--") && !word.equals("-");
    }

    public AddWordToDictionaryEdit getAddWordToDictionaryEdit(WordHolder wh, String word) {
        return new AddWordToDictionaryEdit(wh, word);
    }

    public RemoveWordFromDictionaryEdit getRemoveWordFromDictionaryEdit(WordHolder wh, String word) {
        return new RemoveWordFromDictionaryEdit(wh, word);
    }

    private void removeAndRevertEntities(Position start, Position end) throws BadLocationException {
        List<Entity> entitiesInRange = this.entities.getElementsInSpan(start, end);
        for (Entity entity : entitiesInRange) {
            entity.revertInText(this);
            this.entities.remove(entity.getStart());
        }
    }

    public void removeEntities() throws BadLocationException {
        global.startProgress(this.entities.size());
        global.writeProgressMessage("Reverting entities to original state");
        try {
            ArrayList<Entity> copyOfEntities = new ArrayList<Entity>();
            copyOfEntities.addAll(this.entities.values());
            this.entities.clear();
            for (Entity entity : copyOfEntities) {
                entity.revertInText(this);
            }
        }
        finally {
            global.finishProgress();
        }
    }

    private void unIgnoreAllIgnorableText() {
        Collection<IgnorableText> allIgnored = this.ignored.values();
        for (IgnorableText it : allIgnored) {
            this.fireUnIgnoreEvent(it);
        }
    }

    private void reIgnoreAllIgnorableText() {
        Collection<IgnorableText> allIgnored = this.ignored.values();
        for (IgnorableText it : allIgnored) {
            this.fireIgnoreEvent(it);
        }
    }

    private void unMarkAllForeignText() {
        Collection<ForeignText> foreigns = this.allForeign.values();
        for (ForeignText ft : foreigns) {
            if (!this.setup.isLanguageToProcess(ft.getLanguage())) continue;
            for (ForeignTextListener ftl : this.foreignTextListeners) {
                ftl.ignoreThatForeign(ft);
            }
        }
    }

    private void reMarkAllForeignText() {
        Collection<ForeignText> foreigns = this.allForeign.values();
        for (ForeignText ft : foreigns) {
            if (!this.setup.isLanguageToProcess(ft.getLanguage())) continue;
            for (ForeignTextListener ftl : this.foreignTextListeners) {
                ftl.showAsForeign(ft);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void readFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean saveWithoutTags(File file) throws BadLocationException, IOException {
        if (this.isSamplePartition()) {
            global.showError("Cannot save sample partition without tags.");
        }
        global.lockFinishProgress();
        global.startIndeterminateProgress();
        global.writeProgressMessage("Saving without tags: " + file.getName() + "...");
        this.suppressChanges();
        try {
            this.removeEntities();
            FileOutputStream fileOut = new FileOutputStream(file);
            if (file.getName().endsWith(".rtf")) {
                this.unMarkAllForeignText();
                this.unIgnoreAllIgnorableText();
                this.removeEntities();
                new RTFEditorKit().write(fileOut, (Document)this.doc, 1, this.doc.getLength() - 1);
                this.parseSpecialEntities(this.getStartOfDoc(), this.getEndOfDoc());
                this.reIgnoreAllIgnorableText();
                this.reMarkAllForeignText();
                this.fileSavedType = FileType.RTF;
            } else {
                OutputStreamWriter plainOut = new OutputStreamWriter((OutputStream)fileOut, this.charset);
                new DefaultEditorKit().write(plainOut, (Document)this.doc, 1, this.doc.getLength() - 1);
                plainOut.close();
                this.fileSavedType = FileType.PlainText;
            }
            fileOut.close();
        }
        finally {
            global.finishProgress();
            try {
                this.parseSpecialEntities(this.getStartOfDoc(), this.getEndOfDoc());
            }
            finally {
                this.unSuppressChanges();
                global.unlockFinishProgress();
                global.finishProgress();
            }
        }
        this.fileLoaded = file;
        this.fileSaved = file;
        this.fireFileChangedEvent();
        this.fireDocumentChangedFromSavedEvent(false);
        return true;
    }

    public boolean saveWithTags(File file) throws BadLocationException, IOException, InvalidInstanceChangeException {
        if (file.getName().endsWith(".rtf")) {
            global.showError("Cannot save with tags and as rtf.");
            return false;
        }
        global.lockFinishProgress();
        this.suppressChanges();
        try {
            global.startProgress(this.allForeign.size());
            global.writeProgressMessage("Restoring foreign text...");
            int fCount = 0;
            Collection<ForeignText> backwardsForeign = this.allForeign.backwardsValues();
            for (ForeignText foreign : backwardsForeign) {
                if (!this.setup.isLanguageToProcess(foreign.getLanguage())) {
                    this.removeForeignDisplayAsNotAllowedLanguage(foreign);
                }
                global.setProgressCurrent(++fCount);
            }
            this.removeEntities();
            if (this.partitionElements.size() > 0) {
                global.startProgress(this.partitionElements.size());
                global.writeProgressMessage("Marking partitions...");
                Collection<PartitionElement> backwardsPartitions = this.partitionElements.backwardsValues();
                int pCount = 0;
                for (PartitionElement partition : backwardsPartitions) {
                    partition.insertXMLTags(this.doc, this.setup);
                    global.setProgressCurrent(++pCount);
                }
            }
            global.startProgress(this.allForeign.size());
            global.writeProgressMessage("Marking up foreign text...");
            fCount = 0;
            for (ForeignText foreign : backwardsForeign) {
                foreign.insertXMLTags(this.doc, this.setup);
                global.setProgressCurrent(++fCount);
            }
            global.startProgress(this.allJoins.size());
            global.writeProgressMessage("Marking up joined text...");
            Collection<JoinInstance> backwardsJoins = this.allJoins.backwardsValues();
            int jCount = 0;
            for (JoinInstance joinInstance : backwardsJoins) {
                joinInstance.insertXMLTags(this.doc, this.setup);
                global.setProgressCurrent(++jCount);
            }
            global.startProgress(this.instances.size());
            global.writeProgressMessage("Saving with xml tags: " + file.getName() + "...");
            Collection backwardsInstances = this.instances.backwardsValues();
            int count = 0;
            for (Instance instance : backwardsInstances) {
                instance.insertXMLTags(this.doc, this.setup);
                global.setProgressCurrent(++count);
            }
            OutputStreamWriter plainOut = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
            new DefaultEditorKit().write(plainOut, (Document)this.doc, 1, this.doc.getLength() - 1);
            plainOut.close();
        }
        finally {
            global.finishProgress();
            try {
                for (Instance instance : this.instances.values()) {
                    instance.removeLastXMLTags(this.doc);
                }
                for (JoinInstance joinInstance : this.allJoins.values()) {
                    joinInstance.removeLastXMLTags(this.doc);
                }
                for (ForeignText foreign : this.allForeign.values()) {
                    foreign.removeLastXMLTags(this.doc);
                }
                for (PartitionElement partition : this.partitionElements.values()) {
                    partition.removeLastXMLTags(this.doc);
                }
                if (this.isSamplePartition()) {
                    this.parseSpecialEntities(this.currentPartition.getStartOffset(), this.currentPartition.getEndOffset());
                } else {
                    this.parseSpecialEntities(this.getStartOfDoc(), this.getEndOfDoc());
                }
                for (ForeignText foreign : this.allForeign.values()) {
                    if (this.setup.isLanguageToProcess(foreign.getLanguage())) continue;
                    this.displayForeignAsNotAllowedLanguage(foreign);
                }
            }
            finally {
                this.unSuppressChanges();
                global.unlockFinishProgress();
                global.finishProgress();
            }
        }
        this.fileLoaded = file;
        this.fileSaved = file;
        this.fileSavedType = FileType.XML;
        this.fireFileChangedEvent();
        this.fireDocumentChangedFromSavedEvent(false);
        return true;
    }

    public AttributeSet getAttributesAtPos(int pos) {
        return this.doc.getCharacterElement(pos).getAttributes();
    }

    public boolean isCharAtPosLetter(int pos) throws BadLocationException {
        return Character.isLetter(this.doc.getText(pos, 1).charAt(0));
    }

    public int getStartOfDoc() {
        return 0;
    }

    public int getEndOfDoc() {
        return this.getDocLength();
    }

    public void findReplacementsForWord(WordHolder word, int limit) {
        word.setReplacements(this.lud.findReplacements(word.getWord(), limit, this.confidenceWeights));
    }

    public String[] getShortCounts() {
        return this.shortCounts;
    }

    public static String getStatsHeader() {
        return "File\tTotal Words\tVariants\tNormalised\tNon-variants\tTotal Tokens\tVariant Tokens\tNormalised Tokens\tNon-variant Tokens";
    }

    public String getStats() {
        int wordsCount = this.words.size();
        int variantsCount = 0;
        int replacedCount = 0;
        int correctCount = 0;
        int variantTokenCount = 0;
        int replacedTokenCount = 0;
        int correctTokenCount = 0;
        for (WordHolder wh : this.words) {
            variantTokenCount += wh.getVariantsSize();
            replacedTokenCount += wh.getReplacedSize();
            correctTokenCount += wh.getCorrectSize();
            if (wh.isAtleastOneInstanceAVariant()) {
                ++variantsCount;
            }
            if (wh.isAtleastOneInstanceAReplaced()) {
                ++replacedCount;
            }
            if (!wh.isAtleastOneInstanceACorrect()) continue;
            ++correctCount;
        }
        int tokenCount = variantTokenCount + replacedTokenCount + correctTokenCount;
        return String.valueOf(wordsCount) + "\t" + variantsCount + "\t" + replacedCount + "\t" + correctCount + "\t" + tokenCount + "\t" + variantTokenCount + "\t" + replacedTokenCount + "\t" + correctTokenCount;
    }

    public NormalisationStats getNormalisationResults(String filename) {
        int wordsCount = this.words.size();
        int variantsCount = 0;
        int replacedCount = 0;
        int correctCount = 0;
        int variantTokenCount = 0;
        int replacedTokenCount = 0;
        int correctTokenCount = 0;
        for (WordHolder wh : this.words) {
            variantTokenCount += wh.getVariantsSize();
            replacedTokenCount += wh.getReplacedSize();
            correctTokenCount += wh.getCorrectSize();
            if (wh.isAtleastOneInstanceAVariant()) {
                ++variantsCount;
            }
            if (wh.isAtleastOneInstanceAReplaced()) {
                ++replacedCount;
            }
            if (!wh.isAtleastOneInstanceACorrect()) continue;
            ++correctCount;
        }
        int tokenCount = variantTokenCount + replacedTokenCount + correctTokenCount;
        return new NormalisationStats(filename, wordsCount, variantsCount, replacedCount, correctCount, tokenCount, variantTokenCount, replacedTokenCount, correctTokenCount);
    }

    @Override
    public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance lastRemoved, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.holderEmptied(holder, lastRemoved, type);
        }
        for (HolderChangeListener hcl : this.allTypesChangeListeners) {
            hcl.holderEmptied(holder, lastRemoved, type);
        }
    }

    @Override
    public void holderFilled(InstanceHolder<? extends Instance> holder, Instance lastAdded, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.holderFilled(holder, lastAdded, type);
        }
        for (HolderChangeListener hcl : this.allTypesChangeListeners) {
            hcl.holderFilled(holder, lastAdded, type);
        }
    }

    @Override
    public void suppressChanges() {
        Iterator<Object> iterator = this.changeListeners.keySet().iterator();
        while (iterator.hasNext()) {
            int type = iterator.next();
            for (HolderChangeListener hcl : this.changeListeners.get(type)) {
                hcl.suppressChanges();
            }
        }
        for (HolderChangeListener hcl : this.allTypesChangeListeners) {
            hcl.suppressChanges();
        }
    }

    @Override
    public void unSuppressChanges() {
        Iterator<Object> iterator = this.changeListeners.keySet().iterator();
        while (iterator.hasNext()) {
            int type = iterator.next();
            for (HolderChangeListener hcl : this.changeListeners.get(type)) {
                hcl.unSuppressChanges();
            }
        }
        for (HolderChangeListener hcl : this.allTypesChangeListeners) {
            hcl.unSuppressChanges();
        }
    }

    @Override
    public void instanceAboutToChange(Instance instance, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.instanceAboutToChange(instance, type);
        }
        for (HolderChangeListener hcl : this.allTypesChangeListeners) {
            hcl.instanceAboutToChange(instance, type);
        }
    }

    @Override
    public void instanceChanged(Instance instance, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.instanceChanged(instance, type);
        }
        for (HolderChangeListener hcl : this.allTypesChangeListeners) {
            hcl.instanceChanged(instance, type);
        }
    }

    @Override
    public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
        for (HolderChangeListener hcl : this.changeListeners.get(type)) {
            hcl.listChanged(holder, type);
        }
        for (HolderChangeListener hcl : this.allTypesChangeListeners) {
            hcl.listChanged(holder, type);
        }
    }

    public Instance getInstanceAt(int start) throws BadLocationException {
        return (Instance)this.instances.getElementAt(this.doc.createPosition(start));
    }

    public ForeignText getForeignAt(int start) throws BadLocationException {
        return this.allForeign.getElementAt(this.doc.createPosition(start));
    }

    public Collection<Instance> getInstances(int start, int end) throws BadLocationException {
        return this.instances.getElementsInSpan(this.doc.createPosition(start), this.doc.createPosition(end));
    }

    public TreeSet<Instance> getInstances(int type) {
        return this.instances.getInstances(type);
    }

    public Instance getFirstInstance() {
        return (Instance)this.instances.getFirstElement();
    }

    public Instance getFirstInstance(int type) {
        return this.instances.getFirstInstance(type);
    }

    public Instance getLastInstance(int type) {
        return this.instances.getLastInstance(type);
    }

    public Instance getNextInstance(int type, Instance current) {
        return this.instances.getNextInstance(type, current);
    }

    public Instance getPreviousInstance(int type, Instance current) {
        return this.instances.getPreviousInstance(type, current);
    }

    public int getPosition(Instance instance) {
        return this.instances.getPosition(instance);
    }

    public int getTokenCount() {
        return this.instances.size();
    }

    public int getTokenCount(int type) {
        return this.instances.getTokenCount(type);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void changeSetup(Setup setup) throws BadLocationException, InvalidInstanceChangeException, IOException {
        this.setup = setup;
        this.setForeignLanguages(setup.getLanguages());
        this.charset = setup.getEncoding().equals("detect") ? Charset.defaultCharset() : Charset.forName(setup.getEncoding());
        if (this.currentPartition != null && this.fileLoaded != null) {
            this.openPartition(this.fileLoaded, this.currentPartition);
        } else if (this.fileSaved != null) {
            FileType currentFileType = this.fileSavedType;
            File currentlySavedFile = this.fileSaved;
            this.processNewFile(this.fileSaved);
            if (currentFileType == FileType.XML) {
                this.saveWithTags(currentlySavedFile);
            } else {
                this.saveWithoutTags(currentlySavedFile);
            }
        } else if (this.fileLoaded != null) {
            this.processNewFile(this.fileLoaded);
        } else {
            this.fireFileChangedEvent();
        }
    }

    public void fireIgnoreEvent(IgnorableText it) {
        for (IgnorableTextListener itl : this.ignorableTextListeners) {
            itl.ignore(it);
        }
    }

    public void fireUnIgnoreEvent(IgnorableText it) {
        for (IgnorableTextListener itl : this.ignorableTextListeners) {
            itl.unIgnore(it);
        }
    }

    public void addIgnorableTextListener(IgnorableTextListener itl) {
        this.ignorableTextListeners.add(itl);
    }

    public void removeIgnorableTextListener(IgnorableTextListener itl) {
        this.ignorableTextListeners.remove(itl);
    }

    @Override
    public void replaceText(Position start, Position end, String newText, boolean replaceEntities) throws BadLocationException {
        if (replaceEntities) {
            int savedStart = start.getOffset();
            this.removeAndRevertEntities(start, end);
            start = this.doc.createPosition(savedStart);
        }
        int startInt = start.getOffset();
        AttributeSet atts = this.doc.getCharacterElement(start.getOffset()).getAttributes();
        ArrayList<DocumentElement> startEffectedElements = new ArrayList<DocumentElement>();
        for (DocumentElementList<? extends DocumentElement> elementList : this.elementLists) {
            DocumentElement startElement = elementList.getElementWithStart(start);
            if (startElement == null) continue;
            startElement.saveStart();
            startEffectedElements.add(startElement);
        }
        this.doc.remove(startInt, end.getOffset() - startInt);
        this.doc.insertString(startInt, newText, atts);
        for (DocumentElement element : startEffectedElements) {
            element.restoreStart(this.doc, 0);
        }
        if (replaceEntities) {
            this.parseSpecialEntities(startInt, end.getOffset());
        }
    }

    @Override
    public void removeIgnored(Position start, Position end) {
        List<IgnorableText> ignoredInRange = this.ignored.getElementsInSpan(start, end);
        for (IgnorableText it : ignoredInRange) {
            this.ignored.remove(it.getStart());
            this.fireUnIgnoreEvent(it);
        }
    }

    @Override
    public void parseIgnored(Position start, Position end) throws BadLocationException {
        this.ignoreText(start.getOffset(), end.getOffset());
    }

    @Override
    public Collection<ForeignText> removeForeign(Position start, Position end, boolean saveStart) throws BadLocationException, InvalidInstanceChangeException {
        List<ForeignText> foreignInRange = this.allForeign.getElementsInSpan(start, end);
        for (ForeignText ft : foreignInRange) {
            if (saveStart) {
                ft.saveStart();
            }
            this.removeForeign(ft);
        }
        return foreignInRange;
    }

    @Override
    public void restoreForeign(Collection<ForeignText> foreignToRestore) throws BadLocationException {
        for (ForeignText ft : foreignToRestore) {
            this.addForeign(ft);
        }
    }

    @Override
    public void restoreForeign(Collection<ForeignText> foreignToRestore, int offset) throws BadLocationException {
        for (ForeignText ft : foreignToRestore) {
            ft.restoreStartAndEnd(this.doc, offset);
            this.addForeign(ft);
        }
    }

    @Override
    public Collection<JoinInstance> removeJoins(Position start, Position end, boolean saveStart) {
        List<JoinInstance> joinsInRange = this.allJoins.getElementsInSpan(start, end);
        for (JoinInstance join : joinsInRange) {
            if (saveStart) {
                join.saveStart();
            }
            this.allJoins.remove(join.getStart());
        }
        return joinsInRange;
    }

    @Override
    public void restoreJoins(Collection<JoinInstance> joinsToRestore) throws BadLocationException {
        for (JoinInstance join : joinsToRestore) {
            this.allJoins.put(join.getStart(), join);
        }
    }

    @Override
    public void restoreJoins(Collection<JoinInstance> joinsToRestore, int offset) throws BadLocationException {
        for (JoinInstance join : joinsToRestore) {
            join.restoreStartAndEnd(this.doc, offset);
            this.allJoins.put(join.getStart(), join);
        }
    }

    @Override
    public Collection<Instance> removeInstances(Position start, Position end, boolean saveStart) {
        List<Instance> instancesInRange = this.instances.getElementsInSpan(start, end);
        for (Instance instance : instancesInRange) {
            if (saveStart) {
                instance.saveStart();
            }
            instance.removeSelfFromHolder();
        }
        return instancesInRange;
    }

    @Override
    public void restoreInstances(Collection<Instance> instancesToRestore) throws BadLocationException {
        for (Instance instance : instancesToRestore) {
            instance.addSelfToHolder();
        }
    }

    @Override
    public void restoreInstances(Collection<Instance> instancesToRestore, int offset) throws BadLocationException {
        for (Instance instance : instancesToRestore) {
            instance.restoreStartAndEnd(this.doc, offset);
            instance.addSelfToHolder();
        }
    }

    @Override
    public void parseInstances(Position start, Position end) throws BadLocationException {
        this.newReadWords(start.getOffset(), end.getOffset());
    }

    @Override
    public String getTextWithReplacedEntities(String text, Map<String, String> entitiesFound) {
        StringBuffer buffer;
        String currentText = text;
        for (Map.Entry<String, String> entityMapping : this.setup.getEntities().entrySet()) {
            buffer = new StringBuffer();
            Pattern emPattern = Pattern.compile(entityMapping.getKey());
            Matcher emMatcher = emPattern.matcher(currentText);
            while (emMatcher.find()) {
                emMatcher.appendReplacement(buffer, entityMapping.getValue());
                entitiesFound.put(entityMapping.getValue(), entityMapping.getKey());
            }
            emMatcher.appendTail(buffer);
            currentText = buffer.toString();
        }
        Pattern entityPattern = Pattern.compile("&#?(x?)([a-fA-F0-9]+);");
        Matcher entityMatcher = entityPattern.matcher(currentText);
        buffer = new StringBuffer();
        while (entityMatcher.find()) {
            char c;
            String x = entityMatcher.group(1);
            String entity = entityMatcher.group(2);
            String entityRep = "";
            if (x.isEmpty() && entity.matches("[0-9]+")) {
                int dec = Integer.parseInt(entity);
                c = (char)dec;
                entityRep = String.valueOf(entityRep) + c;
            } else {
                int hex = Integer.parseInt(entity, 16);
                c = (char)hex;
                entityRep = String.valueOf(entityRep) + c;
            }
            entityMatcher.appendReplacement(buffer, entityRep);
            entitiesFound.put(entityRep, entityMatcher.group());
        }
        entityMatcher.appendTail(buffer);
        return buffer.toString();
    }

    @Override
    public void listChanged() {
        this.fireDocumentChangedFromSavedEvent(true);
    }

    public void partitionText(int minSize, int maxSize) {
        this.clearPartitions();
        Collection allInstances = this.instances.values();
        Position start = null;
        Position end = null;
        int partitionSize = 0;
        int partitionCount = 0;
        int seq = 1;
        for (Instance instance : allInstances) {
            if (partitionCount == 0) {
                start = instance.getStart();
                partitionSize = new Random().nextInt(maxSize - minSize) + minSize;
            }
            end = instance.getEnd();
            if (++partitionCount != partitionSize) continue;
            PartitionElement partitionElement = new PartitionElement(start, end, seq++, partitionCount, Partition.State.queued);
            this.partitionElements.put(start, partitionElement);
            partitionCount = 0;
        }
        if (partitionCount > 0) {
            PartitionElement partitionElement = new PartitionElement(start, end, seq, partitionCount, Partition.State.queued);
            this.partitionElements.put(start, partitionElement);
        }
    }

    public boolean hasPartitions() {
        return this.partitionElements.size() > 0;
    }

    public Collection<PartitionElement> getPartitions() {
        return this.partitionElements.values();
    }

    public void clearPartitions() {
        this.partitionElements.clear();
        this.currentPartition = null;
    }

    public PartitionElement getCurrentPartition() {
        return this.currentPartition;
    }

    public boolean isSamplePartition() {
        return this.currentPartition != null;
    }

    public void markCurrentPartitionAsDone() {
        if (this.isSamplePartition()) {
            this.currentPartition.setState(Partition.State.done);
            this.fireDocumentChangedFromSavedEvent(true);
        }
    }

    public void addDocumentChangeListener(DocumentChangeListener documentChangeListener) {
        this.documentChangeListeners.add(documentChangeListener);
    }

    public boolean hasDocumentChanged() {
        return this.hasDocumentChanged;
    }

    private void fireDocumentChangedFromSavedEvent(boolean changed) {
        this.hasDocumentChanged = changed;
        for (DocumentChangeListener dcl : this.documentChangeListeners) {
            dcl.documentChangedFromSaved(changed);
        }
    }

    private void fireFileChangedEvent() {
        for (DocumentChangeListener dcl : this.documentChangeListeners) {
            dcl.fileChanged();
        }
    }

    private void fireClearedEvent() {
        for (DocumentChangeListener dcl : this.documentChangeListeners) {
            dcl.cleared();
        }
    }

    public File getFileLoaded() {
        return this.fileLoaded;
    }

    public File getFileSaved() {
        return this.fileSaved;
    }

    public boolean isFileSavedSet() {
        return this.fileSaved != null;
    }

    public FileType getFileSavedType() {
        return this.fileSavedType;
    }

    public String toString() {
        String fileString = "New file";
        if (this.fileLoaded != null) {
            fileString = this.fileLoaded.getAbsolutePath();
        }
        fileString = String.valueOf(fileString) + " (charset: " + this.charset.displayName() + ")";
        if (this.isSamplePartition()) {
            return String.valueOf(fileString) + ": " + this.currentPartition.toString();
        }
        return fileString;
    }

    public class AddWordToDictionaryEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        boolean executed = false;
        boolean undone = false;
        WordHolder wh;
        String word;

        private AddWordToDictionaryEdit(WordHolder wh, String word) {
            this.wh = wh;
            this.word = word;
        }

        public void execute() {
            if (!this.executed && DocumentModel.this.lud.checkWords(this.word.toString()) == null) {
                this.wh.setDictionaryRef(DocumentModel.this.lud.addUserWord(this.word.toString()));
                DocumentModel.this.lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.word);
                this.executed = true;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.executed) {
                if (DocumentModel.this.lud.removeWord(this.word)) {
                    this.wh.setDictionaryRef(null);
                    DocumentModel.this.lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.word);
                }
            } else {
                throw new CannotUndoException();
            }
            this.undone = true;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (!this.undone) {
                throw new CannotRedoException();
            }
            this.wh.setDictionaryRef(DocumentModel.this.lud.addUserWord(this.word.toString()));
            DocumentModel.this.lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.word);
            this.undone = false;
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Add " + this.word + " to dictionary.";
        }
    }

    public class ChangeForeignTextLanguageEdit
    extends AbstractUndoableEdit
    implements ThreadableEdit {
        private static final long serialVersionUID = 549160119967919009L;
        private boolean executed = false;
        private boolean undone = false;
        private boolean valid = false;
        private String whyInvalid;
        private final String prevLang;
        private final String newLang;
        private final ForeignText foreignText;
        private boolean newLangAllowed;
        private boolean prevLangAllowed;
        private boolean langAllowedChanged;

        private ChangeForeignTextLanguageEdit(ForeignText foreignText, String newLang) {
            this.foreignText = foreignText;
            this.newLang = newLang;
            this.prevLang = foreignText.getLanguage();
            this.newLangAllowed = DocumentModel.this.setup.isLanguageToProcess(newLang);
            this.prevLangAllowed = DocumentModel.this.setup.isLanguageToProcess(this.prevLang);
            this.langAllowedChanged = this.newLangAllowed ^ this.prevLangAllowed;
            this.valid = true;
        }

        private void doChange() throws BadLocationException, InvalidInstanceChangeException {
            this.foreignText.setLanguage(this.newLang);
            if (this.langAllowedChanged) {
                try {
                    global.startIndeterminateProgress();
                    if (this.newLangAllowed) {
                        global.writeProgressMessage("Setting foreign text to allowed language.");
                        DocumentModel.this.removeForeignDisplayAsNotAllowedLanguage(this.foreignText);
                    } else {
                        global.writeProgressMessage("Setting foreign text to not allowed language.");
                        DocumentModel.this.displayForeignAsNotAllowedLanguage(this.foreignText);
                    }
                }
                finally {
                    global.finishProgress();
                }
            }
        }

        private void undoChange() throws BadLocationException, InvalidInstanceChangeException {
            this.foreignText.setLanguage(this.prevLang);
            if (this.langAllowedChanged) {
                try {
                    global.startIndeterminateProgress();
                    if (this.newLangAllowed) {
                        global.writeProgressMessage("Setting foreign text to not allowed language.");
                        DocumentModel.this.displayForeignAsNotAllowedLanguage(this.foreignText);
                    } else {
                        global.writeProgressMessage("Setting foreign text to allowed language.");
                        DocumentModel.this.removeForeignDisplayAsNotAllowedLanguage(this.foreignText);
                    }
                }
                finally {
                    global.finishProgress();
                }
            }
        }

        @Override
        public void execute() throws CannotExecuteException {
            if (!this.executed && this.valid) {
                try {
                    this.doChange();
                    this.executed = true;
                }
                catch (BadLocationException ex) {
                    try {
                        this.undoChange();
                    }
                    catch (BadLocationException e) {
                        throw new CannotExecuteException(e.getMessage());
                    }
                    catch (InvalidInstanceChangeException e) {
                        throw new CannotExecuteException(e.getMessage());
                    }
                    throw new CannotExecuteException(ex.getMessage());
                }
                catch (InvalidInstanceChangeException ex) {
                    try {
                        this.undoChange();
                    }
                    catch (BadLocationException e) {
                        throw new CannotExecuteException(e.getMessage());
                    }
                    catch (InvalidInstanceChangeException e) {
                        throw new CannotExecuteException(e.getMessage());
                    }
                    throw new CannotExecuteException(ex.getMessage());
                }
            }
            throw new CannotExecuteException("Change of language invalid");
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.canUndo()) {
                try {
                    this.undoChange();
                    this.undone = true;
                }
                catch (BadLocationException e) {
                    try {
                        this.doChange();
                    }
                    catch (BadLocationException e1) {
                        throw new CannotUndoException();
                    }
                    catch (InvalidInstanceChangeException e1) {
                        throw new CannotUndoException();
                    }
                    throw new CannotUndoException();
                }
                catch (InvalidInstanceChangeException e) {
                    try {
                        this.doChange();
                    }
                    catch (BadLocationException e1) {
                        throw new CannotUndoException();
                    }
                    catch (InvalidInstanceChangeException e1) {
                        throw new CannotUndoException();
                    }
                    throw new CannotUndoException();
                }
            }
            throw new CannotUndoException();
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.canRedo()) {
                try {
                    this.doChange();
                    this.undone = false;
                }
                catch (BadLocationException ex) {
                    try {
                        this.undoChange();
                    }
                    catch (BadLocationException e) {
                        throw new CannotRedoException();
                    }
                    catch (InvalidInstanceChangeException e) {
                        throw new CannotRedoException();
                    }
                    throw new CannotRedoException();
                }
                catch (InvalidInstanceChangeException ex) {
                    try {
                        this.undoChange();
                    }
                    catch (BadLocationException e) {
                        throw new CannotRedoException();
                    }
                    catch (InvalidInstanceChangeException e) {
                        throw new CannotRedoException();
                    }
                    throw new CannotRedoException();
                }
            }
            throw new CannotRedoException();
        }

        @Override
        public boolean canUndo() {
            return this.executed && this.valid;
        }

        @Override
        public boolean canRedo() {
            return this.undone && this.valid;
        }

        @Override
        public String getPresentationName() {
            return "Change language from " + this.prevLang + " to " + this.newLang;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getWhyInvalid() {
            return this.whyInvalid;
        }
    }

    public static interface DocumentChangeListener {
        public void documentChangedFromSaved(boolean var1);

        public void fileChanged();

        public void cleared();
    }

    public static enum FileType {
        XML,
        PlainText,
        RTF;

    }

    public class JoinEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        private boolean executed = false;
        private boolean undone = false;
        private boolean valid = false;
        private String whyInvalid = "";
        private final JoinInstance joinInstance;
        private final TextReplacementHandler textReplacementHandler;

        private JoinEdit(int startInt, int endInt, TextReplacementHandler textReplacementHandler) throws BadLocationException {
            ForeignText ft;
            this.textReplacementHandler = textReplacementHandler;
            List wordsInSpan = DocumentModel.this.instances.getElementsInSpan(DocumentModel.this.doc.createPosition(startInt), DocumentModel.this.doc.createPosition(endInt));
            if (wordsInSpan.size() < 2) {
                this.valid = false;
                this.whyInvalid = "At least 2 words need to be selected to join.";
                this.joinInstance = null;
                return;
            }
            for (Instance instance : wordsInSpan) {
                if (instance.getType() != 102) continue;
                this.valid = false;
                this.whyInvalid = "Cannot join a normalised string.";
                this.joinInstance = null;
                return;
            }
            Position start = ((Instance)wordsInSpan.get(0)).getStart();
            Position end = ((Instance)wordsInSpan.get(wordsInSpan.size() - 1)).getEnd();
            List foreignInSpan = DocumentModel.this.allForeign.getElementsInSpan(start, end);
            if (foreignInSpan.size() > 1) {
                this.valid = false;
                this.whyInvalid = "Cannot join across foreign text markup.";
                this.joinInstance = null;
                return;
            }
            if (!(foreignInSpan.isEmpty() || (ft = (ForeignText)foreignInSpan.get(0)).getStartOffset() <= start.getOffset() && ft.getEndOffset() >= end.getOffset())) {
                this.valid = false;
                this.whyInvalid = "Cannot join across foreign text markup.";
                this.joinInstance = null;
                return;
            }
            String replacementTextXML = "";
            String replacementTextDisplay = "";
            for (Instance word : wordsInSpan) {
                replacementTextXML = String.valueOf(replacementTextXML) + word.getText();
                replacementTextDisplay = String.valueOf(replacementTextDisplay) + word.getDisplayString();
                if (replacementTextXML.endsWith("-")) {
                    replacementTextXML = replacementTextXML.substring(0, replacementTextXML.length() - 1);
                    replacementTextDisplay = replacementTextDisplay.substring(0, replacementTextDisplay.length() - 1);
                }
                if (!replacementTextXML.startsWith("-")) continue;
                replacementTextXML = replacementTextXML.substring(1);
                replacementTextDisplay = replacementTextDisplay.substring(1);
            }
            if (!DocumentModel.this.isValidWord(replacementTextDisplay)) {
                this.valid = false;
                this.whyInvalid = "Joined word (" + replacementTextDisplay + ") produced is invalid.";
                this.joinInstance = null;
                return;
            }
            String originalXMLText = DocumentModel.this.getTextWithRevertedEntities(start, end);
            String originalDisplayText = DocumentModel.this.doc.getText(start.getOffset(), end.getOffset() - start.getOffset());
            this.joinInstance = new JoinInstance(start, end, replacementTextXML, replacementTextDisplay, originalXMLText, originalDisplayText);
            this.valid = true;
        }

        private void doJoin() throws BadLocationException {
            Collection<JoinInstance> removedJoins = DocumentModel.this.removeJoins(this.joinInstance.getStart(), this.joinInstance.getEnd(), true);
            DocumentModel.this.allJoins.put(this.joinInstance.getStart(), this.joinInstance);
            this.joinInstance.setupInText(this.textReplacementHandler, removedJoins);
        }

        private void undoJoin() throws BadLocationException {
            this.joinInstance.revertInText(this.textReplacementHandler);
            DocumentModel.this.allJoins.remove(this.joinInstance.getStart());
        }

        public void execute() throws BadLocationException, InvalidInstanceChangeException {
            if (!this.executed && this.valid) {
                try {
                    this.doJoin();
                    this.executed = true;
                }
                catch (BadLocationException ex) {
                    this.undoJoin();
                    throw ex;
                }
            } else {
                throw new InvalidInstanceChangeException("Join is invalid");
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.canUndo()) {
                try {
                    this.undoJoin();
                    this.undone = true;
                }
                catch (BadLocationException ex) {
                    try {
                        this.doJoin();
                    }
                    catch (BadLocationException e) {
                        throw new CannotUndoException();
                    }
                }
            } else {
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.canRedo()) {
                try {
                    this.doJoin();
                    this.undone = false;
                }
                catch (BadLocationException ex) {
                    throw new CannotUndoException();
                }
            } else {
                throw new CannotRedoException();
            }
        }

        @Override
        public boolean canUndo() {
            return this.executed && this.valid;
        }

        @Override
        public boolean canRedo() {
            return this.undone && this.valid;
        }

        @Override
        public String getPresentationName() {
            return "Join words (" + this.joinInstance.toString() + ")";
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getWhyInvalid() {
            return this.whyInvalid;
        }
    }

    public class MarkSpanAsForeignEdit
    extends AbstractUndoableEdit
    implements ThreadableEdit {
        private static final long serialVersionUID = -4160798596355297203L;
        private boolean executed = false;
        private boolean undone = false;
        private boolean valid = false;
        private String whyInvalid;
        private Position startPos;
        private Position endPos;
        private String lang;
        private Collection<ForeignText> undoneForeign;

        private MarkSpanAsForeignEdit(Position startPos, Position endPos, String lang) throws BadLocationException {
            this.lang = lang;
            this.startPos = startPos;
            this.endPos = endPos;
            if (DocumentModel.this.allForeign.areThereAnyElementsBetween(startPos, endPos)) {
                this.valid = false;
                this.whyInvalid = "Text already marked as foreign language.";
                return;
            }
            List wordsInSpan = DocumentModel.this.instances.getElementsInSpan(startPos, endPos);
            if (!wordsInSpan.isEmpty()) {
                int newStart = ((Instance)wordsInSpan.get(0)).getStartOffset();
                int newEnd = ((Instance)wordsInSpan.get(wordsInSpan.size() - 1)).getEndOffset();
                int start = startPos.getOffset();
                int end = endPos.getOffset();
                if (newStart < start) {
                    this.startPos = DocumentModel.this.doc.createPosition(newStart);
                }
                if (newEnd > end) {
                    this.endPos = DocumentModel.this.doc.createPosition(newEnd);
                }
            }
            this.valid = true;
        }

        private void doMarkAsForeign() throws BadLocationException {
            try {
                global.startIndeterminateProgress();
                if (this.undoneForeign != null) {
                    global.writeProgressMessage("Restoring foreign language markup...");
                    DocumentModel.this.restoreForeign(this.undoneForeign);
                } else {
                    global.writeProgressMessage("Marking span as foreign language...");
                    ForeignText foreign = new ForeignText(this.startPos, this.endPos, this.lang);
                    DocumentModel.this.addForeign(foreign);
                }
            }
            finally {
                global.finishProgress();
            }
        }

        private void undoMarkAsForeign() throws BadLocationException, InvalidInstanceChangeException {
            try {
                global.startIndeterminateProgress();
                global.writeProgressMessage("Removing foreign language markup...");
                this.undoneForeign = DocumentModel.this.removeForeign(this.startPos, this.endPos, false);
            }
            finally {
                global.finishProgress();
            }
        }

        @Override
        public void execute() throws CannotExecuteException {
            if (!this.executed && this.valid) {
                try {
                    this.doMarkAsForeign();
                    this.executed = true;
                }
                catch (BadLocationException ex) {
                    try {
                        this.undoMarkAsForeign();
                        throw new CannotExecuteException(ex.getMessage());
                    }
                    catch (BadLocationException e) {
                        throw new CannotExecuteException(e.getMessage());
                    }
                    catch (InvalidInstanceChangeException e) {
                        throw new CannotExecuteException(e.getMessage());
                    }
                }
            } else {
                throw new CannotExecuteException("Mark as foreign language invalid");
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.canUndo()) {
                try {
                    this.undoMarkAsForeign();
                    this.undone = true;
                }
                catch (BadLocationException ex) {
                    try {
                        this.doMarkAsForeign();
                    }
                    catch (BadLocationException e) {
                        throw new CannotUndoException();
                    }
                }
                catch (InvalidInstanceChangeException ex) {
                    try {
                        this.doMarkAsForeign();
                    }
                    catch (BadLocationException e) {
                        throw new CannotUndoException();
                    }
                }
            } else {
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.canRedo()) {
                try {
                    this.doMarkAsForeign();
                    this.undone = false;
                }
                catch (BadLocationException ex) {
                    try {
                        this.undoMarkAsForeign();
                    }
                    catch (BadLocationException e) {
                        throw new CannotRedoException();
                    }
                    catch (InvalidInstanceChangeException e) {
                        throw new CannotRedoException();
                    }
                    throw new CannotRedoException();
                }
            }
            throw new CannotRedoException();
        }

        @Override
        public boolean canUndo() {
            return this.executed && this.valid;
        }

        @Override
        public boolean canRedo() {
            return this.undone && this.valid;
        }

        @Override
        public String getPresentationName() {
            return "Mark text as " + this.lang;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getWhyInvalid() {
            return this.whyInvalid;
        }
    }

    public class RemoveForeignEdit
    extends AbstractUndoableEdit
    implements ThreadableEdit {
        private static final long serialVersionUID = 894544678116951608L;
        private boolean executed = false;
        private boolean undone = false;
        private Position startPos;
        private Position endPos;
        private Collection<ForeignText> removedForeign;

        private RemoveForeignEdit(Position startPos, Position endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        private void doRemoveForeign() throws BadLocationException, InvalidInstanceChangeException {
            try {
                global.startIndeterminateProgress();
                global.writeProgressMessage("Removing foreign language markup...");
                this.removedForeign = DocumentModel.this.removeForeign(this.startPos, this.endPos, false);
            }
            finally {
                global.finishProgress();
            }
        }

        private void undoRemoveForeign() throws BadLocationException {
            try {
                global.startIndeterminateProgress();
                global.writeProgressMessage("Restoring foreign language markup...");
                DocumentModel.this.restoreForeign(this.removedForeign);
            }
            finally {
                global.finishProgress();
            }
        }

        @Override
        public void execute() throws CannotExecuteException {
            if (!this.executed) {
                try {
                    this.doRemoveForeign();
                    this.executed = true;
                }
                catch (BadLocationException ex) {
                    try {
                        this.undoRemoveForeign();
                        throw new CannotExecuteException(ex.getMessage());
                    }
                    catch (BadLocationException e) {
                        throw new CannotExecuteException(e.getMessage());
                    }
                }
                catch (InvalidInstanceChangeException ex) {
                    try {
                        this.undoRemoveForeign();
                        throw new CannotExecuteException(ex.getMessage());
                    }
                    catch (BadLocationException e) {
                        throw new CannotExecuteException(e.getMessage());
                    }
                }
            } else {
                throw new CannotExecuteException("Remove foreign text invalid");
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (this.canUndo()) {
                try {
                    this.undoRemoveForeign();
                    this.undone = true;
                }
                catch (BadLocationException ex) {
                    try {
                        this.doRemoveForeign();
                    }
                    catch (BadLocationException e) {
                        throw new CannotUndoException();
                    }
                    catch (InvalidInstanceChangeException e) {
                        throw new CannotUndoException();
                    }
                }
            } else {
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.canRedo()) {
                try {
                    this.doRemoveForeign();
                    this.undone = false;
                }
                catch (BadLocationException ex) {
                    throw new CannotRedoException();
                }
                catch (InvalidInstanceChangeException e) {
                    throw new CannotRedoException();
                }
            } else {
                throw new CannotRedoException();
            }
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Remove foreign text markup";
        }
    }

    public class RemoveWordFromDictionaryEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        boolean executed = false;
        boolean undone = false;
        WordHolder wh;
        String word;

        public RemoveWordFromDictionaryEdit(WordHolder wh, String word) {
            this.wh = wh;
            this.word = word;
        }

        public void execute() {
            if (!this.executed) {
                if (DocumentModel.this.lud.removeWord(this.word)) {
                    this.wh.setDictionaryRef(null);
                    DocumentModel.this.lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.word);
                }
                this.executed = true;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            if (!this.executed) {
                throw new CannotUndoException();
            }
            this.wh.setDictionaryRef(DocumentModel.this.lud.addUserWord(this.word.toString()));
            DocumentModel.this.lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "added: " + this.word);
            this.undone = true;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (this.undone) {
                if (DocumentModel.this.lud.removeWord(this.word)) {
                    DocumentModel.this.lud.setWordsChanged(true, String.valueOf(Globals.NEW_LINE) + "removed: " + this.word);
                    this.wh.setDictionaryRef(null);
                }
            } else {
                throw new CannotRedoException();
            }
            this.undone = false;
        }

        @Override
        public boolean canUndo() {
            return this.executed;
        }

        @Override
        public boolean canRedo() {
            return this.undone;
        }

        @Override
        public String getPresentationName() {
            return "Remove " + this.word + " from dictionary.";
        }
    }
}

