/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.MainScreen;
import gui.QuestionAsker;
import gui.TBJButton;
import gui.sidebar.AnnotationsSideBar;
import gui.sidebar.GeneralSetupSideBar;
import gui.sidebar.OverridesSideBar;
import gui.sidebar.SetupSideBarPanel;
import gui.sidebar.SideBarPanel;
import gui.sidebar.TextInputSideBar;
import gui.sidebar.TextPrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import model.Globals;
import model.Setup;

public class SetupSideBar
extends SideBarPanel {
    private static final long serialVersionUID = -9156912965118975058L;
    private final LinkedHashMap<String, SetupSideBarPanel> panels;
    private final JTabbedPane tabbedPane;
    private final HashMap<String, Action> actions;
    private Setup setup;
    private final SetupChangeListener changeListener;
    private final QuestionAsker questionAsker;
    private final JPanel newSetupPanel;
    private final JFileChooser fc;
    private final JTextField newSetupFolderTF;

    public SetupSideBar(Setup setup, JFrame owner, SetupChangeListener changeListener, QuestionAsker questionAsker) {
        this.setup = setup;
        this.changeListener = changeListener;
        this.questionAsker = questionAsker;
        this.panels = new LinkedHashMap();
        this.panels.put("Options", new GeneralSetupSideBar(setup, owner));
        this.panels.put("Input", new TextInputSideBar(setup));
        this.panels.put("Override", new OverridesSideBar(setup));
        this.panels.put("XML", new AnnotationsSideBar(setup));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(1);
        for (Map.Entry<String, SetupSideBarPanel> entry : this.panels.entrySet()) {
            this.tabbedPane.addTab(entry.getKey(), entry.getValue());
        }
        this.actions = new HashMap();
        this.actions.put("Revert setup", MainScreen.fixAction(new RevertSetupAction(), "Revert", null, "Revert fields to saved setup.", -1, null));
        this.actions.put("Save setup", MainScreen.fixAction(new SaveSetupAction(), "Save", null, "Save setup", -1, null));
        this.actions.put("Duplicate setup", MainScreen.fixAction(new DuplicateSetupAction(), "Save as", null, "Save as new setup folder", -1, null));
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 3));
        buttonsPanel.add(new JButton(this.actions.get("Revert setup")));
        buttonsPanel.add(new JButton(this.actions.get("Save setup")));
        buttonsPanel.add(new JButton(this.actions.get("Duplicate setup")));
        this.actions.put("Setup browse", MainScreen.fixAction(new SetupFolderBrowseAction(), "Browse", "folder_explore", "Browse for new setup folder to save to.", -1, null));
        this.newSetupPanel = new JPanel(new BorderLayout());
        this.newSetupFolderTF = new JTextField(15);
        this.newSetupFolderTF.setTransferHandler(new FolderTransferHandler());
        TextPrompt tfTP = new TextPrompt("Folder to save to", this.newSetupFolderTF);
        tfTP.setShow(TextPrompt.Show.FOCUS_LOST);
        tfTP.changeAlpha(0.5f);
        this.newSetupPanel.add((Component)this.newSetupFolderTF, "Center");
        this.newSetupPanel.add((Component)new TBJButton(this.actions.get("Setup browse")), "East");
        this.fc = new JFileChooser();
        this.fc.setCurrentDirectory(setup.getFolder());
        this.fc.setFileSelectionMode(1);
        this.fc.setMultiSelectionEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)buttonsPanel, "South");
    }

    @Override
    public void changeSetup(Setup setup) {
        this.setup = setup;
        for (SetupSideBarPanel panel : this.panels.values()) {
            panel.changeSetup(setup);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (SetupSideBarPanel panel : this.panels.values()) {
            panel.setEnabled(enabled);
        }
    }

    private class DuplicateSetupAction
    extends AbstractAction {
        private static final long serialVersionUID = 5849459619284605836L;

        private DuplicateSetupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (SetupSideBarPanel panel : SetupSideBar.this.panels.values()) {
                String message = panel.validateForm();
                if (message == null) continue;
                Globals.getInstance().showError(message);
                SetupSideBar.this.tabbedPane.setSelectedComponent(panel);
                return;
            }
            SetupSideBar.this.newSetupFolderTF.setText("");
            if (SetupSideBar.this.questionAsker.askFormQuestion(SetupSideBar.this.newSetupPanel, "Select new setup folder") == QuestionAsker.Answer.OK) {
                String folderString = SetupSideBar.this.newSetupFolderTF.getText();
                if (folderString.isEmpty()) {
                    Globals.getInstance().showError("New setup folder must be given.");
                    return;
                }
                File newFolder = new File(folderString);
                if (newFolder.isFile() && (newFolder = newFolder.getParentFile()) == null) {
                    Globals.getInstance().showError("New setup folder is invalid, please select a folder.");
                    return;
                }
                final File folder = newFolder;
                new SwingWorker<Boolean, Exception>(){
                    private Setup newSetup;

                    @Override
                    protected Boolean doInBackground() {
                        this.newSetup = new Setup(folder);
                        String trainingFolderString = ((GeneralSetupSideBar)SetupSideBar.this.panels.get("Options")).getTrainingFolderString();
                        File oldTrainingFolder = new File(SetupSideBar.this.setup.getFolder(), trainingFolderString);
                        if (oldTrainingFolder.isDirectory()) {
                            File newTrainingFolder = new File(this.newSetup.getFolder(), trainingFolderString);
                            newTrainingFolder.mkdirs();
                        }
                        for (SetupSideBarPanel panel : SetupSideBar.this.panels.values()) {
                            panel.updateSetup(this.newSetup);
                        }
                        try {
                            this.newSetup.writeToFiles();
                            Setup.addToPreviousSetups(this.newSetup);
                            return true;
                        }
                        catch (IOException ex) {
                            this.publish(ex);
                            return false;
                        }
                    }

                    @Override
                    protected void process(List<Exception> exceptions) {
                        for (Exception ex : exceptions) {
                            Globals.getInstance().showException("Error occurred creating new setup, please report.", ex);
                        }
                    }

                    @Override
                    protected void done() {
                        try {
                            if (((Boolean)this.get()).booleanValue()) {
                                SetupSideBar.this.changeListener.changeSetup(this.newSetup);
                            }
                        }
                        catch (InterruptedException ex) {
                            Globals.getInstance().showException("Error occurred creating new setup, please report.", ex);
                        }
                        catch (ExecutionException ex) {
                            Globals.getInstance().showException("Error occurred creating new setup, please report.", ex);
                        }
                    }
                }.execute();
            }
        }
    }

    private class FolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -260318740428503951L;

        private FolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List files;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (files.isEmpty()) {
                return false;
            }
            File folder = (File)files.get(0);
            if (!folder.isDirectory()) {
                folder = folder.getParentFile();
            }
            SetupSideBar.this.newSetupFolderTF.setText(folder.getAbsolutePath());
            return true;
        }
    }

    private class RevertSetupAction
    extends AbstractAction {
        private static final long serialVersionUID = 6227400348970650991L;

        private RevertSetupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (SetupSideBarPanel panel : SetupSideBar.this.panels.values()) {
                panel.changeSetup(SetupSideBar.this.setup);
            }
        }
    }

    private class SaveSetupAction
    extends AbstractAction {
        private static final long serialVersionUID = 8677242825838670896L;

        private SaveSetupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (SetupSideBarPanel panel : SetupSideBar.this.panels.values()) {
                String message = panel.validateForm();
                if (message == null) continue;
                Globals.getInstance().showError(message);
                SetupSideBar.this.tabbedPane.setSelectedComponent(panel);
                return;
            }
            new SwingWorker<Boolean, Exception>(){
                private Setup newSetup;

                @Override
                protected Boolean doInBackground() {
                    this.newSetup = new Setup(SetupSideBar.this.setup.getFolder());
                    for (SetupSideBarPanel panel : SetupSideBar.this.panels.values()) {
                        panel.updateSetup(this.newSetup);
                    }
                    try {
                        this.newSetup.writeToFiles();
                        Setup.addToPreviousSetups(this.newSetup);
                        return true;
                    }
                    catch (IOException e) {
                        this.publish(e);
                        return false;
                    }
                }

                @Override
                protected void process(List<Exception> exceptions) {
                    for (Exception ex : exceptions) {
                        Globals.getInstance().showException("Error occurred saving setup, please report.", ex);
                    }
                }

                @Override
                protected void done() {
                    try {
                        if (((Boolean)this.get()).booleanValue()) {
                            SetupSideBar.this.changeListener.changeSetup(this.newSetup);
                        }
                    }
                    catch (InterruptedException ex) {
                        Globals.getInstance().showException("Error occurred saving setup, please report.", ex);
                    }
                    catch (ExecutionException ex) {
                        Globals.getInstance().showException("Error occurred saving setup, please report.", ex);
                    }
                }
            }.execute();
        }
    }

    public static interface SetupChangeListener {
        public void changeSetup(Setup var1);
    }

    private class SetupFolderBrowseAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -4484055645720417160L;

        private SetupFolderBrowseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int openReturnVal = SetupSideBar.this.fc.showSaveDialog(SetupSideBar.this.newSetupPanel);
            if (openReturnVal == 0) {
                String ofs = SetupSideBar.this.fc.getSelectedFile().getAbsolutePath();
                SetupSideBar.this.newSetupFolderTF.setText(ofs);
            }
        }
    }
}

