/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.MainScreen;
import gui.TBJButton;
import gui.sidebar.FourPiecePanel;
import gui.sidebar.LanguageTableModel;
import gui.sidebar.SetupSideBarPanel;
import gui.sidebar.TextPrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;
import model.Setup;

public class GeneralSetupSideBar
extends SetupSideBarPanel {
    private static final long serialVersionUID = 5227124331579359182L;
    private final HashMap<String, Action> actions;
    private final JTextField setupNameTF;
    private final JTextField trainingFolderTF;
    private final JTextField annotatorIDTF;
    private final JTextField addLanguageTF;
    private final JTable languageTable;
    private final LanguageTableModel languageTableModel;
    private final JFileChooser fc;
    private final JFrame owner;
    private Setup setup;

    public GeneralSetupSideBar(Setup setup, JFrame owner) {
        this.setup = setup;
        this.owner = owner;
        this.actions = new HashMap();
        JPanel setupNamePanel = new JPanel(new BorderLayout());
        setupNamePanel.setBorder(BorderFactory.createTitledBorder("Setup name"));
        this.setupNameTF = new JTextField(setup.getSetupName());
        TextPrompt snTP = new TextPrompt("Required", this.setupNameTF);
        snTP.setShow(TextPrompt.Show.FOCUS_LOST);
        snTP.changeAlpha(0.5f);
        setupNamePanel.add(this.setupNameTF);
        this.actions.put("Training browse", MainScreen.fixAction(new TrainingFolderBrowseAction(), "Browse", "folder_explore", "Browse for training folder.", -1, null));
        this.fc = new JFileChooser();
        this.fc.setCurrentDirectory(setup.getFolder());
        this.fc.setFileSelectionMode(1);
        this.fc.setMultiSelectionEnabled(false);
        JPanel trainingFolderPanel = new JPanel(new BorderLayout());
        trainingFolderPanel.setBorder(BorderFactory.createTitledBorder("Training folder"));
        this.trainingFolderTF = new JTextField(setup.getRelativeTrainingFolderString());
        TextPrompt tfTP = new TextPrompt("Required", this.trainingFolderTF);
        tfTP.setShow(TextPrompt.Show.FOCUS_LOST);
        tfTP.changeAlpha(0.5f);
        this.trainingFolderTF.setTransferHandler(new FolderTransferHandler());
        trainingFolderPanel.add((Component)this.trainingFolderTF, "Center");
        trainingFolderPanel.add((Component)new TBJButton(this.actions.get("Training browse")), "East");
        JPanel annotatorIDPanel = new JPanel(new BorderLayout());
        annotatorIDPanel.setBorder(BorderFactory.createTitledBorder("Annotator ID"));
        this.annotatorIDTF = new JTextField(setup.getAnnotatorID());
        TextPrompt aidTP = new TextPrompt("No annotator ID", this.annotatorIDTF);
        aidTP.setShow(TextPrompt.Show.FOCUS_LOST);
        aidTP.changeAlpha(0.5f);
        annotatorIDPanel.add((Component)this.annotatorIDTF, "Center");
        this.languageTableModel = new LanguageTableModel(setup);
        this.languageTable = new JTable(this.languageTableModel);
        JScrollPane langTableSP = new JScrollPane(this.languageTable, 20, 31);
        this.actions.put("lang Add", MainScreen.fixAction(new AddLanguageToTableAction(), "Add language", "world_add", "Add language", -1, null));
        this.actions.put("lang Remove", MainScreen.fixAction(new RemoveSelectedLanguagesAction(), "Remove selected language(s)", "world_delete", "Remove selected language(s)", -1, null));
        JToolBar languageTB = new JToolBar(1);
        languageTB.setFloatable(false);
        languageTB.add(new TBJButton(this.actions.get("lang Remove")));
        this.addLanguageTF = new JTextField(10);
        this.addLanguageTF.setAction(this.actions.get("lang Add"));
        FourPiecePanel langTablePanel = new FourPiecePanel(langTableSP, languageTB, this.addLanguageTF, new TBJButton(this.actions.get("lang Add")));
        langTablePanel.setBorder(BorderFactory.createTitledBorder("Languages"));
        GridBagConstraints fv = new GridBagConstraints();
        fv.gridx = 0;
        fv.weighty = 1.0;
        fv.weightx = 1.0;
        fv.fill = 1;
        GridBagConstraints nfv = new GridBagConstraints();
        nfv.gridx = 0;
        nfv.weighty = 0.0;
        nfv.weightx = 1.0;
        nfv.fill = 2;
        this.setLayout(new GridBagLayout());
        this.add((Component)setupNamePanel, nfv);
        this.add((Component)trainingFolderPanel, nfv);
        this.add((Component)annotatorIDPanel, nfv);
        this.add((Component)langTablePanel, fv);
    }

    public String getTrainingFolderString() {
        return this.trainingFolderTF.getText();
    }

    @Override
    public void changeSetup(Setup setup) {
        this.setup = setup;
        this.setupNameTF.setText(setup.getSetupName());
        this.trainingFolderTF.setText(setup.getRelativeTrainingFolderString());
        this.annotatorIDTF.setText(setup.getAnnotatorID());
        this.languageTableModel.changeSetup(setup);
        this.fc.setCurrentDirectory(setup.getFolder());
    }

    @Override
    public void updateSetup(Setup setup) {
        setup.setSetupName(this.setupNameTF.getText());
        setup.setTrainingFolder(this.trainingFolderTF.getText());
        setup.setAnnotatorID(this.annotatorIDTF.getText());
        setup.setLanguages(this.languageTableModel.getLanguageMap());
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Action action : this.actions.values()) {
            action.setEnabled(enabled);
        }
        this.setupNameTF.setEnabled(enabled);
        this.trainingFolderTF.setEnabled(enabled);
        this.annotatorIDTF.setEnabled(enabled);
        this.languageTable.setEnabled(enabled);
    }

    @Override
    public String validateForm() {
        if (this.setupNameTF.getText().isEmpty()) {
            return "Setup name must be present.";
        }
        if (this.trainingFolderTF.getText().isEmpty()) {
            return "Training folder must be present.";
        }
        return null;
    }

    private class AddLanguageToTableAction
    extends AbstractAction {
        private static final long serialVersionUID = -2678516577014692472L;

        private AddLanguageToTableAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String lang = GeneralSetupSideBar.this.addLanguageTF.getText();
            if (!lang.isEmpty()) {
                GeneralSetupSideBar.this.languageTableModel.addLanguage(lang);
                GeneralSetupSideBar.this.addLanguageTF.setText("");
            }
        }
    }

    private class FolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -260318740428503951L;

        private FolderTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            List files;
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error occurred selecting output folder.\n\n" + ex.getMessage(), "Error", 0);
                return false;
            }
            if (files.isEmpty()) {
                return false;
            }
            File folder = (File)files.get(0);
            if (!folder.isDirectory()) {
                folder = folder.getParentFile();
            }
            GeneralSetupSideBar.this.trainingFolderTF.setText(GeneralSetupSideBar.this.setup.getRelativeFolderString(folder.getAbsolutePath()));
            return true;
        }
    }

    private class RemoveSelectedLanguagesAction
    extends AbstractAction {
        private static final long serialVersionUID = 4523926157551679229L;

        private RemoveSelectedLanguagesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GeneralSetupSideBar.this.languageTableModel.removeRow(GeneralSetupSideBar.this.languageTable.getSelectedRows());
        }
    }

    private class TrainingFolderBrowseAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -4484055645720417160L;

        private TrainingFolderBrowseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int openReturnVal = GeneralSetupSideBar.this.fc.showSaveDialog(GeneralSetupSideBar.this.owner);
            if (openReturnVal == 0) {
                String ofs = GeneralSetupSideBar.this.fc.getSelectedFile().getAbsolutePath();
                GeneralSetupSideBar.this.trainingFolderTF.setText(GeneralSetupSideBar.this.setup.getRelativeFolderString(ofs));
            }
        }
    }
}

