/*
 * Decompiled with CFR 0.152.
 */
package gui.sidebar;

import gui.DisplayUtilities;
import gui.DocumentView;
import gui.MainScreen;
import gui.MarkAllFInstancesAsTAction;
import gui.NormaliseAllInstancesOfVariantAction;
import gui.NormaliseToAction;
import gui.QuestionAsker;
import gui.RevertAllAction;
import gui.TBJButton;
import gui.TBJToggleButton;
import gui.ThreadedProcessEditHolder;
import gui.sidebar.CardPanel;
import gui.sidebar.CorrectStepPanel;
import gui.sidebar.InstanceStepPanel;
import gui.sidebar.NormalisedStepPanel;
import gui.sidebar.SideBarPanel;
import gui.sidebar.VariantStepPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.UndoableEditSupport;
import model.Capitalisation;
import model.ConfidenceWeights;
import model.Setup;
import model.SuggestedReplacement;
import model.doc.DocumentModel;
import model.doc.HolderChangeListener;
import model.doc.Instance;
import model.doc.InstanceHolder;
import model.doc.ProcessAllVariantsEdit;
import model.doc.ReplacedInstance;
import model.doc.WordHolder;
import model.lookup.LookUpDictionary;

public class DocumentSideBar
extends SideBarPanel
implements HolderChangeListener,
ConfidenceWeights.ChangeListener,
DocumentView.DocumentViewChangeListener,
ListSelectionListener,
MouseListener {
    private static final long serialVersionUID = 6422893999980125457L;
    private boolean allowEditing = false;
    private boolean ignoreUpdates = false;
    private static final int TYPE_INSTANCES = 55;
    private static final int TEXT_INSTANCES = 56;
    private int instancesControl = 56;
    private final JToggleButton typeInstancesTB;
    private final JToggleButton textInstancesTB;
    private final JRadioButton[] radioButtonArray;
    private final ButtonGroup radioButtonGroup;
    private final JLabel nextPreviousLabel;
    private final CardPanel<InstanceStepPanel> stepPanel;
    private final JList wordList;
    private final JScrollPane wordListSP;
    private boolean sortByFreq = false;
    private final JSpinner thresholdSpinner;
    private final DocumentView documentView;
    private HashMap<String, Action> actions;
    private final DocumentModel docModel;
    private final ConfidenceWeights confidenceWeights;
    private final LookUpDictionary lud;
    private final UndoableEditSupport undoSupport;
    private final QuestionAsker questionAsker;

    public DocumentSideBar(DocumentModel docModel, ConfidenceWeights confidenceWeights, LookUpDictionary lud, UndoableEditSupport undoSupport, DocumentView documentView, QuestionAsker questionAsker) {
        this.docModel = docModel;
        this.confidenceWeights = confidenceWeights;
        this.lud = lud;
        this.undoSupport = undoSupport;
        this.documentView = documentView;
        this.questionAsker = questionAsker;
        documentView.addChangeListener(this);
        this.actions = new HashMap();
        this.actions.put("Correct All", MainScreen.fixAction(new ProcessAllVariantsAction(), "Normalise all", "lightning_go", "Normalise all variants with top replacement when above threshold", -1, null));
        this.actions.put("Copy List", MainScreen.fixAction(new CopyListAction(), "Copy List", "page_white_copy", "Copy current list to system's clipboard", -1, null));
        this.actions.put("Sort A-Z", MainScreen.fixAction(new SortAZAction(), "Sort A-Z", "alphasort", "Sort list alphabetically", -1, null));
        this.actions.put("Sort Freq", MainScreen.fixAction(new SortFreqAction(), "Sort by frequency", "sum", "Sort list by frequency (descending)", -1, null));
        this.actions.put("Next Instance", MainScreen.fixAction(new NextInstanceAction(), "Next Instance", "resultset_next", "Find the next instance of the selected word.", 39, KeyStroke.getKeyStroke(39, 0)));
        this.actions.put("Previous Instance", MainScreen.fixAction(new PreviousInstanceAction(), "Previous Instance", "resultset_previous", "Find the previous instance of the selected word.", 37, KeyStroke.getKeyStroke(37, 0)));
        this.actions.put("First Instance", MainScreen.fixAction(new FirstInstanceAction(), "First Instance", "resultset_first", "Find the first instance of the selected word.", -1, KeyStroke.getKeyStroke(37, 2)));
        this.actions.put("Last Instance", MainScreen.fixAction(new LastInstanceAction(), "Last Instance", "resultset_last", "Find the last instance of the selected word.", -1, KeyStroke.getKeyStroke(39, 2)));
        this.actions.put("Text Control", MainScreen.fixAction(new TextInstancesControlAction(), "Text", "arrow_left", "Cycle through text instances.", -1, null));
        this.actions.put("Type Control", MainScreen.fixAction(new TypeInstancesControlAction(), "Types", "arrow_up", "Cycle through selected type instances.", -1, null));
        this.actions.put("Clear selection", MainScreen.fixAction(new ClearSelectionAction(), "Clear", "cross", "Clear selection.", -1, null));
        this.radioButtonArray = new JRadioButton[WordHolder.types.length];
        this.radioButtonGroup = new ButtonGroup();
        JPanel displaySelectPanel = new JPanel();
        displaySelectPanel.setBorder(new TitledBorder("Display"));
        displaySelectPanel.setLayout(new BoxLayout(displaySelectPanel, 3));
        int i = 0;
        while (i < this.radioButtonArray.length) {
            this.radioButtonArray[i] = new JRadioButton(new RadioButtonAction(WordHolder.types[i]));
            this.radioButtonGroup.add(this.radioButtonArray[i]);
            displaySelectPanel.add(this.radioButtonArray[i]);
            this.radioButtonArray[i].setAlignmentX(0.0f);
            this.radioButtonArray[i].setFocusable(false);
            ++i;
        }
        this.radioButtonArray[0].setSelected(true);
        TBJToggleButton azButton = new TBJToggleButton(this.actions.get("Sort A-Z"));
        TBJToggleButton freqButton = new TBJToggleButton(this.actions.get("Sort Freq"));
        azButton.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(azButton);
        bg.add(freqButton);
        JToolBar listToolBar = new JToolBar(1);
        listToolBar.setFloatable(false);
        listToolBar.add(azButton);
        listToolBar.add(freqButton);
        listToolBar.add(new TBJButton(this.actions.get("Copy List")));
        listToolBar.add(new TBJButton(this.actions.get("Clear selection")));
        this.wordList = new JList();
        this.wordList.setFocusable(false);
        this.wordList.setPrototypeCellValue("123456789012345");
        this.wordList.setVisibleRowCount(7);
        this.wordList.setSelectionBackground(DocumentView.SELECTION_COLOUR);
        this.wordList.addListSelectionListener(this);
        this.wordList.setSelectionMode(0);
        this.wordList.addMouseListener(this);
        this.wordListSP = new JScrollPane(this.wordList, 22, 31);
        this.wordListSP.setAlignmentX(0.0f);
        JPanel typesListPanel = new JPanel(new BorderLayout());
        typesListPanel.setBorder(new TitledBorder("Types List"));
        typesListPanel.add((Component)this.wordListSP, "Center");
        typesListPanel.add((Component)listToolBar, "East");
        this.textInstancesTB = new TBJToggleButton(this.actions.get("Text Control"));
        this.typeInstancesTB = new TBJToggleButton(this.actions.get("Type Control"));
        ButtonGroup controlBG = new ButtonGroup();
        controlBG.add(this.textInstancesTB);
        controlBG.add(this.typeInstancesTB);
        this.textInstancesTB.setSelected(true);
        this.nextPreviousLabel = new JLabel("         ", 0);
        this.nextPreviousLabel.setAlignmentX(0.5f);
        TBJButton previousInstanceButton = new TBJButton(this.actions.get("Previous Instance"));
        TBJButton nextInstanceButton = new TBJButton(this.actions.get("Next Instance"));
        TBJButton firstInstanceButton = new TBJButton(this.actions.get("First Instance"));
        TBJButton lastInstanceButton = new TBJButton(this.actions.get("Last Instance"));
        JPanel nextPreviousPanel = new JPanel(new GridBagLayout());
        GridBagConstraints b = new GridBagConstraints();
        b.fill = 0;
        GridBagConstraints l = new GridBagConstraints();
        l.fill = 2;
        l.weightx = 1.0;
        GridBagConstraints l2 = new GridBagConstraints();
        l2.fill = 2;
        l2.weightx = 2.0;
        nextPreviousPanel.add((Component)this.textInstancesTB, b);
        nextPreviousPanel.add(Box.createGlue(), l2);
        nextPreviousPanel.add((Component)firstInstanceButton, b);
        nextPreviousPanel.add((Component)previousInstanceButton, b);
        nextPreviousPanel.add((Component)this.nextPreviousLabel, l);
        nextPreviousPanel.add((Component)nextInstanceButton, b);
        nextPreviousPanel.add((Component)lastInstanceButton, b);
        nextPreviousPanel.add(Box.createGlue(), l2);
        nextPreviousPanel.add((Component)this.typeInstancesTB, b);
        this.stepPanel = new CardPanel();
        VariantStepPanel vsp = new VariantStepPanel(docModel, lud, confidenceWeights, undoSupport, questionAsker);
        NormalisedStepPanel rsp = new NormalisedStepPanel(docModel, undoSupport);
        CorrectStepPanel csp = new CorrectStepPanel(docModel, undoSupport, questionAsker);
        this.stepPanel.add(new InstanceStepPanel(), 0);
        this.stepPanel.add(vsp, 101);
        this.stepPanel.add(rsp, 102);
        this.stepPanel.add(csp, 103);
        this.stepPanel.show(0);
        JPanel autoPanel = new JPanel(new GridBagLayout());
        autoPanel.setBorder(BorderFactory.createTitledBorder("Auto Normalise"));
        JLabel thresholdLabel = new JLabel("  Threshold (%):", 11);
        autoPanel.add((Component)thresholdLabel, b);
        this.thresholdSpinner = new JSpinner(new SpinnerNumberModel(50, 0, 99, 5));
        this.thresholdSpinner.setFocusable(false);
        thresholdLabel.setLabelFor(this.thresholdSpinner);
        autoPanel.add((Component)this.thresholdSpinner, b);
        autoPanel.add((Component)new TBJButton(this.actions.get("Correct All")), b);
        autoPanel.add(Box.createGlue(), l);
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)typesListPanel, "Center");
        JPanel allStepPanel = new JPanel(new BorderLayout());
        allStepPanel.setBorder(new TitledBorder("Step Complete"));
        allStepPanel.add((Component)nextPreviousPanel, "North");
        allStepPanel.add((Component)this.stepPanel.getPanel(), "Center");
        middlePanel.add((Component)allStepPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)displaySelectPanel, "North");
        this.add((Component)middlePanel, "Center");
        this.add((Component)autoPanel, "South");
        docModel.addChangeListener(this);
        this.textCleared();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.allowEditing = enabled;
        this.wordList.setEnabled(enabled);
        JRadioButton[] jRadioButtonArray = this.radioButtonArray;
        int n = this.radioButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRadioButton rb = jRadioButtonArray[n2];
            rb.setEnabled(enabled);
            ++n2;
        }
        Collection<InstanceStepPanel> stepPanels = this.stepPanel.getCards();
        for (InstanceStepPanel sp : stepPanels) {
            sp.setEnabled(enabled);
        }
        for (Action a : this.actions.values()) {
            a.setEnabled(enabled);
        }
    }

    private JMenu getReplacementPopupMenu(SuggestedReplacement replacement, WordHolder wh, int type, Capitalisation.CapType capitalisation) {
        double weight = this.confidenceWeights.getFWeight();
        JMenu toReturn = new JMenu(replacement.toMenuString(capitalisation));
        Set<String> methods = this.confidenceWeights.getScores().keySet();
        Vector<JMenuItem> mis = new Vector<JMenuItem>(1 + methods.size());
        for (String method : methods) {
            mis.add(new JMenuItem(String.valueOf(method) + ": " + replacement.getScoreUpdate(method).getUpdate().toMenuString(weight)));
        }
        mis.add(new JMenuItem("Frequency is " + replacement.getFreq()));
        if (type == 101) {
            toReturn.add(new NormaliseAllInstancesOfVariantAction(wh, 101, replacement, this.docModel, this.lud, this.undoSupport));
        }
        toReturn.addSeparator();
        for (JMenuItem m : mis) {
            m.setEnabled(false);
            toReturn.add(m);
        }
        return toReturn;
    }

    private void updateList(int type) {
        int radioButton = -1;
        int i = 0;
        while (i < WordHolder.types.length) {
            if (WordHolder.types[i] == type) {
                radioButton = i;
            }
            ++i;
        }
        this.radioButtonArray[radioButton].setText(String.valueOf(WordHolder.getTypeName(type)) + " (" + DisplayUtilities.getFormattedNumber(this.docModel.getTokenCount(type)) + " tokens)");
        if (this.documentView.getListSelected() == type) {
            Object currentListSelection = this.wordList.getSelectedValue();
            TreeSet<InstanceHolder<? extends Instance>> hl = this.docModel.getHolderList(type);
            if (this.sortByFreq) {
                TreeSet<InstanceHolder<? extends Instance>> resorted = new TreeSet<InstanceHolder<? extends Instance>>(new InstanceHolder.FreqComparator());
                resorted.addAll(hl);
                hl = resorted;
            }
            Object[] holderList = hl.toArray();
            this.wordList.setListData(holderList);
            this.wordList.setSelectedValue(currentListSelection, true);
        }
    }

    @Override
    public void listChanged(InstanceHolder<? extends Instance> holder, int type) {
        if (!this.ignoreUpdates) {
            this.updateList(type);
            Instance selectedInstance = this.documentView.getSelectedInstance();
            InstanceHolder<? extends Instance> selectedHolder = this.documentView.getSelectedHolder();
            int listSelected = this.documentView.getListSelected();
            Instance toSelectInstance = selectedInstance;
            if (toSelectInstance != null && listSelected == type && selectedHolder == holder && !selectedHolder.contains(selectedInstance)) {
                switch (this.instancesControl) {
                    case 55: {
                        TreeSet<InstanceHolder<? extends Instance>> list;
                        toSelectInstance = selectedHolder.nextInstance(selectedInstance);
                        if (toSelectInstance != null || (list = this.docModel.getHolderList(listSelected)).isEmpty()) break;
                        InstanceHolder<? extends Instance> next = null;
                        if (this.sortByFreq) {
                            TreeSet<InstanceHolder<? extends Instance>> resorted = new TreeSet<InstanceHolder<? extends Instance>>(new InstanceHolder.FreqComparator());
                            resorted.addAll(list);
                            list = resorted;
                        } else {
                            next = list.higher(selectedHolder);
                        }
                        if (next == null) {
                            next = list.first();
                        }
                        this.documentView.changeSelectedType(next);
                        toSelectInstance = next.firstInstance();
                        break;
                    }
                    case 56: {
                        toSelectInstance = this.docModel.getNextInstance(type, selectedInstance);
                    }
                }
            }
            this.documentView.changeSelectedInstance(toSelectInstance);
        }
    }

    @Override
    public void instanceAboutToChange(Instance instance, int type) {
    }

    @Override
    public void instanceChanged(Instance instance, int type) {
    }

    @Override
    public void holderEmptied(InstanceHolder<? extends Instance> holder, Instance lastRemoved, int type) {
    }

    @Override
    public void holderFilled(InstanceHolder<? extends Instance> holder, Instance lastAdded, int type) {
    }

    @Override
    public void suppressChanges() {
        this.ignoreUpdates = true;
    }

    @Override
    public void unSuppressChanges() {
        this.ignoreUpdates = false;
        int[] nArray = WordHolder.types;
        int n = WordHolder.types.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.updateList(type);
            ++n2;
        }
        this.documentView.changeList(this.documentView.getListSelected());
    }

    @Override
    public void weightsChanged(boolean changed) {
        if (this.stepPanel.isShowing(101)) {
            this.stepPanel.getCurrentCard().changeInstance(this.documentView.getSelectedInstance());
        }
    }

    @Override
    public void selectedInstanceChanged(Instance instance) {
        if (instance != null) {
            if (this.instancesControl == 56) {
                this.wordList.setSelectedValue(instance.getInstanceHolder(), true);
            }
            switch (this.instancesControl) {
                case 55: {
                    this.nextPreviousLabel.setText(String.valueOf(this.documentView.getSelectedHolder().getPosition(instance)) + "/" + this.documentView.getSelectedHolder().size());
                    break;
                }
                case 56: {
                    this.nextPreviousLabel.setText(String.valueOf(this.docModel.getPosition(instance)) + "/" + this.docModel.getTokenCount(instance.getType()));
                }
            }
            this.stepPanel.show(instance.getType());
            this.stepPanel.getCurrentCard().changeInstance(instance);
        } else {
            this.nextPreviousLabel.setText("         ");
            this.stepPanel.getCurrentCard().emptyInstance();
            this.stepPanel.show(0);
        }
    }

    @Override
    public void selectedTypeChanged(InstanceHolder<? extends Instance> newSelection) {
        if (newSelection != null) {
            this.wordList.setSelectedValue(newSelection, true);
        } else {
            this.wordList.clearSelection();
            this.wordList.ensureIndexIsVisible(0);
        }
    }

    public void clearSelection() {
        this.documentView.changeSelectedInstance(null);
        this.documentView.changeSelectedType(null);
    }

    @Override
    public void currentListChanged(int list) {
        int rb = 0;
        int i = 0;
        while (i < WordHolder.types.length) {
            if (WordHolder.types[i] == list) {
                rb = i;
            }
            ++i;
        }
        this.radioButtonArray[rb].setSelected(true);
        TreeSet<InstanceHolder<? extends Instance>> hl = this.docModel.getHolderList(list);
        if (this.sortByFreq) {
            TreeSet<InstanceHolder<? extends Instance>> resorted = new TreeSet<InstanceHolder<? extends Instance>>(new InstanceHolder.FreqComparator());
            resorted.addAll(hl);
            hl = resorted;
        }
        Object[] holderList = hl.toArray();
        this.wordList.setListData(holderList);
        this.nextPreviousLabel.setText("           ");
        this.stepPanel.show(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.wordList.isSelectionEmpty()) {
            InstanceHolder selectedValue = (InstanceHolder)this.wordList.getSelectedValue();
            this.documentView.changeSelectedType(selectedValue);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.allowEditing && e.getButton() == 3) {
            int toSelect = this.wordList.locationToIndex(e.getPoint());
            this.wordList.setSelectedIndex(toSelect);
            InstanceHolder instanceHolder = (InstanceHolder)this.wordList.getSelectedValue();
            if (instanceHolder == null) {
                return;
            }
            WordHolder wordHolder = instanceHolder.getWordHolder();
            Rectangle cellRect = this.wordList.getCellBounds(toSelect, toSelect);
            switch (instanceHolder.getType()) {
                case 101: {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem wait = new JMenuItem("Please Wait...");
                    wait.setEnabled(false);
                    popup.add(wait);
                    popup.show(this.wordList, cellRect.x, cellRect.y + cellRect.height);
                    JMenu more = new JMenu("More Suggestions...");
                    int added = 0;
                    this.docModel.findReplacementsForWord(wordHolder, 25);
                    List<SuggestedReplacement> reps = wordHolder.getReplacements();
                    for (SuggestedReplacement replacement : reps) {
                        JMenu repPopup = this.getReplacementPopupMenu(replacement, wordHolder, 101, instanceHolder.getCapitalisation());
                        if (added < 5) {
                            popup.add(repPopup);
                            ++added;
                            continue;
                        }
                        more.add(repPopup);
                        ++added;
                    }
                    if (added == 0) {
                        JMenuItem noneFound = new JMenuItem("No Replacements found");
                        noneFound.setEnabled(false);
                        popup.add(noneFound);
                    }
                    if (added > 5) {
                        popup.add(more);
                    }
                    popup.addSeparator();
                    popup.add(new NormaliseToAction(wordHolder, 101, this.docModel, this.lud, this.confidenceWeights, this.undoSupport, this.questionAsker));
                    popup.add(new MarkAllFInstancesAsTAction(wordHolder, 101, 103, this.docModel, this.undoSupport, this.questionAsker));
                    popup.setVisible(false);
                    popup.remove(wait);
                    popup.show(this.wordList, cellRect.x, cellRect.y + cellRect.height);
                    break;
                }
                case 103: {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new MarkAllFInstancesAsTAction(wordHolder, 103, 101, this.docModel, this.undoSupport, this.questionAsker));
                    popup.show(this.wordList, cellRect.x, cellRect.y + cellRect.height);
                    break;
                }
                case 102: {
                    JPopupMenu popup = new JPopupMenu();
                    ReplacedInstance first = (ReplacedInstance)instanceHolder.firstInstance();
                    if (first == null) break;
                    popup.add(new RevertAllAction(wordHolder, first.getReplacement(), this.docModel, this.undoSupport));
                    popup.show(this.wordList, cellRect.x, cellRect.y + cellRect.height);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.typeInstancesTB.setSelected(true);
        this.instancesControl = 55;
        if (this.documentView.getSelectedHolder() != null) {
            this.documentView.changeSelectedInstance(this.documentView.getSelectedHolder().firstInstance());
        }
    }

    @Override
    public void changeSetup(Setup setup) {
    }

    @Override
    public void textCleared() {
        int[] nArray = WordHolder.types;
        int n = WordHolder.types.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            this.updateList(type);
            ++n2;
        }
    }

    private class ClearSelectionAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -548500415146341773L;

        private ClearSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumentSideBar.this.clearSelection();
        }
    }

    private class CopyListAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -562300188506750751L;

        private CopyListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainScreen.ClipboardTextTransfer ctt = new MainScreen.ClipboardTextTransfer();
            String cb = "";
            TreeSet<InstanceHolder<? extends Instance>> hl = DocumentSideBar.this.docModel.getHolderList(DocumentSideBar.this.documentView.getListSelected());
            if (DocumentSideBar.this.sortByFreq) {
                TreeSet<InstanceHolder<? extends Instance>> resorted = new TreeSet<InstanceHolder<? extends Instance>>(new InstanceHolder.FreqComparator());
                resorted.addAll(hl);
                hl = resorted;
            }
            for (InstanceHolder<? extends Instance> ih : hl) {
                cb = String.valueOf(cb) + ih.tabbedString() + "\r";
            }
            ctt.setClipboardContents(cb);
        }
    }

    private class FirstInstanceAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 6157373229601202571L;

        private FirstInstanceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (DocumentSideBar.this.instancesControl) {
                case 56: {
                    DocumentSideBar.this.documentView.changeSelectedInstance(DocumentSideBar.this.docModel.getFirstInstance(DocumentSideBar.this.documentView.getListSelected()));
                    break;
                }
                case 55: {
                    if (DocumentSideBar.this.documentView.getSelectedHolder() == null) {
                        DocumentSideBar.this.wordList.setSelectedIndex(0);
                        DocumentSideBar.this.wordList.ensureIndexIsVisible(0);
                    }
                    if (DocumentSideBar.this.documentView.getSelectedHolder() == null) break;
                    DocumentSideBar.this.documentView.changeSelectedInstance(DocumentSideBar.this.documentView.getSelectedHolder().firstInstance());
                }
            }
        }
    }

    private class LastInstanceAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 6157373229601202571L;

        private LastInstanceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (DocumentSideBar.this.instancesControl) {
                case 56: {
                    DocumentSideBar.this.documentView.changeSelectedInstance(DocumentSideBar.this.docModel.getLastInstance(DocumentSideBar.this.documentView.getListSelected()));
                    break;
                }
                case 55: {
                    if (DocumentSideBar.this.documentView.getSelectedHolder() == null) {
                        int index = DocumentSideBar.this.wordList.getModel().getSize() - 1;
                        DocumentSideBar.this.wordList.setSelectedIndex(index);
                        DocumentSideBar.this.wordList.ensureIndexIsVisible(index);
                    }
                    if (DocumentSideBar.this.documentView.getSelectedHolder() == null) break;
                    DocumentSideBar.this.documentView.changeSelectedInstance(DocumentSideBar.this.documentView.getSelectedHolder().lastInstance());
                }
            }
        }
    }

    private class NextInstanceAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 6157373229601202571L;

        private NextInstanceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (DocumentSideBar.this.instancesControl) {
                case 56: {
                    DocumentSideBar.this.documentView.changeSelectedInstance(DocumentSideBar.this.docModel.getNextInstance(DocumentSideBar.this.documentView.getListSelected(), DocumentSideBar.this.documentView.getSelectedInstance()));
                    break;
                }
                case 55: {
                    if (DocumentSideBar.this.documentView.getSelectedHolder() == null) {
                        DocumentSideBar.this.wordList.setSelectedIndex(0);
                        DocumentSideBar.this.wordList.ensureIndexIsVisible(0);
                    }
                    if (DocumentSideBar.this.documentView.getSelectedHolder() == null) break;
                    DocumentSideBar.this.documentView.changeSelectedInstance(DocumentSideBar.this.documentView.getSelectedHolder().nextInstance(DocumentSideBar.this.documentView.getSelectedInstance()));
                }
            }
        }
    }

    private class PreviousInstanceAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -6606047809322370718L;

        private PreviousInstanceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (DocumentSideBar.this.instancesControl) {
                case 56: {
                    DocumentSideBar.this.documentView.changeSelectedInstance(DocumentSideBar.this.docModel.getPreviousInstance(DocumentSideBar.this.documentView.getListSelected(), DocumentSideBar.this.documentView.getSelectedInstance()));
                    break;
                }
                case 55: {
                    if (DocumentSideBar.this.documentView.getSelectedHolder() == null) {
                        DocumentSideBar.this.wordList.setSelectedIndex(0);
                        DocumentSideBar.this.wordList.ensureIndexIsVisible(0);
                    }
                    if (DocumentSideBar.this.documentView.getSelectedHolder() == null) break;
                    DocumentSideBar.this.documentView.changeSelectedInstance(DocumentSideBar.this.documentView.getSelectedHolder().previousInstance(DocumentSideBar.this.documentView.getSelectedInstance()));
                }
            }
        }
    }

    private class ProcessAllVariantsAction
    extends AbstractAction {
        private static final long serialVersionUID = 4429003620159727500L;

        ProcessAllVariantsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int threshold = (Integer)DocumentSideBar.this.thresholdSpinner.getValue();
            ProcessAllVariantsEdit edit = new ProcessAllVariantsEdit(threshold, false, DocumentSideBar.this.docModel, DocumentSideBar.this.confidenceWeights, DocumentSideBar.this.lud);
            ThreadedProcessEditHolder tEdit = new ThreadedProcessEditHolder(edit);
            tEdit.execute();
            DocumentSideBar.this.undoSupport.postEdit(tEdit);
        }
    }

    private class RadioButtonAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -934709526028658245L;
        private int whichList;

        RadioButtonAction(int whichList) {
            this.whichList = whichList;
            this.putValue("Name", WordHolder.getTypeName(whichList));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.whichList != DocumentSideBar.this.documentView.getListSelected()) {
                new Thread(){

                    @Override
                    public void run() {
                        DocumentSideBar.this.clearSelection();
                        DocumentSideBar.this.documentView.changeList(RadioButtonAction.this.whichList);
                        DocumentSideBar.this.wordList.ensureIndexIsVisible(0);
                    }
                }.start();
            }
        }
    }

    private class SortAZAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 674694575724562435L;

        private SortAZAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DocumentSideBar.this.sortByFreq = false;
            DocumentSideBar.this.updateList(DocumentSideBar.this.documentView.getListSelected());
        }
    }

    private class SortFreqAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 5284539102535688158L;

        private SortFreqAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DocumentSideBar.this.sortByFreq = true;
            DocumentSideBar.this.updateList(DocumentSideBar.this.documentView.getListSelected());
        }
    }

    private class TextInstancesControlAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = 8839177563738773222L;

        private TextInstancesControlAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumentSideBar.this.instancesControl = 56;
            DocumentSideBar.this.documentView.changeSelectedInstance(DocumentSideBar.this.documentView.getSelectedInstance());
        }
    }

    private class TypeInstancesControlAction
    extends AbstractAction
    implements Action {
        private static final long serialVersionUID = -2529346739626338674L;

        private TypeInstancesControlAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumentSideBar.this.instancesControl = 55;
            DocumentSideBar.this.documentView.changeSelectedInstance(DocumentSideBar.this.documentView.getSelectedInstance());
        }
    }
}

